/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.nos.util;

import android.util.DisplayMetrics;
import com.netease.nimlib.b;
import com.netease.nimlib.sdk.nos.model.NosThumbParam;

public class NosThumbImageUtil {
    public static final String makeImageThumbUrl(String string, NosThumbParam.ThumbType thumbType, int n2, int n3) {
        return string + "?" + NosThumbImageUtil.toImageThumbParams(thumbType, n2, n3);
    }

    public static final String makeImageThumbUrl(String string, int n2, int n3) {
        NosThumbParam.ThumbType thumbType = NosThumbParam.ThumbType.Internal;
        if (n3 > 0 && n2 > 0) {
            NosThumbParam.ThumbType thumbType2 = thumbType = (n2 > n3 ? n2 / n3 : n3 / n2) > 4 ? NosThumbParam.ThumbType.External : NosThumbParam.ThumbType.Internal;
        }
        if ((n2 = b.d().thumbnailSize) <= 0) {
            DisplayMetrics displayMetrics = b.a().getApplicationContext().getResources().getDisplayMetrics();
            n2 = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels) / 2;
        }
        return string + "?" + NosThumbImageUtil.toImageThumbParams(thumbType, n2, n2);
    }

    private static final String toImageThumbParams(NosThumbParam.ThumbType thumbType, int n2, int n3) {
        if (!NosThumbImageUtil.checkImageThumb(thumbType, n2, n3)) {
            throw new IllegalArgumentException("width=" + n2 + ", height=" + n3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("thumbnail=");
        stringBuilder.append(n2);
        stringBuilder.append(NosThumbImageUtil.toImageThumbMethod(thumbType));
        stringBuilder.append(n3);
        stringBuilder.append("&imageView");
        return stringBuilder.toString();
    }

    private static final boolean checkImageThumb(NosThumbParam.ThumbType thumbType, int n2, int n3) {
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        switch (thumbType) {
            case Internal: {
                return n2 > 0 || n3 > 0;
            }
            case Crop: 
            case External: {
                return n2 > 0 && n3 > 0;
            }
        }
        return false;
    }

    private static final String toImageThumbMethod(NosThumbParam.ThumbType thumbType) {
        switch (thumbType) {
            case Internal: {
                return "x";
            }
            case Crop: {
                return "y";
            }
            case External: {
                return "z";
            }
        }
        throw new IllegalArgumentException("thumb: " + thumbType);
    }
}

