/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.huawei.hms.a.a;
import com.huawei.hms.api.Api;
import com.huawei.hms.api.ConnectionResult;
import com.huawei.hms.api.internal.b;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.entity.auth.PermissionInfo;
import com.huawei.hms.support.api.entity.auth.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class HuaweiApiClient
implements ApiClient {
    public abstract void connect();

    public abstract void disconnect();

    @Override
    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void setConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void setConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected();

        public void onConnectionSuspended(int var1);
    }

    public static final class Builder {
        private final Context a;
        private final List<Scope> b = new ArrayList<Scope>();
        private final List<PermissionInfo> c = new ArrayList<PermissionInfo>();
        private final Map<Api<?>, Api.ApiOptions> d = new ArrayMap();
        private OnConnectionFailedListener e;
        private ConnectionCallbacks f;

        public Builder(@NonNull Context context) {
            com.huawei.hms.a.a.a(context, "context must not be null.");
            this.a = context.getApplicationContext();
        }

        public HuaweiApiClient build() {
            b b2 = new b(this.a);
            b2.a(this.b);
            b2.b(this.c);
            b2.a(this.d);
            b2.setConnectionCallbacks(this.f);
            b2.setConnectionFailedListener(this.e);
            return b2;
        }

        public Builder addConnectionCallbacks(@NonNull ConnectionCallbacks connectionCallbacks) {
            com.huawei.hms.a.a.a(connectionCallbacks, "listener must not be null.");
            this.f = connectionCallbacks;
            return this;
        }

        public Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener onConnectionFailedListener) {
            com.huawei.hms.a.a.a(onConnectionFailedListener, "listener must not be null.");
            this.e = onConnectionFailedListener;
            return this;
        }

        public Builder addScope(@NonNull Scope scope) {
            com.huawei.hms.a.a.a(scope, "scope must not be null.");
            this.b.add(scope);
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.d.put(api, null);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O o2) {
            com.huawei.hms.a.a.a(api, "Api must not be null");
            com.huawei.hms.a.a.a(o2, "Null options are not permitted for this Api");
            this.d.put(api, o2);
            List<Scope> list = api.getOptions().getScopeList(o2);
            this.b.addAll(list);
            List<PermissionInfo> list2 = api.getOptions().getPermissionInfoList(o2);
            this.c.addAll(list2);
            return this;
        }
    }
}

