/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.voice.device;

import android.media.AudioTrack;
import android.os.Process;
import com.netease.nrtc.base.Trace;
import com.netease.nrtc.utility.a.b;
import java.nio.ByteBuffer;

@com.netease.nrtc.base.annotation.a
public class RtcAudioTrack {
    private final long a;
    private ByteBuffer b;
    private AudioTrack c = null;
    private a d = null;

    @com.netease.nrtc.base.annotation.a
    RtcAudioTrack(long l) {
        Trace.c("RtcAudioTrack", "ctor");
        this.a = l;
    }

    @com.netease.nrtc.base.annotation.a
    private boolean initPlayout(int n, int n2) {
        Trace.c("RtcAudioTrack", "initPlayout(sampleRate=" + n + ", channels=" + n2 + ")");
        int n3 = n2 << 1;
        this.b = ByteBuffer.allocateDirect(n3 * (n / 100));
        Trace.c("RtcAudioTrack", "byteBuffer.capacity: " + this.b.capacity());
        this.nativeCacheDirectBufferAddress(this.b, this.a);
        n2 = n2 == 1 ? 4 : 12;
        n3 = AudioTrack.getMinBufferSize((int)n, (int)n2, (int)2);
        Trace.c("RtcAudioTrack", "AudioTrack.getMinBufferSize: " + n3);
        if (n3 < this.b.capacity()) {
            Trace.b("RtcAudioTrack", "AudioTrack.getMinBufferSize returns an invalid value.");
            return false;
        }
        if (this.c != null) {
            Trace.b("RtcAudioTrack", "Conflict with existing AudioTrack.");
            return false;
        }
        try {
            this.c = new AudioTrack(0, n, n2, 2, n3, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Trace.c("RtcAudioTrack", illegalArgumentException.getMessage());
            this.a();
            return false;
        }
        if (this.c == null || this.c.getState() != 1) {
            Trace.b("RtcAudioTrack", "Initialization of audio track failed.");
            this.a();
            return false;
        }
        RtcAudioTrack rtcAudioTrack = this;
        Trace.c("RtcAudioTrack", "AudioTrack: session ID: " + rtcAudioTrack.c.getAudioSessionId() + ", channels: " + rtcAudioTrack.c.getChannelCount() + ", sample rate: " + rtcAudioTrack.c.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume());
        rtcAudioTrack = this;
        if (com.netease.nrtc.utility.a.b.a(23)) {
            Trace.c("RtcAudioTrack", "AudioTrack: buffer size in frames: " + rtcAudioTrack.c.getBufferSizeInFrames());
        }
        if (com.netease.nrtc.utility.a.b.a(24)) {
            Trace.c("RtcAudioTrack", "AudioTrack: buffer capacity in frames: " + rtcAudioTrack.c.getBufferCapacityInFrames());
        }
        return true;
    }

    @com.netease.nrtc.base.annotation.a
    private boolean startPlayout() {
        Trace.c("RtcAudioTrack", "startPlayout");
        com.netease.nrtc.base.b.a(this.c != null);
        com.netease.nrtc.base.b.a(this.d == null);
        if (this.c.getState() != 1) {
            Trace.b("RtcAudioTrack", "AudioTrack instance is not successfully initialized.");
            return false;
        }
        this.d = new a("nrtc_audio_output");
        this.d.start();
        return true;
    }

    @com.netease.nrtc.base.annotation.a
    private boolean stopPlayout() {
        Trace.c("RtcAudioTrack", "stopPlayout");
        com.netease.nrtc.base.b.a(this.d != null);
        RtcAudioTrack rtcAudioTrack = this;
        if (com.netease.nrtc.utility.a.b.a(24)) {
            Trace.a("RtcAudioTrack", "underrun count: " + rtcAudioTrack.c.getUnderrunCount());
        }
        this.d.a();
        this.d = null;
        this.a();
        return true;
    }

    private void a() {
        Trace.c("RtcAudioTrack", "releaseAudioResources");
        if (this.c != null) {
            this.c.release();
            this.c = null;
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    private final class a
    extends Thread {
        private volatile boolean b;

        a(String string) {
            super(string);
            this.b = true;
        }

        @Override
        public final void run() {
            Process.setThreadPriority((int)-19);
            Trace.c("RtcAudioTrack", "audio track thread run");
            try {
                RtcAudioTrack.this.c.play();
                com.netease.nrtc.base.b.a(RtcAudioTrack.this.c.getPlayState() == 3);
            }
            catch (IllegalStateException illegalStateException) {
                Trace.b("RtcAudioTrack", "AudioTrack.play failed: " + illegalStateException.getMessage());
                RtcAudioTrack.this.a();
                return;
            }
            int n = RtcAudioTrack.this.b.capacity();
            while (this.b) {
                int n2;
                RtcAudioTrack.this.nativeGetPlayoutData(n, RtcAudioTrack.this.a);
                com.netease.nrtc.base.b.a(n <= RtcAudioTrack.this.b.remaining());
                if (com.netease.nrtc.utility.a.b.a(21)) {
                    n2 = RtcAudioTrack.this.c.write(RtcAudioTrack.this.b, n, 0);
                } else {
                    ByteBuffer byteBuffer = RtcAudioTrack.this.b;
                    n2 = RtcAudioTrack.this.c.write(byteBuffer.array(), byteBuffer.arrayOffset(), n);
                }
                if (n2 != n) {
                    Trace.b("RtcAudioTrack", "AudioTrack.write failed: " + n2);
                    if (n2 == -3) {
                        this.b = false;
                    }
                }
                RtcAudioTrack.this.b.rewind();
            }
            try {
                RtcAudioTrack.this.c.stop();
            }
            catch (IllegalStateException illegalStateException) {
                Trace.b("RtcAudioTrack", "AudioTrack.stop failed: " + illegalStateException.getMessage());
            }
            com.netease.nrtc.base.b.a(RtcAudioTrack.this.c.getPlayState() == 1);
            RtcAudioTrack.this.c.flush();
        }

        final void a() {
            this.b = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

