/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.video.render;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Point;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.netease.nrtc.base.Trace;
import com.netease.nrtc.base.f.b;
import com.netease.nrtc.video.gl.EglBase;
import com.netease.nrtc.video.gl.GlCommon;
import com.netease.nrtc.video.gl.GlDrawer;
import com.netease.nrtc.video.gl.c;
import com.netease.nrtc.video.gl.e;
import com.netease.nrtc.video.gl.g;
import com.netease.nrtc.video.render.I420Buffer;
import com.netease.nrtc.video.render.IVideoRender;
import com.netease.nrtc.video.render.NativeVideoRenderer;
import com.netease.nrtc.video.render.RendererEvents;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class SurfaceViewRender
extends SurfaceView
implements SurfaceHolder.Callback,
IVideoRender {
    private static AtomicInteger threadId = new AtomicInteger(0);
    private static final String TAG = "SurfaceViewRender";
    private long sessionId = 0L;
    private final Object sessionLock = new Object();
    private HandlerThread renderThread;
    private final Object handlerLock = new Object();
    private Handler renderThreadHandler;
    private EglBase eglBase;
    private GlDrawer drawer;
    private final g yuvUploader = new g();
    private int[] yuvTextures = null;
    private final Object frameLock = new Object();
    private I420Buffer pendingFrame;
    private final Object layoutLock = new Object();
    private Point desiredLayoutSize = new Point();
    private final Point layoutSize = new Point();
    private final Point surfaceSize = new Point();
    private boolean isSurfaceCreated;
    private int frameWidth;
    private int frameHeight;
    private int frameRotation;
    private GlCommon.ScalingType scalingType = GlCommon.ScalingType.SCALE_ASPECT_BALANCED;
    private boolean mirror;
    private RendererEvents rendererEvents;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long firstFrameTimeNs;
    private long renderTimeNs;
    private static final int FPS_PERIOD_MS = 4000;
    private a fpsStatistics;
    private final Runnable fpsRunnable = new Runnable(){

        @Override
        public final void run() {
            a a2 = SurfaceViewRender.this.fpsStatistics;
            int n = a2.a;
            a2.a = 0;
            int n2 = (n * 1000 + 2000) / 4000;
            if (SurfaceViewRender.this.rendererEvents != null) {
                SurfaceViewRender.this.rendererEvents.d(n2);
            }
            SurfaceViewRender.this.runOnRenderThread(this, 4000L);
        }
    };
    private final Runnable renderFrameRunnable = new Runnable(){

        @Override
        public final void run() {
            SurfaceViewRender.this.renderFrameOnRenderThread();
        }
    };
    private final Runnable makeBlackRunnable = new Runnable(){

        @Override
        public final void run() {
            SurfaceViewRender.this.makeBlack();
        }
    };

    private void makeBlack() {
        if (Thread.currentThread() != this.renderThread) {
            throw new IllegalStateException("SurfaceViewRender(" + this.sessionId + ") Wrong thread.");
        }
        Trace.c(TAG, this.getAttachedSession(), "make black!!!");
        if (this.eglBase != null && this.eglBase.c()) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.eglBase.j();
        }
    }

    public SurfaceViewRender(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    @TargetApi(value=21)
    public SurfaceViewRender(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public SurfaceViewRender(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public SurfaceViewRender(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void init(EglBase.Context context, RendererEvents rendererEvents) {
        this.init(context, rendererEvents, EglBase.b, new c());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(final EglBase.Context context, RendererEvents rendererEvents, final int[] nArray, GlDrawer glDrawer) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException("SurfaceViewRender(" + this.sessionId + ") Already initialized");
            }
            this.rendererEvents = rendererEvents;
            this.drawer = glDrawer;
            this.renderThread = new HandlerThread("nrtc_video_render_" + threadId.getAndAdd(1), -8);
            this.renderThread.start();
            this.renderThreadHandler = new Handler(this.renderThread.getLooper());
            this.fpsStatistics = new a();
            this.runOnRenderThread(this.fpsRunnable, 4000L);
            this.runOnRenderThread(new Runnable(){

                @Override
                public final void run() {
                    Trace.a(SurfaceViewRender.TAG, SurfaceViewRender.this.getAttachedSession(), "create egl context," + (context == null ? " no shared context." : " has shared context."));
                    if (context == null) {
                        SurfaceViewRender.this.eglBase = EglBase.a(nArray);
                        return;
                    }
                    SurfaceViewRender.this.eglBase = EglBase.a(context, nArray);
                }
            });
        }
        this.tryCreateEglSurface();
    }

    private void tryCreateEglSurface() {
        this.runOnRenderThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                Object object = SurfaceViewRender.this.layoutLock;
                synchronized (object) {
                    if (SurfaceViewRender.this.eglBase != null && SurfaceViewRender.this.isSurfaceCreated && !SurfaceViewRender.this.eglBase.c()) {
                        SurfaceViewRender.this.eglBase.a(SurfaceViewRender.this.getHolder().getSurface());
                        SurfaceViewRender.this.eglBase.h();
                        GLES20.glPixelStorei((int)3317, (int)1);
                    }
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalingType(GlCommon.ScalingType scalingType) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.scalingType = scalingType;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceCreated(SurfaceHolder object) {
        Trace.a(TAG, this.getAttachedSession(), "surfaceCreated");
        object = this.layoutLock;
        synchronized (object) {
            this.isSurfaceCreated = true;
        }
        this.tryCreateEglSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceChanged(SurfaceHolder object, int n, int n2, int n3) {
        Trace.a(TAG, this.getAttachedSession(), "surfaceChanged: " + n2 + "x" + n3);
        object = this.layoutLock;
        synchronized (object) {
            this.surfaceSize.x = n2;
            this.surfaceSize.y = n3;
        }
        this.runOnRenderThread(this.renderFrameRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder object) {
        Trace.a(TAG, this.getAttachedSession(), "surfaceDestroyed");
        object = this.layoutLock;
        synchronized (object) {
            this.isSurfaceCreated = false;
            this.surfaceSize.x = 0;
            this.surfaceSize.y = 0;
        }
        this.runOnRenderThread(new Runnable(){

            @Override
            public final void run() {
                if (SurfaceViewRender.this.eglBase != null) {
                    SurfaceViewRender.this.eglBase.i();
                    SurfaceViewRender.this.eglBase.f();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int n, int n2) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.frameWidth == 0 || this.frameHeight == 0) {
                super.onMeasure(n, n2);
                return;
            }
            this.desiredLayoutSize = this.getDesiredLayoutSize(n, n2);
            n = this.desiredLayoutSize.x != this.getMeasuredWidth() || this.desiredLayoutSize.y != this.getMeasuredHeight() ? 1 : 0;
            this.setMeasuredDimension(this.desiredLayoutSize.x, this.desiredLayoutSize.y);
        }
        if (n != 0) {
            object = this.handlerLock;
            synchronized (object) {
                if (this.renderThreadHandler != null) {
                    this.renderThreadHandler.postAtFrontOfQueue(this.makeBlackRunnable);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        Trace.a(TAG, this.getAttachedSession(), "onLayout: " + n + "," + n2 + "," + n3 + "," + n4);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutSize.x = n3 - n;
            this.layoutSize.y = n4 - n2;
        }
        this.runOnRenderThread(this.renderFrameRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Point getDesiredLayoutSize(int n, int n2) {
        Object object = this.layoutLock;
        synchronized (object) {
            int n3 = SurfaceViewRender.getDefaultSize((int)Integer.MAX_VALUE, (int)n);
            int n4 = SurfaceViewRender.getDefaultSize((int)Integer.MAX_VALUE, (int)n2);
            Point point = GlCommon.a(this.scalingType, this.frameAspectRatio(), n3, n4);
            if (View.MeasureSpec.getMode((int)n) == 0x40000000) {
                point.x = n3;
            }
            if (View.MeasureSpec.getMode((int)n2) == 0x40000000) {
                point.y = n4;
            }
            return point;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float frameAspectRatio() {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.frameWidth == 0 || this.frameHeight == 0) {
                return 0.0f;
            }
            return this.frameRotation % 180 == 0 ? (float)this.frameWidth / (float)this.frameHeight : (float)this.frameHeight / (float)this.frameWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnRenderThread(Runnable runnable, long l) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.postDelayed(runnable, l);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Trace.a(TAG, this.getAttachedSession(), "release");
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public final void run() {
                    SurfaceViewRender.this.drawer.a();
                    SurfaceViewRender.this.drawer = null;
                    if (SurfaceViewRender.this.yuvTextures != null) {
                        GLES20.glDeleteTextures((int)3, (int[])SurfaceViewRender.this.yuvTextures, (int)0);
                        SurfaceViewRender.access$902(SurfaceViewRender.this, null);
                    }
                    SurfaceViewRender.this.makeBlack();
                    SurfaceViewRender.this.eglBase.g();
                    SurfaceViewRender.this.eglBase = null;
                    countDownLatch.countDown();
                }
            });
            this.renderThreadHandler = null;
        }
        b.a(countDownLatch);
        this.renderThread.quit();
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                NativeVideoRenderer.a(this.pendingFrame);
                this.pendingFrame = null;
            }
        }
        b.b((Thread)this.renderThread);
        this.renderThread = null;
        object = this.layoutLock;
        synchronized (object) {
            this.frameWidth = 0;
            this.frameHeight = 0;
            this.frameRotation = 0;
            this.rendererEvents = null;
        }
        this.fpsStatistics = null;
        this.resetStatistics();
        Trace.a(TAG, this.getAttachedSession(), "release done");
        this.detachFromSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics() {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.firstFrameTimeNs = 0L;
            this.renderTimeNs = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        Object object = this.statisticsLock;
        synchronized (object) {
            Trace.a(TAG, this.getAttachedSession(), "Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered);
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                long l = System.nanoTime() - this.firstFrameTimeNs;
                Trace.a(TAG, this.getAttachedSession(), "Duration: " + (int)((double)l / 1000000.0) + " ms. FPS: " + (double)this.framesRendered * 1.0E9 / (double)l);
                Trace.a(TAG, this.getAttachedSession(), "Average render time: " + (int)(this.renderTimeNs / (long)(1000 * this.framesRendered)) + " us.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderFrame(I420Buffer i420Buffer) {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                NativeVideoRenderer.a(i420Buffer);
                return;
            }
            Object object2 = this.frameLock;
            synchronized (object2) {
                if (this.pendingFrame != null) {
                    Object object3 = this.statisticsLock;
                    synchronized (object3) {
                        ++this.framesDropped;
                    }
                    NativeVideoRenderer.a(this.pendingFrame);
                }
                this.pendingFrame = i420Buffer;
                this.renderThreadHandler.post(this.renderFrameRunnable);
            }
            return;
        }
    }

    @Override
    public final boolean initialize() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean attachToSession(long l) {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.sessionId != 0L) {
                return l == this.sessionId;
            }
            this.sessionId = l;
            return this.sessionId != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isAttachedToSession() {
        Object object = this.sessionLock;
        synchronized (object) {
            return this.sessionId != 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void detachFromSession() {
        Object object = this.sessionLock;
        synchronized (object) {
            this.sessionId = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getAttachedSession() {
        Object object = this.sessionLock;
        synchronized (object) {
            return this.sessionId;
        }
    }

    @Override
    public final boolean isExternalRender() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void renderFrameOnRenderThread() {
        if (Thread.currentThread() != this.renderThread) {
            throw new IllegalStateException("SurfaceViewRender(" + this.sessionId + ") Wrong thread.");
        }
        Object object = this.frameLock;
        // MONITORENTER : object
        if (this.pendingFrame == null) {
            // MONITOREXIT : object
            return;
        }
        I420Buffer i420Buffer = this.pendingFrame;
        this.pendingFrame = null;
        // MONITOREXIT : object
        this.updateFrameDimensionsAndReportEvents(i420Buffer);
        if (this.eglBase == null || !this.eglBase.c()) {
            NativeVideoRenderer.a(i420Buffer);
            return;
        }
        if (!this.checkConsistentLayout()) {
            this.makeBlack();
            NativeVideoRenderer.a(i420Buffer);
            return;
        }
        object = this.layoutLock;
        // MONITORENTER : object
        if (this.eglBase.d() != this.surfaceSize.x || this.eglBase.e() != this.surfaceSize.y) {
            this.makeBlack();
        }
        // MONITOREXIT : object
        long l = System.nanoTime();
        Object object2 = this.layoutLock;
        // MONITORENTER : object2
        Object object3 = GlCommon.a(i420Buffer.f, i420Buffer.i);
        float[] fArray = GlCommon.a(this.mirror, this.frameAspectRatio(), (float)this.layoutSize.x / (float)this.layoutSize.y);
        object3 = GlCommon.a(object3, fArray);
        // MONITOREXIT : object2
        GLES20.glClear((int)16384);
        if (i420Buffer.e) {
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (int k = 0; k < 3; ++k) {
                    this.yuvTextures[k] = e.a(3553);
                }
            }
            this.yuvUploader.a(this.yuvTextures, i420Buffer.a, i420Buffer.b, i420Buffer.c, i420Buffer.d);
            this.drawer.a(this.yuvTextures, (float[])object3, this.surfaceSize.x, this.surfaceSize.y);
        } else {
            this.drawer.a(i420Buffer.g, (float[])object3, this.surfaceSize.x, this.surfaceSize.y);
        }
        this.eglBase.j();
        NativeVideoRenderer.a(i420Buffer);
        ++this.fpsStatistics.a;
        object2 = this.statisticsLock;
        // MONITORENTER : object2
        if (this.framesRendered == 0) {
            this.firstFrameTimeNs = l;
            Object object4 = this.layoutLock;
            object3 = object4;
            // MONITORENTER : object4
            if (this.rendererEvents != null) {
                this.rendererEvents.h();
            }
            // MONITOREXIT : object3
        }
        ++this.framesRendered;
        this.renderTimeNs += System.nanoTime() - l;
        if (this.framesRendered % 1500 == 0) {
            this.logStatistics();
        }
        // MONITOREXIT : object2
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConsistentLayout() {
        if (Thread.currentThread() != this.renderThread) {
            throw new IllegalStateException("SurfaceViewRender(" + this.sessionId + ") Wrong thread.");
        }
        Object object = this.layoutLock;
        synchronized (object) {
            return this.layoutSize.equals((Object)this.desiredLayoutSize) && this.surfaceSize.equals((Object)this.layoutSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(I420Buffer i420Buffer) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.frameWidth != i420Buffer.a || this.frameHeight != i420Buffer.b || this.frameRotation != i420Buffer.i) {
                Trace.c(TAG, this.getAttachedSession(), "Reporting frame resolution changed to " + i420Buffer.a + "x" + i420Buffer.b + " with rotation " + i420Buffer.i);
                if (this.rendererEvents != null) {
                    this.rendererEvents.a(i420Buffer.a, i420Buffer.b, i420Buffer.i);
                }
                int n = this.frameRotation == 90 || this.frameRotation == 270 ? 1 : 0;
                int n2 = n != 0 ? this.frameHeight : this.frameWidth;
                n = n != 0 ? this.frameWidth : this.frameHeight;
                int n3 = i420Buffer.i == 90 || i420Buffer.i == 270 ? 1 : 0;
                int n4 = n3 != 0 ? i420Buffer.b : i420Buffer.a;
                n3 = n3 != 0 ? i420Buffer.a : i420Buffer.b;
                n = n2 != n4 || n != n3 ? 1 : 0;
                this.frameWidth = i420Buffer.a;
                this.frameHeight = i420Buffer.b;
                this.frameRotation = i420Buffer.i;
                if (n != 0) {
                    this.post(new Runnable(){

                        @Override
                        public final void run() {
                            SurfaceViewRender.this.requestLayout();
                        }
                    });
                }
            }
            return;
        }
    }

    public String toString() {
        return Integer.toHexString(this.hashCode());
    }

    static /* synthetic */ int[] access$902(SurfaceViewRender surfaceViewRender, int[] nArray) {
        surfaceViewRender.yuvTextures = nArray;
        return nArray;
    }

    private static final class a {
        int a = 0;

        a() {
        }
    }
}

