/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.video.codec;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.netease.nrtc.base.Trace;
import com.netease.nrtc.base.f.b;
import com.netease.nrtc.video.codec.CodecManager;
import com.netease.nrtc.video.codec.a;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;

@TargetApi(value=19)
@com.netease.nrtc.base.annotation.a
public class VideoHwEncoder {
    @com.netease.nrtc.base.annotation.a
    private static VideoHwEncoder runningInstance = null;
    @com.netease.nrtc.base.annotation.a
    private Thread mediaCodecThread;
    @com.netease.nrtc.base.annotation.a
    private MediaCodec mediaCodec;
    @com.netease.nrtc.base.annotation.a
    private int width;
    @com.netease.nrtc.base.annotation.a
    private int height;
    @com.netease.nrtc.base.annotation.a
    private int videoCodecType;
    @com.netease.nrtc.base.annotation.a
    private int colorFormat;
    @com.netease.nrtc.base.annotation.a
    private ByteBuffer[] outputBuffers;
    @com.netease.nrtc.base.annotation.a
    private ByteBuffer configData = null;
    Handler a = new Handler(Looper.myLooper());
    private long b;
    private Runnable c = new Runnable(){

        @Override
        public final void run() {
            VideoHwEncoder.nativeRunDeliverPendingOutputsTask(VideoHwEncoder.this.b);
        }
    };

    @com.netease.nrtc.base.annotation.a
    boolean init(int n, int n2, int n3, int n4, int n5) {
        Trace.a("VideoHwEncoder_J", "init hw encoder: " + n + " : " + n2 + " x " + n3 + ". @ " + n4 + " bps. Fps: " + n5 + ".");
        this.width = n2;
        this.height = n3;
        if (this.mediaCodecThread != null) {
            Trace.b("VideoHwEncoder_J", "HW Encoder already exist!");
            return false;
        }
        a.b b2 = null;
        String string = null;
        if (n == 4) {
            string = "video/avc";
            b2 = CodecManager.d();
        }
        if (b2 == null) {
            Trace.b("VideoHwEncoder_J", "Can not find HW encoder for " + n);
            return false;
        }
        runningInstance = this;
        this.colorFormat = b2.b;
        this.mediaCodecThread = Thread.currentThread();
        try {
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n2, (int)n3);
            mediaFormat.setInteger("bitrate", n4);
            mediaFormat.setInteger("bitrate-mode", 2);
            mediaFormat.setInteger("color-format", b2.b);
            mediaFormat.setInteger("frame-rate", n5);
            mediaFormat.setInteger("i-frame-interval", 1);
            Trace.c("VideoHwEncoder_J", "  Format: " + mediaFormat);
            this.mediaCodec = com.netease.nrtc.video.codec.a.a(b2.a);
            this.videoCodecType = n;
            if (this.mediaCodec == null) {
                Trace.b("VideoHwEncoder_J", "Can not create media encoder");
                return false;
            }
            this.mediaCodec.configure(mediaFormat, null, null, 1);
            this.mediaCodec.start();
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            Trace.a("VideoHwEncoder_J", "Output buffers: " + this.outputBuffers.length);
        }
        catch (Exception exception) {
            Trace.b("VideoHwEncoder_J", "init hw encoder failed" + exception);
            return false;
        }
        return true;
    }

    @com.netease.nrtc.base.annotation.a
    void release() {
        Trace.a("VideoHwEncoder_J", "release encoder");
        this.a();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runnable runnable = new Runnable(){

            @Override
            public final void run() {
                try {
                    Trace.c("VideoHwEncoder_J", "release hw encoder on release thread");
                    VideoHwEncoder.this.mediaCodec.stop();
                    VideoHwEncoder.this.mediaCodec.release();
                    Trace.a("VideoHwEncoder_J", "release hw encoder on release thread done");
                }
                catch (Exception exception) {
                    Trace.b("VideoHwEncoder_J", "encoder release failed" + exception);
                }
                countDownLatch.countDown();
            }
        };
        new Thread(runnable).start();
        if (!com.netease.nrtc.base.f.b.a(countDownLatch, 1000L)) {
            Trace.b("VideoHwEncoder_J", "encoder release timeout");
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        Trace.a("VideoHwEncoder_J", "releaseEncoder done");
    }

    private void a() {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new RuntimeException("VideoHwEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    @com.netease.nrtc.base.annotation.a
    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = this.mediaCodec.getInputBuffers();
        Trace.c("VideoHwEncoder_J", "Input buffers: " + byteBufferArray.length);
        return byteBufferArray;
    }

    @com.netease.nrtc.base.annotation.a
    int dequeueInputBuffer() {
        this.a();
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            return -2;
        }
    }

    @com.netease.nrtc.base.annotation.a
    boolean encodeBuffer(boolean bl, int n, int n2, long l) {
        this.a();
        try {
            if (bl) {
                Trace.c("VideoHwEncoder_J", "Sync frame request");
                Bundle bundle = new Bundle();
                bundle.putInt("request-sync", 0);
                this.mediaCodec.setParameters(bundle);
            }
            this.mediaCodec.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Trace.b("VideoHwEncoder_J", "encodeBuffer failed" + illegalStateException);
            return false;
        }
    }

    @com.netease.nrtc.base.annotation.a
    boolean setBitrates(int n) {
        this.a();
        Trace.a("VideoHwEncoder_J", "setRates: " + n + " bps.");
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", n);
            this.mediaCodec.setParameters(bundle);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Trace.b("VideoHwEncoder_J", "setRates failed" + illegalStateException);
            return false;
        }
    }

    @com.netease.nrtc.base.annotation.a
    void deliverPendingOutputs(long l, int n) {
        this.b = l;
        this.a.postDelayed(this.c, (long)n);
    }

    @com.netease.nrtc.base.annotation.a
    void clearDeliverRunnable() {
        Trace.a("VideoHwEncoder_J", "clear pending deliver");
        this.a.removeCallbacks(this.c);
        this.b = 0L;
    }

    static native void nativeRunDeliverPendingOutputsTask(long var0);

    @com.netease.nrtc.base.annotation.a
    EncodedOutputBufferInfo dequeueOutputBuffer() {
        int n;
        block8: {
            this.a();
            try {
                MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
                n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                if (n >= 0 && (bufferInfo.flags & 2) != 0) {
                    this.configData = ByteBuffer.allocateDirect(bufferInfo.size);
                    this.outputBuffers[n].position(bufferInfo.offset);
                    this.outputBuffers[n].limit(bufferInfo.offset + bufferInfo.size);
                    this.configData.put(this.outputBuffers[n]);
                    this.mediaCodec.releaseOutputBuffer(n, false);
                    n = this.mediaCodec.dequeueOutputBuffer(bufferInfo, 0L);
                }
                if (n >= 0) {
                    ByteBuffer byteBuffer = this.outputBuffers[n].duplicate();
                    byteBuffer.position(bufferInfo.offset);
                    byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
                    boolean bl = (bufferInfo.flags & 1) != 0;
                    if (bl && this.videoCodecType == 4) {
                        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(this.configData.capacity() + bufferInfo.size);
                        this.configData.rewind();
                        byteBuffer2.put(this.configData);
                        byteBuffer2.put(byteBuffer);
                        byteBuffer2.position(0);
                        return new EncodedOutputBufferInfo(n, byteBuffer2, true, bufferInfo.presentationTimeUs);
                    }
                    return new EncodedOutputBufferInfo(n, byteBuffer.slice(), bl, bufferInfo.presentationTimeUs);
                }
                if (n == -3) {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    return this.dequeueOutputBuffer();
                }
                if (n == -2) {
                    return this.dequeueOutputBuffer();
                }
                if (n != -1) break block8;
                return null;
            }
            catch (Exception exception) {
                Trace.b("VideoHwEncoder_J", "dequeueOutputBuffer failed" + exception);
                return new EncodedOutputBufferInfo(-1, null, false, -1L);
            }
        }
        Trace.b("VideoHwEncoder_J", "dequeueOutputBuffer: " + n);
        return null;
    }

    @com.netease.nrtc.base.annotation.a
    boolean releaseOutputBuffer(int n) {
        this.a();
        try {
            this.mediaCodec.releaseOutputBuffer(n, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Trace.b("VideoHwEncoder_J", "releaseOutputBuffer failed" + illegalStateException);
            return false;
        }
    }

    @com.netease.nrtc.base.annotation.a
    static class EncodedOutputBufferInfo {
        @com.netease.nrtc.base.annotation.a
        public final int index;
        @com.netease.nrtc.base.annotation.a
        public final ByteBuffer buffer;
        @com.netease.nrtc.base.annotation.a
        public final boolean isKeyFrame;
        @com.netease.nrtc.base.annotation.a
        public final long presentationTimestampUs;

        public EncodedOutputBufferInfo(int n, ByteBuffer byteBuffer, boolean bl, long l) {
            this.index = n;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l;
        }
    }
}

