/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps2d.overlay;

import android.content.Context;
import android.graphics.Bitmap;
import com.amap.api.mapcore2d.x;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.model.BitmapDescriptor;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.LatLngBounds;
import com.amap.api.maps2d.model.Marker;
import com.amap.api.maps2d.model.MarkerOptions;
import com.amap.api.maps2d.model.Polyline;
import com.amap.api.maps2d.model.PolylineOptions;
import com.amap.api.maps2d.overlay.a;
import com.amap.api.maps2d.overlay.b;
import com.amap.api.services.core.LatLonPoint;
import com.amap.api.services.route.DrivePath;
import com.amap.api.services.route.DriveStep;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrivingRouteOverlay
extends b {
    private DrivePath a;
    private Bitmap b;
    protected List<Marker> mPassByMarkers = new ArrayList<Marker>();
    private List<LatLonPoint> c;
    private boolean d = true;

    public DrivingRouteOverlay(Context context, AMap aMap, DrivePath drivePath, LatLonPoint latLonPoint, LatLonPoint latLonPoint2) {
        super(context);
        this.mAMap = aMap;
        this.a = drivePath;
        this.startPoint = com.amap.api.maps2d.overlay.a.a(latLonPoint);
        this.endPoint = com.amap.api.maps2d.overlay.a.a(latLonPoint2);
    }

    public DrivingRouteOverlay(Context context, AMap aMap, DrivePath drivePath, LatLonPoint latLonPoint, LatLonPoint latLonPoint2, List<LatLonPoint> list) {
        super(context);
        this.mAMap = aMap;
        this.a = drivePath;
        this.startPoint = com.amap.api.maps2d.overlay.a.a(latLonPoint);
        this.endPoint = com.amap.api.maps2d.overlay.a.a(latLonPoint2);
        this.c = list;
    }

    public void addToMap() {
        List list = this.a.getSteps();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object;
            Object object2;
            DriveStep driveStep = (DriveStep)list.get(i2);
            LatLng latLng = com.amap.api.maps2d.overlay.a.a((LatLonPoint)driveStep.getPolyline().get(0));
            if (i2 < list.size() - 1) {
                if (i2 == 0) {
                    object2 = this.mAMap.addPolyline(new PolylineOptions().add(this.startPoint, latLng).color(this.getDriveColor()).width(this.getBuslineWidth()));
                    this.allPolyLines.add(object2);
                }
                if (!((LatLng)(object2 = com.amap.api.maps2d.overlay.a.a((LatLonPoint)driveStep.getPolyline().get(driveStep.getPolyline().size() - 1)))).equals(object = com.amap.api.maps2d.overlay.a.a((LatLonPoint)((DriveStep)list.get(i2 + 1)).getPolyline().get(0)))) {
                    Polyline polyline = this.mAMap.addPolyline(new PolylineOptions().add(new LatLng[]{object2, object}).color(this.getDriveColor()).width(this.getBuslineWidth()));
                    this.allPolyLines.add(polyline);
                }
            } else {
                object2 = com.amap.api.maps2d.overlay.a.a((LatLonPoint)driveStep.getPolyline().get(driveStep.getPolyline().size() - 1));
                object = this.mAMap.addPolyline(new PolylineOptions().add(new LatLng[]{object2, this.endPoint}).color(this.getDriveColor()).width(this.getBuslineWidth()));
                this.allPolyLines.add(object);
            }
            object2 = this.mAMap.addMarker(new MarkerOptions().position(latLng).title("\u65b9\u5411:" + driveStep.getAction() + "\n\u9053\u8def:" + driveStep.getRoad()).snippet(driveStep.getInstruction()).anchor(0.5f, 0.5f).visible(this.mNodeIconVisible).icon(this.getDriveBitmapDescriptor()));
            this.stationMarkers.add(object2);
            object = this.mAMap.addPolyline(new PolylineOptions().addAll(com.amap.api.maps2d.overlay.a.a(driveStep.getPolyline())).color(this.getDriveColor()).width(this.getBuslineWidth()));
            this.allPolyLines.add(object);
        }
        this.a();
        this.addStartAndEndMarker();
    }

    private void a() {
        if (this.c == null || this.c.size() == 0) {
            return;
        }
        for (LatLonPoint latLonPoint : this.c) {
            LatLng latLng = com.amap.api.maps2d.overlay.a.a(latLonPoint);
            Marker marker = this.mAMap.addMarker(new MarkerOptions().position(latLng).title("\u9014\u7ecf\u70b9").visible(this.d).icon(this.getPassedByBitmapDescriptor()));
            this.mPassByMarkers.add(marker);
        }
    }

    @Override
    public void removeFromMap() {
        super.removeFromMap();
        for (Marker marker : this.mPassByMarkers) {
            marker.remove();
        }
    }

    public void setThroughPointIconVisibility(boolean bl2) {
        this.d = bl2;
        for (Marker marker : this.mPassByMarkers) {
            marker.setVisible(bl2);
        }
        this.mAMap.postInvalidate();
    }

    protected float getBuslineWidth() {
        return x.b;
    }

    protected BitmapDescriptor getPassedByBitmapDescriptor() {
        return this.getBitDes(this.b, "amap_throughpoint.png");
    }

    @Override
    protected LatLngBounds getLatLngBounds() {
        LatLngBounds.Builder builder = LatLngBounds.builder();
        builder.include(new LatLng(this.startPoint.latitude, this.startPoint.longitude));
        builder.include(new LatLng(this.endPoint.latitude, this.endPoint.longitude));
        if (this.c != null && this.c.size() > 0) {
            for (int i2 = 0; i2 < this.c.size(); ++i2) {
                builder.include(new LatLng(this.c.get(i2).getLatitude(), this.c.get(i2).getLongitude()));
            }
        }
        return builder.build();
    }
}

