/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.avchat.model;

import com.netease.nrtc.base.annotation.FloatRange;
import com.netease.nrtc.base.annotation.IntDef;
import com.netease.nrtc.base.annotation.Runtime;
import com.netease.nrtc.base.annotation.StringDef;
import com.netease.nrtc.base.annotation.Writable;
import com.netease.nrtc.engine.rawapi.RtcKey;
import com.netease.nrtc.engine.rawapi.RtcParameters;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class AVChatParameters {
    @IntDef(value={0, 1, 2, 3})
    @Writable
    public static final Key<Integer> KEY_DEVICE_DEFAULT_ROTATION = new Key<Integer>("key_device_default_rotation", Integer.class);
    @IntDef(value={0, 1, 2, 3})
    @Writable
    public static final Key<Integer> KEY_DEVICE_ROTATION_FIXED_OFFSET = new Key<Integer>("key_device_rotation_fixed_offset", Integer.class);
    @StringDef(value={"media_codec_auto", "media_codec_hardware", "media_codec_software"})
    @Runtime
    @Writable
    public static final Key<String> KEY_VIDEO_ENCODER_MODE = new Key<String>("key_video_encoder_mode", String.class);
    @StringDef(value={"media_codec_auto", "media_codec_hardware", "media_codec_software"})
    @Runtime
    @Writable
    public static final Key<String> KEY_VIDEO_DECODER_MODE = new Key<String>("key_video_decoder_mode", String.class);
    @Runtime
    public static final Key<Boolean> KEY_VIDEO_SUPPORTED_HW_ENCODER = new Key<Boolean>("key_video_supported_hw_encoder", Boolean.class);
    @Runtime
    public static final Key<Boolean> KEY_VIDEO_SUPPORTED_HW_DECODER = new Key<Boolean>("key_video_supported_hw_decoder", Boolean.class);
    @StringDef(value={"audio_effect_mode_disable", "audio_effect_mode_platform_builtin_priority", "audio_effect_mode_sdk_builtin_priority"})
    @Writable
    public static final Key<String> KEY_AUDIO_EFFECT_NOISE_SUPPRESSOR = new Key<String>("key_audio_effect_noise_suppressor", String.class);
    @StringDef(value={"audio_effect_mode_disable", "audio_effect_mode_platform_builtin_priority", "audio_effect_mode_sdk_builtin_priority"})
    @Writable
    public static final Key<String> KEY_AUDIO_EFFECT_AUTOMATIC_GAIN_CONTROL = new Key<String>("key_audio_effect_automatic_gain_control", String.class);
    @StringDef(value={"audio_effect_mode_disable", "audio_effect_mode_platform_builtin_priority", "audio_effect_mode_sdk_builtin_priority"})
    @Writable
    public static final Key<String> KEY_AUDIO_EFFECT_ACOUSTIC_ECHO_CANCELER = new Key<String>("key_audio_effect_acoustic_echo_canceler", String.class);
    @Writable
    public static final Key<Boolean> KEY_AUDIO_CALL_PROXIMITY = new Key<Boolean>("key_audio_call_proximity", Boolean.class);
    @IntDef(value={1, 2, 3, 4, 5, 0})
    @Writable
    @Runtime
    public static final Key<Integer> KEY_VIDEO_QUALITY = new Key<Integer>("key_video_quality", Integer.class);
    @Writable
    @Runtime
    public static final Key<Boolean> KEY_VIDEO_ROTATE_IN_RENDING = new Key<Boolean>("key_video_rotate_in_rending", Boolean.class);
    @Writable
    public static final Key<Boolean> KEY_VIDEO_DEFAULT_FRONT_CAMERA = new Key<Boolean>("key_video_default_front_camera", Boolean.class);
    @IntDef(value={1, 0})
    @Runtime
    @Writable
    public static final Key<Integer> KEY_SESSION_MULTI_MODE_USER_ROLE = new Key<Integer>("key_session_multi_mode_user_role", Integer.class);
    @Runtime
    @Writable
    public static final Key<Boolean> KEY_VIDEO_FPS_REPORTED = new Key<Boolean>("key_video_fps_reported", Boolean.class);
    @Runtime
    @Writable
    public static final Key<Integer> KEY_VIDEO_MAX_BITRATE = new Key<Integer>("key_video_max_bitrate", Integer.class);
    @IntDef(value={5, 10, 15, 20, 25})
    @Writable
    @Runtime
    public static final Key<Integer> KEY_VIDEO_FRAME_RATE = new Key<Integer>("key_video_frame_rate", Integer.class);
    @Writable
    @Runtime
    public static final Key<Boolean> KEY_VIDEO_FRAME_FILTER = new Key<Boolean>("key_video_frame_filter", Boolean.class);
    @IntDef(value={13, 1})
    @Writable
    @Runtime
    public static final Key<Integer> KEY_VIDEO_FRAME_FILTER_FORMAT = new Key<Integer>("key_video_frame_filter_format", Integer.class);
    @Writable
    @Runtime
    public static final Key<Boolean> KEY_AUDIO_FRAME_FILTER = new Key<Boolean>("key_audio_frame_filter", Boolean.class);
    @Runtime
    @Writable
    public static final Key<String> KEY_SESSION_LIVE_URL = new Key<String>("key_session_live_url", String.class);
    @Writable
    @Runtime
    public static final Key<Boolean> KEY_AUDIO_REPORT_SPEAKER = new Key<Boolean>("key_audio_report_speaker", Boolean.class);
    @Writable
    @Runtime
    @FloatRange(from=0.0f, to=1.0f)
    public static final Key<Float> KEY_AUDIO_MIXING_STREAM_VOLUME = new Key<Float>("key_audio_mixing_stream_volume", Float.class);
    @Writable
    public static final Key<Boolean> KEY_AUDIO_HIGH_QUALITY = new Key<Boolean>("key_audio_high_quality", Boolean.class);
    @IntDef(value={0, 2, 3, 1})
    @Writable
    @Runtime
    public static final Key<Integer> KEY_VIDEO_CAPTURE_ORIENTATION = new Key<Integer>("key_video_capture_orientation", Integer.class);
    @IntDef(value={0, 4, 2, 1})
    @Writable
    @Runtime
    public static final Key<Integer> KEY_VIDEO_FIXED_CROP_RATIO = new Key<Integer>("key_video_fixed_crop_ratio", Integer.class);
    @Writable
    @Runtime
    public static final Key<Boolean> KEY_VIDEO_LOCAL_PREVIEW_MIRROR = new Key<Boolean>("key_video_local_preview_mirror", Boolean.class);
    @Runtime
    @Writable
    public static final Key<Boolean> KEY_VIDEO_TRANSPORT_MIRROR = new Key<Boolean>("key_video_transport_mirror", Boolean.class);
    @Writable
    @Runtime
    public static final Key<Boolean> KEY_AUDIO_DTX_ENABLE = new Key<Boolean>("key_audio_dtx_enable", Boolean.class);
    @Writable
    public static final Key<Boolean> KEY_SERVER_AUDIO_RECORD = new Key<Boolean>("key_server_audio_record", Boolean.class);
    @Writable
    public static final Key<Boolean> KEY_SERVER_VIDEO_RECORD = new Key<Boolean>("key_server_video_record", Boolean.class);
    @Writable
    public static final Key<Boolean> KEY_SERVER_LIVE_RECORD = new Key<Boolean>("key_server_live_record", Boolean.class);
    @IntDef(value={1, 0, 2, 3})
    @Writable
    public static final Key<Integer> KEY_SESSION_LIVE_PIP_MODE = new Key<Integer>("key_session_live_pip_mode", Integer.class);
    @Writable
    public static final Key<String> KEY_SESSION_LIVE_PIP_MODE_ENHANCE = new Key<String>("key_session_live_pip_mode_enhance", String.class);
    @Writable
    public static final Key<Boolean> KEY_SESSION_LIVE_MODE = new Key<Boolean>("key_session_live_mode", Boolean.class);
    @Writable
    public static final Key<Boolean> KEY_AUDIO_HOWLING_SUPPRESS = new Key<Boolean>("key_audio_howling_suppress", Boolean.class);
    private RtcParameters mRawParams = new RtcParameters();

    public void clear() {
        this.mRawParams.clear();
    }

    public RtcParameters getRawParameters() {
        return this.mRawParams;
    }

    public void setRawParameters(RtcParameters rtcParameters) {
        this.mRawParams = new RtcParameters();
        Object object = rtcParameters.keys();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                this.mRawParams.setObject(string, rtcParameters.getObject(string));
            }
        }
    }

    public final AVChatParameters setRequestKeys(Set<Key> object) {
        AVChatParameters.checkNotNull(object);
        HashSet<String> hashSet = new HashSet<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            Key key = (Key)object.next();
            hashSet.add(key.name());
        }
        this.mRawParams.setRequestKeys(hashSet);
        return this;
    }

    public final AVChatParameters setRequestKey(Key key) {
        AVChatParameters.checkNotNull(key);
        this.mRawParams.setRequestKey(key.name());
        return this;
    }

    public final boolean getBoolean(Key<Boolean> key) {
        return this.get(key);
    }

    public final int getInteger(Key<Integer> key) {
        return this.get(key);
    }

    public final String getString(Key<String> key) {
        return this.get(key);
    }

    public final void setInteger(Key<Integer> key, int n2) {
        this.set(key, n2);
    }

    public final void setBoolean(Key<Boolean> key, boolean bl) {
        this.set(key, bl);
    }

    public final void setString(Key<String> key, String string) {
        this.set(key, string);
    }

    public final boolean containsKey(Key key) {
        AVChatParameters.checkNotNull(key);
        return this.mRawParams.containsKey(key.name());
    }

    public final <T> void set(Key<T> key, T t) {
        AVChatParameters.checkNotNull(key);
        this.mRawParams.setObject(key.name(), t);
    }

    public final <T> T get(Key<T> key) {
        AVChatParameters.checkNotNull(key);
        return (T)this.mRawParams.getObject(key.name());
    }

    public final void setFloat(Key<Float> key, float f2) {
        this.set(key, Float.valueOf(f2));
    }

    public final float getFloat(Key<Float> key) {
        return this.get(key).floatValue();
    }

    public final void removeParameters(Key key) {
        AVChatParameters.checkNotNull(key);
        this.mRawParams.removeParameters(key.name());
    }

    private static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static class Key<T>
    implements Serializable {
        private final RtcKey<T> mKey;
        private final boolean mWritable;
        private final boolean mRuntime;

        Key(String string, Class<T> clazz) {
            this.mKey = new RtcKey(string, clazz);
            this.mWritable = RtcParameters.writeSupported((String)string);
            this.mRuntime = RtcParameters.runtimeSupported((String)string);
        }

        public static Key<?> createSpecializedKey(String string) {
            Class clazz = RtcParameters.getKeyType((String)string);
            if (clazz == null) {
                throw new IllegalArgumentException("Key " + string + " unsupported\uff01");
            }
            return new SpecializedKey(string, clazz);
        }

        public String name() {
            return this.mKey.getName();
        }

        public boolean runtime() {
            return this.mRuntime;
        }

        public boolean writable() {
            return this.mWritable;
        }

        public final Class<T> type() {
            return this.mKey.getType();
        }

        public final int hashCode() {
            return this.mKey.hashCode();
        }

        public final boolean equals(Object object) {
            return object instanceof Key && ((Key)object).mKey.equals(this.mKey);
        }

        public String toString() {
            return String.format("Key(Name:%s, Type:%s, Writable:%s, Runtime:%s)", this.name(), this.type(), this.writable(), this.runtime());
        }

        private static class SpecializedKey<T>
        extends Key<T> {
            SpecializedKey(String string, Class<T> clazz) {
                super(string, clazz);
            }
        }
    }
}

