/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.PackedInts;

final class PackedReaderIterator
extends PackedInts.ReaderIteratorImpl {
    final int packedIntsVersion;
    final PackedInts.Format format;
    final BulkOperation bulkOperation;
    final byte[] nextBlocks;
    final LongsRef nextValues;
    final int iterations;
    int position;

    PackedReaderIterator(PackedInts.Format format, int n2, int n3, int n4, DataInput dataInput, int n5) {
        super(n3, n4, dataInput);
        this.format = format;
        this.packedIntsVersion = n2;
        this.bulkOperation = BulkOperation.of(format, n4);
        this.iterations = this.iterations(n5);
        assert (n3 == 0 || this.iterations > 0);
        this.nextBlocks = new byte[this.iterations * this.bulkOperation.byteBlockCount()];
        this.nextValues = new LongsRef(new long[this.iterations * this.bulkOperation.byteValueCount()], 0, 0);
        this.nextValues.offset = this.nextValues.longs.length;
        this.position = -1;
    }

    private int iterations(int n2) {
        n2 = this.bulkOperation.computeIterations(this.valueCount, n2);
        if (this.packedIntsVersion <= 0) {
            n2 = n2 + 7 & 0xFFFFFFF8;
        }
        return n2;
    }

    @Override
    public final LongsRef next(int n2) throws IOException {
        assert (this.nextValues.length >= 0);
        assert (n2 > 0);
        assert (this.nextValues.offset + this.nextValues.length <= this.nextValues.longs.length);
        this.nextValues.offset += this.nextValues.length;
        int n3 = this.valueCount - this.position - 1;
        if (n3 <= 0) {
            throw new EOFException();
        }
        n2 = Math.min(n3, n2);
        if (this.nextValues.offset == this.nextValues.longs.length) {
            n3 = (int)Math.min(this.format.byteCount(this.packedIntsVersion, n3, this.bitsPerValue), (long)this.nextBlocks.length);
            this.in.readBytes(this.nextBlocks, 0, n3);
            if (n3 < this.nextBlocks.length) {
                Arrays.fill(this.nextBlocks, n3, this.nextBlocks.length, (byte)0);
            }
            this.bulkOperation.decode(this.nextBlocks, 0, this.nextValues.longs, 0, this.iterations);
            this.nextValues.offset = 0;
        }
        this.nextValues.length = Math.min(this.nextValues.longs.length - this.nextValues.offset, n2);
        this.position += this.nextValues.length;
        return this.nextValues;
    }
}

