/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Packed8ThreeBlocks
extends PackedInts.MutableImpl {
    final byte[] blocks;

    Packed8ThreeBlocks(int n2) {
        super(n2, 24);
        if (n2 > 0x2AAAAAAA) {
            throw new ArrayIndexOutOfBoundsException("MAX_SIZE exceeded");
        }
        this.blocks = new byte[n2 * 3];
    }

    Packed8ThreeBlocks(int n2, DataInput dataInput, int n3) throws IOException {
        this(n3);
        dataInput.readBytes(this.blocks, 0, 3 * n3);
        n2 = (int)(PackedInts.Format.PACKED.byteCount(n2, n3, 24) - 3L * (long)n3);
        for (n3 = 0; n3 < n2; ++n3) {
            dataInput.readByte();
        }
    }

    @Override
    public final long get(int n2) {
        return ((long)this.blocks[n2 *= 3] & 0xFFL) << 16 | ((long)this.blocks[n2 + 1] & 0xFFL) << 8 | (long)this.blocks[n2 + 2] & 0xFFL;
    }

    @Override
    public final int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        n4 = Math.min(this.valueCount - n2, n4);
        int n5 = n2 * 3;
        n2 = (n2 + n4) * 3;
        while (n5 < n2) {
            lArray[n3++] = ((long)this.blocks[n5] & 0xFFL) << 16 | ((long)this.blocks[n5 + 1] & 0xFFL) << 8 | (long)this.blocks[n5 + 2] & 0xFFL;
            n5 += 3;
        }
        return n4;
    }

    @Override
    public final void set(int n2, long l2) {
        this.blocks[n2 *= 3] = (byte)(l2 >>> 16);
        this.blocks[n2 + 1] = (byte)(l2 >>> 8);
        this.blocks[n2 + 2] = (byte)l2;
    }

    @Override
    public final int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        n4 = Math.min(this.valueCount - n2, n4);
        int n5 = n3;
        n2 *= 3;
        n3 += n4;
        while (n5 < n3) {
            long l2 = lArray[n5];
            this.blocks[n2++] = (byte)(l2 >>> 16);
            this.blocks[n2++] = (byte)(l2 >>> 8);
            this.blocks[n2++] = (byte)l2;
            ++n5;
        }
        return n4;
    }

    @Override
    public final void fill(int n2, int n3, long l2) {
        byte by = (byte)(l2 >>> 16);
        byte by2 = (byte)(l2 >>> 8);
        byte by3 = (byte)l2;
        n2 *= 3;
        n3 *= 3;
        while (n2 < n3) {
            this.blocks[n2] = by;
            this.blocks[n2 + 1] = by2;
            this.blocks[n2 + 2] = by3;
            n2 += 3;
        }
    }

    @Override
    public final void clear() {
        Arrays.fill(this.blocks, (byte)0);
    }

    @Override
    public final long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.blocks);
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + "(bitsPerValue=" + this.bitsPerValue + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }
}

