/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.PackedInts;

abstract class Packed64SingleBlock
extends PackedInts.MutableImpl {
    private static final int[] SUPPORTED_BITS_PER_VALUE = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 16, 21, 32};
    final long[] blocks;

    public static boolean isSupported(int n2) {
        return Arrays.binarySearch(SUPPORTED_BITS_PER_VALUE, n2) >= 0;
    }

    private static int requiredCapacity(int n2, int n3) {
        return n2 / n3 + (n2 % n3 == 0 ? 0 : 1);
    }

    Packed64SingleBlock(int n2, int n3) {
        super(n2, n3);
        assert (Packed64SingleBlock.isSupported(n3));
        n3 = 64 / n3;
        this.blocks = new long[Packed64SingleBlock.requiredCapacity(n2, n3)];
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, 0L);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.blocks);
    }

    @Override
    public int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = n2;
        int n6 = 64 / this.bitsPerValue;
        int n7 = n2 % n6;
        if (n7 != 0) {
            for (n4 = Math.min(n4, this.valueCount - n2); n7 < n6 && n4 > 0; --n4, ++n7) {
                lArray[n3++] = this.get(n2++);
            }
            if (n4 == 0) {
                return n2 - n5;
            }
        }
        assert (n2 % n6 == 0);
        BulkOperation bulkOperation = BulkOperation.of(PackedInts.Format.PACKED_SINGLE_BLOCK, this.bitsPerValue);
        assert (bulkOperation.longBlockCount() == 1);
        assert (bulkOperation.longValueCount() == n6);
        int n8 = n2 / n6;
        int n9 = (n2 + n4) / n6 - n8;
        bulkOperation.decode(this.blocks, n8, lArray, n3, n9);
        n6 = n9 * n6;
        n4 -= n6;
        if ((n2 += n6) > n5) {
            return n2 - n5;
        }
        assert (n2 == n5);
        return super.get(n2, lArray, n3, n4);
    }

    @Override
    public int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = n2;
        int n6 = 64 / this.bitsPerValue;
        int n7 = n2 % n6;
        if (n7 != 0) {
            for (n4 = Math.min(n4, this.valueCount - n2); n7 < n6 && n4 > 0; --n4, ++n7) {
                this.set(n2++, lArray[n3++]);
            }
            if (n4 == 0) {
                return n2 - n5;
            }
        }
        assert (n2 % n6 == 0);
        BulkOperation bulkOperation = BulkOperation.of(PackedInts.Format.PACKED_SINGLE_BLOCK, this.bitsPerValue);
        assert (bulkOperation.longBlockCount() == 1);
        assert (bulkOperation.longValueCount() == n6);
        int n8 = n2 / n6;
        int n9 = (n2 + n4) / n6 - n8;
        bulkOperation.encode(lArray, n3, this.blocks, n8, n9);
        n6 = n9 * n6;
        n4 -= n6;
        if ((n2 += n6) > n5) {
            return n2 - n5;
        }
        assert (n2 == n5);
        return super.set(n2, lArray, n3, n4);
    }

    @Override
    public void fill(int n2, int n3, long l2) {
        assert (n2 >= 0);
        assert (n2 <= n3);
        assert (PackedInts.unsignedBitsRequired(l2) <= this.bitsPerValue);
        int n4 = 64 / this.bitsPerValue;
        if (n3 - n2 <= n4 << 1) {
            super.fill(n2, n3, l2);
            return;
        }
        int n5 = n2 % n4;
        if (n5 != 0) {
            while (n5 < n4) {
                this.set(n2++, l2);
                ++n5;
            }
            assert (n2 % n4 == 0);
        }
        n5 = n2 / n4;
        int n6 = n3 / n4;
        assert (n5 * n4 == n2);
        long l3 = 0L;
        for (n2 = 0; n2 < n4; ++n2) {
            l3 |= l2 << n2 * this.bitsPerValue;
        }
        Arrays.fill(this.blocks, n5, n6, l3);
        for (n2 = n4 * n6; n2 < n3; ++n2) {
            this.set(n2, l2);
        }
    }

    @Override
    protected PackedInts.Format getFormat() {
        return PackedInts.Format.PACKED_SINGLE_BLOCK;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(bitsPerValue=" + this.bitsPerValue + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }

    public static Packed64SingleBlock create(DataInput dataInput, int n2, int n3) throws IOException {
        Packed64SingleBlock packed64SingleBlock = Packed64SingleBlock.create(n2, n3);
        for (n3 = 0; n3 < packed64SingleBlock.blocks.length; ++n3) {
            packed64SingleBlock.blocks[n3] = dataInput.readLong();
        }
        return packed64SingleBlock;
    }

    public static Packed64SingleBlock create(int n2, int n3) {
        switch (n3) {
            case 1: {
                return new a(n2);
            }
            case 2: {
                return new e(n2);
            }
            case 3: {
                return new g(n2);
            }
            case 4: {
                return new i(n2);
            }
            case 5: {
                return new j(n2);
            }
            case 6: {
                return new k(n2);
            }
            case 7: {
                return new l(n2);
            }
            case 8: {
                return new m(n2);
            }
            case 9: {
                return new n(n2);
            }
            case 10: {
                return new b(n2);
            }
            case 12: {
                return new c(n2);
            }
            case 16: {
                return new d(n2);
            }
            case 21: {
                return new f(n2);
            }
            case 32: {
                return new h(n2);
            }
        }
        throw new IllegalArgumentException("Unsupported number of bits per value: 32");
    }

    static final class h
    extends Packed64SingleBlock {
        h(int n2) {
            super(n2, 32);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 >>> 1;
            n2 = (n2 & 1) << 5;
            return this.blocks[n3] >>> n2 & 0xFFFFFFFFL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 >>> 1;
            n2 = (n2 & 1) << 5;
            this.blocks[n3] = this.blocks[n3] & (0xFFFFFFFFL << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class f
    extends Packed64SingleBlock {
        f(int n2) {
            super(n2, 21);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 / 3;
            n2 = n2 % 3 * 21;
            return this.blocks[n3] >>> n2 & 0x1FFFFFL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 / 3;
            n2 = n2 % 3 * 21;
            this.blocks[n3] = this.blocks[n3] & (0x1FFFFFL << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class d
    extends Packed64SingleBlock {
        d(int n2) {
            super(n2, 16);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 >>> 2;
            n2 = (n2 & 3) << 4;
            return this.blocks[n3] >>> n2 & 0xFFFFL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 >>> 2;
            n2 = (n2 & 3) << 4;
            this.blocks[n3] = this.blocks[n3] & (65535L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class c
    extends Packed64SingleBlock {
        c(int n2) {
            super(n2, 12);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 / 5;
            n2 = n2 % 5 * 12;
            return this.blocks[n3] >>> n2 & 0xFFFL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 / 5;
            n2 = n2 % 5 * 12;
            this.blocks[n3] = this.blocks[n3] & (4095L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class b
    extends Packed64SingleBlock {
        b(int n2) {
            super(n2, 10);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 / 6;
            n2 = n2 % 6 * 10;
            return this.blocks[n3] >>> n2 & 0x3FFL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 / 6;
            n2 = n2 % 6 * 10;
            this.blocks[n3] = this.blocks[n3] & (1023L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class n
    extends Packed64SingleBlock {
        n(int n2) {
            super(n2, 9);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 / 7;
            n2 = n2 % 7 * 9;
            return this.blocks[n3] >>> n2 & 0x1FFL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 / 7;
            n2 = n2 % 7 * 9;
            this.blocks[n3] = this.blocks[n3] & (511L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class m
    extends Packed64SingleBlock {
        m(int n2) {
            super(n2, 8);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 >>> 3;
            n2 = (n2 & 7) << 3;
            return this.blocks[n3] >>> n2 & 0xFFL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 >>> 3;
            n2 = (n2 & 7) << 3;
            this.blocks[n3] = this.blocks[n3] & (255L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class l
    extends Packed64SingleBlock {
        l(int n2) {
            super(n2, 7);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 / 9;
            n2 = n2 % 9 * 7;
            return this.blocks[n3] >>> n2 & 0x7FL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 / 9;
            n2 = n2 % 9 * 7;
            this.blocks[n3] = this.blocks[n3] & (127L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class k
    extends Packed64SingleBlock {
        k(int n2) {
            super(n2, 6);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 / 10;
            n2 = n2 % 10 * 6;
            return this.blocks[n3] >>> n2 & 0x3FL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 / 10;
            n2 = n2 % 10 * 6;
            this.blocks[n3] = this.blocks[n3] & (63L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class j
    extends Packed64SingleBlock {
        j(int n2) {
            super(n2, 5);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 / 12;
            n2 = n2 % 12 * 5;
            return this.blocks[n3] >>> n2 & 0x1FL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 / 12;
            n2 = n2 % 12 * 5;
            this.blocks[n3] = this.blocks[n3] & (31L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class i
    extends Packed64SingleBlock {
        i(int n2) {
            super(n2, 4);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 >>> 4;
            n2 = (n2 & 0xF) << 2;
            return this.blocks[n3] >>> n2 & 0xFL;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 >>> 4;
            n2 = (n2 & 0xF) << 2;
            this.blocks[n3] = this.blocks[n3] & (15L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class g
    extends Packed64SingleBlock {
        g(int n2) {
            super(n2, 3);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 / 21;
            n2 = n2 % 21 * 3;
            return this.blocks[n3] >>> n2 & 7L;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 / 21;
            n2 = n2 % 21 * 3;
            this.blocks[n3] = this.blocks[n3] & (7L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class e
    extends Packed64SingleBlock {
        e(int n2) {
            super(n2, 2);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 >>> 5;
            n2 = (n2 & 0x1F) << 1;
            return this.blocks[n3] >>> n2 & 3L;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 >>> 5;
            n2 = (n2 & 0x1F) << 1;
            this.blocks[n3] = this.blocks[n3] & (3L << n2 ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }

    static final class a
    extends Packed64SingleBlock {
        a(int n2) {
            super(n2, 1);
        }

        @Override
        public final long get(int n2) {
            int n3 = n2 >>> 6;
            return this.blocks[n3] >>> (n2 &= 0x3F) & 1L;
        }

        @Override
        public final void set(int n2, long l2) {
            int n3 = n2 >>> 6;
            this.blocks[n3] = this.blocks[n3] & (1L << (n2 &= 0x3F) ^ 0xFFFFFFFFFFFFFFFFL) | l2 << n2;
        }
    }
}

