/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.PackedInts;

class Packed64
extends PackedInts.MutableImpl {
    private final long[] blocks;
    private final long maskRight;
    private final int bpvMinusBlockSize;

    public Packed64(int n2, int n3) {
        super(n2, n3);
        n2 = PackedInts.Format.PACKED.longCount(2, n2, n3);
        this.blocks = new long[n2];
        this.maskRight = -1L << 64 - n3 >>> 64 - n3;
        this.bpvMinusBlockSize = n3 - 64;
    }

    public Packed64(int n2, DataInput dataInput, int n3, int n4) throws IOException {
        super(n3, n4);
        PackedInts.Format format = PackedInts.Format.PACKED;
        long l2 = format.byteCount(n2, n3, n4);
        n2 = format.longCount(2, n3, n4);
        this.blocks = new long[n2];
        n2 = 0;
        while ((long)n2 < l2 / 8L) {
            this.blocks[n2] = dataInput.readLong();
            ++n2;
        }
        n2 = (int)(l2 % 8L);
        if (n2 != 0) {
            long l3 = 0L;
            for (n3 = 0; n3 < n2; ++n3) {
                l3 |= ((long)dataInput.readByte() & 0xFFL) << 56 - (n3 << 3);
            }
            this.blocks[this.blocks.length - 1] = l3;
        }
        this.maskRight = -1L << 64 - n4 >>> 64 - n4;
        this.bpvMinusBlockSize = n4 - 64;
    }

    @Override
    public long get(int n2) {
        long l2 = (long)n2 * (long)this.bitsPerValue;
        n2 = (int)(l2 >>> 6);
        long l3 = (l2 & 0x3FL) + (long)this.bpvMinusBlockSize;
        if (l3 <= 0L) {
            return this.blocks[n2] >>> (int)(-l3) & this.maskRight;
        }
        return (this.blocks[n2] << (int)l3 | this.blocks[n2 + 1] >>> (int)(64L - l3)) & this.maskRight;
    }

    @Override
    public int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = n2;
        BulkOperation bulkOperation = BulkOperation.of(PackedInts.Format.PACKED, this.bitsPerValue);
        int n6 = n2 % bulkOperation.longValueCount();
        if (n6 != 0) {
            for (n4 = Math.min(n4, this.valueCount - n2); n6 < bulkOperation.longValueCount() && n4 > 0; --n4, ++n6) {
                lArray[n3++] = this.get(n2++);
            }
            if (n4 == 0) {
                return n2 - n5;
            }
        }
        assert (n2 % bulkOperation.longValueCount() == 0);
        n6 = (int)((long)n2 * (long)this.bitsPerValue >>> 6);
        assert (((long)n2 * (long)this.bitsPerValue & 0x3FL) == 0L);
        int n7 = n4 / bulkOperation.longValueCount();
        bulkOperation.decode(this.blocks, n6, lArray, n3, n7);
        int n8 = n7 * bulkOperation.longValueCount();
        n2 += n8;
        assert ((n4 -= n8) >= 0);
        if (n2 > n5) {
            return n2 - n5;
        }
        assert (n2 == n5);
        return super.get(n2, lArray, n3, n4);
    }

    @Override
    public void set(int n2, long l2) {
        long l3 = (long)n2 * (long)this.bitsPerValue;
        n2 = (int)(l3 >>> 6);
        long l4 = (l3 & 0x3FL) + (long)this.bpvMinusBlockSize;
        if (l4 <= 0L) {
            this.blocks[n2] = this.blocks[n2] & (this.maskRight << (int)(-l4) ^ 0xFFFFFFFFFFFFFFFFL) | l2 << (int)(-l4);
            return;
        }
        this.blocks[n2] = this.blocks[n2] & (this.maskRight >>> (int)l4 ^ 0xFFFFFFFFFFFFFFFFL) | l2 >>> (int)l4;
        this.blocks[n2 + 1] = this.blocks[n2 + 1] & -1L >>> (int)l4 | l2 << (int)(64L - l4);
    }

    @Override
    public int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        int n5 = n2;
        BulkOperation bulkOperation = BulkOperation.of(PackedInts.Format.PACKED, this.bitsPerValue);
        int n6 = n2 % bulkOperation.longValueCount();
        if (n6 != 0) {
            for (n4 = Math.min(n4, this.valueCount - n2); n6 < bulkOperation.longValueCount() && n4 > 0; --n4, ++n6) {
                this.set(n2++, lArray[n3++]);
            }
            if (n4 == 0) {
                return n2 - n5;
            }
        }
        assert (n2 % bulkOperation.longValueCount() == 0);
        n6 = (int)((long)n2 * (long)this.bitsPerValue >>> 6);
        assert (((long)n2 * (long)this.bitsPerValue & 0x3FL) == 0L);
        int n7 = n4 / bulkOperation.longValueCount();
        bulkOperation.encode(lArray, n3, this.blocks, n6, n7);
        int n8 = n7 * bulkOperation.longValueCount();
        n2 += n8;
        assert ((n4 -= n8) >= 0);
        if (n2 > n5) {
            return n2 - n5;
        }
        assert (n2 == n5);
        return super.set(n2, lArray, n3, n4);
    }

    @Override
    public String toString() {
        return "Packed64(bitsPerValue=" + this.bitsPerValue + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 12 + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.blocks);
    }

    @Override
    public void fill(int n2, int n3, long l2) {
        int n4;
        assert (PackedInts.unsignedBitsRequired(l2) <= this.getBitsPerValue());
        assert (n2 <= n3);
        int n5 = 64 / Packed64.gcd(64, this.bitsPerValue);
        if (n3 - n2 <= 3 * n5) {
            super.fill(n2, n3, l2);
            return;
        }
        int n6 = n2 % n5;
        if (n6 != 0) {
            while (n6 < n5) {
                this.set(n2++, l2);
                ++n6;
            }
        }
        assert (n2 % n5 == 0);
        n6 = n5 * this.bitsPerValue >> 6;
        Packed64 packed64 = new Packed64(n5, this.bitsPerValue);
        for (n4 = 0; n4 < n5; ++n4) {
            packed64.set(n4, l2);
        }
        long[] lArray = packed64.blocks;
        assert (n6 <= lArray.length);
        int n7 = (int)((long)n2 * (long)this.bitsPerValue >>> 6);
        n4 = (int)((long)n3 * (long)this.bitsPerValue >>> 6);
        for (n2 = n7; n2 < n4; ++n2) {
            long l3;
            this.blocks[n2] = l3 = lArray[n2 % n6];
        }
        for (n2 = (int)(((long)n4 << 6) / (long)this.bitsPerValue); n2 < n3; ++n2) {
            this.set(n2, l2);
        }
    }

    private static int gcd(int n2, int n3) {
        while (true) {
            if (n2 < n3) {
                int n4 = n3;
                n3 = n2;
                n2 = n4;
                continue;
            }
            if (n3 == 0) {
                return n2;
            }
            int n5 = n3;
            n3 = n2 % n3;
            n2 = n5;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, 0L);
    }
}

