/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Packed16ThreeBlocks
extends PackedInts.MutableImpl {
    final short[] blocks;

    Packed16ThreeBlocks(int n2) {
        super(n2, 48);
        if (n2 > 0x2AAAAAAA) {
            throw new ArrayIndexOutOfBoundsException("MAX_SIZE exceeded");
        }
        this.blocks = new short[n2 * 3];
    }

    Packed16ThreeBlocks(int n2, DataInput dataInput, int n3) throws IOException {
        this(n3);
        int n4;
        for (n4 = 0; n4 < 3 * n3; ++n4) {
            this.blocks[n4] = dataInput.readShort();
        }
        n4 = (int)(PackedInts.Format.PACKED.byteCount(n2, n3, 48) - (3L * (long)n3 << 1));
        for (n2 = 0; n2 < n4; ++n2) {
            dataInput.readByte();
        }
    }

    @Override
    public final long get(int n2) {
        return ((long)this.blocks[n2 *= 3] & 0xFFFFL) << 32 | ((long)this.blocks[n2 + 1] & 0xFFFFL) << 16 | (long)this.blocks[n2 + 2] & 0xFFFFL;
    }

    @Override
    public final int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        n4 = Math.min(this.valueCount - n2, n4);
        int n5 = n2 * 3;
        n2 = (n2 + n4) * 3;
        while (n5 < n2) {
            lArray[n3++] = ((long)this.blocks[n5] & 0xFFFFL) << 32 | ((long)this.blocks[n5 + 1] & 0xFFFFL) << 16 | (long)this.blocks[n5 + 2] & 0xFFFFL;
            n5 += 3;
        }
        return n4;
    }

    @Override
    public final void set(int n2, long l2) {
        this.blocks[n2 *= 3] = (short)(l2 >>> 32);
        this.blocks[n2 + 1] = (short)(l2 >>> 16);
        this.blocks[n2 + 2] = (short)l2;
    }

    @Override
    public final int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        n4 = Math.min(this.valueCount - n2, n4);
        int n5 = n3;
        n2 *= 3;
        n3 += n4;
        while (n5 < n3) {
            long l2 = lArray[n5];
            this.blocks[n2++] = (short)(l2 >>> 32);
            this.blocks[n2++] = (short)(l2 >>> 16);
            this.blocks[n2++] = (short)l2;
            ++n5;
        }
        return n4;
    }

    @Override
    public final void fill(int n2, int n3, long l2) {
        short s2 = (short)(l2 >>> 32);
        short s3 = (short)(l2 >>> 16);
        short s4 = (short)l2;
        n2 *= 3;
        n3 *= 3;
        while (n2 < n3) {
            this.blocks[n2] = s2;
            this.blocks[n2 + 1] = s3;
            this.blocks[n2 + 2] = s4;
            n2 += 3;
        }
    }

    @Override
    public final void clear() {
        Arrays.fill(this.blocks, (short)0);
    }

    @Override
    public final long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.blocks);
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + "(bitsPerValue=" + this.bitsPerValue + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }
}

