/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.packed.AbstractBlockPackedWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

public final class MonotonicBlockPackedWriter
extends AbstractBlockPackedWriter {
    public MonotonicBlockPackedWriter(DataOutput dataOutput, int n2) {
        super(dataOutput, n2);
    }

    @Override
    public final void add(long l2) throws IOException {
        assert (l2 >= 0L);
        super.add(l2);
    }

    @Override
    protected final void flush() throws IOException {
        int n2;
        assert (this.off > 0);
        float f2 = this.off == 1 ? 0.0f : (float)(this.values[this.off - 1] - this.values[0]) / (float)(this.off - 1);
        long l2 = this.values[0];
        for (int i2 = 1; i2 < this.off; ++i2) {
            long l3 = this.values[i2];
            long l4 = MonotonicBlockPackedReader.expected(l2, f2, i2);
            if (l4 <= l3) continue;
            l2 -= l4 - l3;
        }
        long l5 = 0L;
        for (n2 = 0; n2 < this.off; ++n2) {
            this.values[n2] = this.values[n2] - MonotonicBlockPackedReader.expected(l2, f2, n2);
            l5 = Math.max(l5, this.values[n2]);
        }
        this.out.writeZLong(l2);
        this.out.writeInt(Float.floatToIntBits(f2));
        if (l5 == 0L) {
            this.out.writeVInt(0);
        } else {
            n2 = PackedInts.bitsRequired(l5);
            this.out.writeVInt(n2);
            this.writeValues(n2);
        }
        this.off = 0;
    }
}

