/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.packed.PackedInts;

public class MonotonicBlockPackedReader
extends LongValues
implements a {
    final int blockShift;
    final int blockMask;
    final long valueCount;
    final long[] minValues;
    final float[] averages;
    final PackedInts.Reader[] subReaders;
    final long sumBPV;

    static long expected(long l2, float f2, int n2) {
        return l2 + (long)(f2 * (float)n2);
    }

    public static MonotonicBlockPackedReader of(IndexInput indexInput, int n2, int n3, long l2, boolean bl) throws IOException {
        if (n2 < 2) {
            return new MonotonicBlockPackedReader(indexInput, n2, n3, l2, bl){

                @Override
                protected final long decodeDelta(long l2) {
                    return BitUtil.zigZagDecode(l2);
                }
            };
        }
        return new MonotonicBlockPackedReader(indexInput, n2, n3, l2, bl);
    }

    private MonotonicBlockPackedReader(IndexInput indexInput, int n2, int n3, long l2, boolean bl) throws IOException {
        this.valueCount = l2;
        this.blockShift = PackedInts.checkBlockSize(n3, 64, 0x8000000);
        this.blockMask = n3 - 1;
        int n4 = PackedInts.numBlocks(l2, n3);
        this.minValues = new long[n4];
        this.averages = new float[n4];
        this.subReaders = new PackedInts.Reader[n4];
        long l3 = 0L;
        for (int i2 = 0; i2 < n4; ++i2) {
            this.minValues[i2] = n2 < 2 ? indexInput.readVLong() : indexInput.readZLong();
            this.averages[i2] = Float.intBitsToFloat(indexInput.readInt());
            int n5 = indexInput.readVInt();
            l3 += (long)n5;
            if (n5 > 64) {
                throw new IOException("Corrupted");
            }
            if (n5 == 0) {
                this.subReaders[i2] = new PackedInts.NullReader(n3);
                continue;
            }
            int n6 = (int)Math.min((long)n3, l2 - (long)i2 * (long)n3);
            if (bl) {
                long l4 = indexInput.getFilePointer();
                this.subReaders[i2] = PackedInts.getDirectReaderNoHeader(indexInput, PackedInts.Format.PACKED, n2, n6, n5);
                indexInput.seek(l4 + PackedInts.Format.PACKED.byteCount(n2, n6, n5));
                continue;
            }
            this.subReaders[i2] = PackedInts.getReaderNoHeader(indexInput, PackedInts.Format.PACKED, n2, n6, n5);
        }
        this.sumBPV = l3;
    }

    @Override
    public long get(long l2) {
        assert (l2 >= 0L && l2 < this.valueCount);
        int n2 = (int)(l2 >>> this.blockShift);
        int n3 = (int)(l2 & (long)this.blockMask);
        return MonotonicBlockPackedReader.expected(this.minValues[n2], this.averages[n2], n3) + this.decodeDelta(this.subReaders[n2].get(n3));
    }

    protected long decodeDelta(long l2) {
        return l2;
    }

    public long size() {
        return this.valueCount;
    }

    @Override
    public long ramBytesUsed() {
        long l2 = 0L + RamUsageEstimator.sizeOf(this.minValues) + RamUsageEstimator.sizeOf(this.averages);
        PackedInts.Reader[] readerArray = this.subReaders;
        int n2 = this.subReaders.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PackedInts.Reader reader = readerArray[i2];
            l2 += reader.ramBytesUsed();
        }
        return l2;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        long l2 = this.subReaders.length == 0 ? 0L : this.sumBPV / (long)this.subReaders.length;
        return this.getClass().getSimpleName() + "(blocksize=" + (1 << this.blockShift) + ",size=" + this.valueCount + ",avgBPV=" + l2 + ")";
    }
}

