/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

public class GrowableWriter
extends PackedInts.Mutable {
    private long currentMask;
    private PackedInts.Mutable current;
    private final float acceptableOverheadRatio;

    public GrowableWriter(int n2, int n3, float f2) {
        this.acceptableOverheadRatio = f2;
        this.current = PackedInts.getMutable(n3, n2, this.acceptableOverheadRatio);
        this.currentMask = GrowableWriter.mask(this.current.getBitsPerValue());
    }

    private static long mask(int n2) {
        if (n2 == 64) {
            return -1L;
        }
        return PackedInts.maxValue(n2);
    }

    @Override
    public long get(int n2) {
        return this.current.get(n2);
    }

    @Override
    public int size() {
        return this.current.size();
    }

    @Override
    public int getBitsPerValue() {
        return this.current.getBitsPerValue();
    }

    private void ensureCapacity(long l2) {
        if ((l2 & this.currentMask) == l2) {
            return;
        }
        int n2 = PackedInts.unsignedBitsRequired(l2);
        assert (n2 > this.current.getBitsPerValue());
        int n3 = this.size();
        PackedInts.Mutable mutable = PackedInts.getMutable(n3, n2, this.acceptableOverheadRatio);
        PackedInts.copy((PackedInts.Reader)this.current, 0, mutable, 0, n3, 1024);
        this.current = mutable;
        this.currentMask = GrowableWriter.mask(this.current.getBitsPerValue());
    }

    @Override
    public void set(int n2, long l2) {
        this.ensureCapacity(l2);
        this.current.set(n2, l2);
    }

    @Override
    public void clear() {
        this.current.clear();
    }

    public GrowableWriter resize(int n2) {
        GrowableWriter growableWriter = new GrowableWriter(this.getBitsPerValue(), n2, this.acceptableOverheadRatio);
        n2 = Math.min(this.size(), n2);
        PackedInts.copy((PackedInts.Reader)this.current, 0, (PackedInts.Mutable)growableWriter, 0, n2, 1024);
        return growableWriter;
    }

    @Override
    public int get(int n2, long[] lArray, int n3, int n4) {
        return this.current.get(n2, lArray, n3, n4);
    }

    @Override
    public int set(int n2, long[] lArray, int n3, int n4) {
        long l2 = 0L;
        int n5 = n3 + n4;
        for (int i2 = n3; i2 < n5; ++i2) {
            l2 |= lArray[i2];
        }
        this.ensureCapacity(l2);
        return this.current.set(n2, lArray, n3, n4);
    }

    @Override
    public void fill(int n2, int n3, long l2) {
        this.ensureCapacity(l2);
        this.current.fill(n2, n3, l2);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8 + 4) + this.current.ramBytesUsed();
    }

    @Override
    public void save(DataOutput dataOutput) throws IOException {
        this.current.save(dataOutput);
    }
}

