/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Direct8
extends PackedInts.MutableImpl {
    final byte[] values;

    Direct8(int n2) {
        super(n2, 8);
        this.values = new byte[n2];
    }

    Direct8(int n2, DataInput dataInput, int n3) throws IOException {
        this(n3);
        dataInput.readBytes(this.values, 0, n3);
        n2 = (int)(PackedInts.Format.PACKED.byteCount(n2, n3, 8) - 1L * (long)n3);
        for (n3 = 0; n3 < n2; ++n3) {
            dataInput.readByte();
        }
    }

    @Override
    public final long get(int n2) {
        return (long)this.values[n2] & 0xFFL;
    }

    @Override
    public final void set(int n2, long l2) {
        this.values[n2] = (byte)l2;
    }

    @Override
    public final long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.values);
    }

    @Override
    public final void clear() {
        Arrays.fill(this.values, (byte)0);
    }

    @Override
    public final int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        n4 = Math.min(this.valueCount - n2, n4);
        int n5 = n2;
        n2 += n4;
        while (n5 < n2) {
            lArray[n3] = (long)this.values[n5] & 0xFFL;
            ++n5;
            ++n3;
        }
        return n4;
    }

    @Override
    public final int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        n4 = Math.min(this.valueCount - n2, n4);
        int n5 = n2;
        n2 += n4;
        while (n5 < n2) {
            this.values[n5] = (byte)lArray[n3];
            ++n5;
            ++n3;
        }
        return n4;
    }

    @Override
    public final void fill(int n2, int n3, long l2) {
        assert (l2 == (l2 & 0xFFL));
        Arrays.fill(this.values, n2, n3, (byte)l2);
    }
}

