/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

final class Direct32
extends PackedInts.MutableImpl {
    final int[] values;

    Direct32(int n2) {
        super(n2, 32);
        this.values = new int[n2];
    }

    Direct32(int n2, DataInput dataInput, int n3) throws IOException {
        this(n3);
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            this.values[n4] = dataInput.readInt();
        }
        n4 = (int)(PackedInts.Format.PACKED.byteCount(n2, n3, 32) - 4L * (long)n3);
        for (n2 = 0; n2 < n4; ++n2) {
            dataInput.readByte();
        }
    }

    @Override
    public final long get(int n2) {
        return (long)this.values[n2] & 0xFFFFFFFFL;
    }

    @Override
    public final void set(int n2, long l2) {
        this.values[n2] = (int)l2;
    }

    @Override
    public final long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.values);
    }

    @Override
    public final void clear() {
        Arrays.fill(this.values, 0);
    }

    @Override
    public final int get(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        n4 = Math.min(this.valueCount - n2, n4);
        int n5 = n2;
        n2 += n4;
        while (n5 < n2) {
            lArray[n3] = (long)this.values[n5] & 0xFFFFFFFFL;
            ++n5;
            ++n3;
        }
        return n4;
    }

    @Override
    public final int set(int n2, long[] lArray, int n3, int n4) {
        assert (n4 > 0) : "len must be > 0 (got " + n4 + ")";
        assert (n2 >= 0 && n2 < this.valueCount);
        assert (n3 + n4 <= lArray.length);
        n4 = Math.min(this.valueCount - n2, n4);
        int n5 = n2;
        n2 += n4;
        while (n5 < n2) {
            this.values[n5] = (int)lArray[n3];
            ++n5;
            ++n3;
        }
        return n4;
    }

    @Override
    public final void fill(int n2, int n3, long l2) {
        assert (l2 == (l2 & 0xFFFFFFFFL));
        Arrays.fill(this.values, n2, n3, (int)l2);
    }
}

