/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.BulkOperation;

final class BulkOperationPackedSingleBlock
extends BulkOperation {
    private final int bitsPerValue;
    private final int valueCount;
    private final long mask;

    public BulkOperationPackedSingleBlock(int n2) {
        this.bitsPerValue = n2;
        this.valueCount = 64 / n2;
        this.mask = (1L << n2) - 1L;
    }

    @Override
    public final int longBlockCount() {
        return 1;
    }

    @Override
    public final int byteBlockCount() {
        return 8;
    }

    @Override
    public final int longValueCount() {
        return this.valueCount;
    }

    @Override
    public final int byteValueCount() {
        return this.valueCount;
    }

    private static long readLong(byte[] byArray, int n2) {
        return ((long)byArray[n2++] & 0xFFL) << 56 | ((long)byArray[n2++] & 0xFFL) << 48 | ((long)byArray[n2++] & 0xFFL) << 40 | ((long)byArray[n2++] & 0xFFL) << 32 | ((long)byArray[n2++] & 0xFFL) << 24 | ((long)byArray[n2++] & 0xFFL) << 16 | ((long)byArray[n2++] & 0xFFL) << 8 | (long)byArray[n2] & 0xFFL;
    }

    private int decode(long l2, long[] lArray, int n2) {
        lArray[n2++] = l2 & this.mask;
        for (int i2 = 1; i2 < this.valueCount; ++i2) {
            lArray[n2++] = (l2 >>>= this.bitsPerValue) & this.mask;
        }
        return n2;
    }

    private int decode(long l2, int[] nArray, int n2) {
        nArray[n2++] = (int)(l2 & this.mask);
        for (int i2 = 1; i2 < this.valueCount; ++i2) {
            nArray[n2++] = (int)((l2 >>>= this.bitsPerValue) & this.mask);
        }
        return n2;
    }

    private long encode(long[] lArray, int n2) {
        long l2 = lArray[n2++];
        for (int i2 = 1; i2 < this.valueCount; ++i2) {
            l2 |= lArray[n2++] << i2 * this.bitsPerValue;
        }
        return l2;
    }

    private long encode(int[] nArray, int n2) {
        long l2 = (long)nArray[n2++] & 0xFFFFFFFFL;
        for (int i2 = 1; i2 < this.valueCount; ++i2) {
            l2 |= ((long)nArray[n2++] & 0xFFFFFFFFL) << i2 * this.bitsPerValue;
        }
        return l2;
    }

    @Override
    public final void decode(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            long l2 = lArray[n2++];
            n3 = this.decode(l2, lArray2, n3);
        }
    }

    @Override
    public final void decode(byte[] byArray, int n2, long[] lArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            long l2 = BulkOperationPackedSingleBlock.readLong(byArray, n2);
            n2 += 8;
            n3 = this.decode(l2, lArray, n3);
        }
    }

    @Override
    public final void decode(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        if (this.bitsPerValue > 32) {
            throw new UnsupportedOperationException("Cannot decode " + this.bitsPerValue + "-bits values into an int[]");
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            long l2 = BulkOperationPackedSingleBlock.readLong(byArray, n2);
            n2 += 8;
            n3 = this.decode(l2, nArray, n3);
        }
    }

    @Override
    public final void encode(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            lArray2[n3++] = this.encode(lArray, n2);
            n2 += this.valueCount;
        }
    }

    @Override
    public final void encode(long[] lArray, int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            long l2 = this.encode(lArray, n2);
            n2 += this.valueCount;
            n3 = this.writeLong(l2, byArray, n3);
        }
    }

    @Override
    public final void encode(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        for (int i2 = 0; i2 < n4; ++i2) {
            long l2 = this.encode(nArray, n2);
            n2 += this.valueCount;
            n3 = this.writeLong(l2, byArray, n3);
        }
    }
}

