/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.packed.BulkOperation;
import org.apache.lucene.util.packed.PackedInts;

class BulkOperationPacked
extends BulkOperation {
    private final int bitsPerValue;
    private final int longBlockCount;
    private final int longValueCount;
    private final int byteBlockCount;
    private final int byteValueCount;
    private final long mask;
    private final int intMask;

    public BulkOperationPacked(int n2) {
        this.bitsPerValue = n2;
        assert (n2 > 0 && n2 <= 64);
        int n3 = n2;
        while ((n3 & 1) == 0) {
            n3 >>>= 1;
        }
        this.longBlockCount = n3;
        this.longValueCount = 64 * this.longBlockCount / n2;
        n3 = 8 * this.longBlockCount;
        int n4 = this.longValueCount;
        while ((n3 & 1) == 0 && (n4 & 1) == 0) {
            n3 >>>= 1;
            n4 >>>= 1;
        }
        this.byteBlockCount = n3;
        this.byteValueCount = n4;
        this.mask = n2 == 64 ? -1L : (1L << n2) - 1L;
        this.intMask = (int)this.mask;
        assert (this.longValueCount * n2 == 64 * this.longBlockCount);
    }

    @Override
    public int longBlockCount() {
        return this.longBlockCount;
    }

    @Override
    public int longValueCount() {
        return this.longValueCount;
    }

    @Override
    public int byteBlockCount() {
        return this.byteBlockCount;
    }

    @Override
    public int byteValueCount() {
        return this.byteValueCount;
    }

    @Override
    public void decode(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        int n5 = 64;
        for (int i2 = 0; i2 < this.longValueCount * n4; ++i2) {
            if ((n5 -= this.bitsPerValue) < 0) {
                lArray2[n3++] = (lArray[n2++] & (1L << this.bitsPerValue + n5) - 1L) << -n5 | lArray[n2] >>> n5 + 64;
                n5 += 64;
                continue;
            }
            lArray2[n3++] = lArray[n2] >>> n5 & this.mask;
        }
    }

    @Override
    public void decode(byte[] byArray, int n2, long[] lArray, int n3, int n4) {
        long l2 = 0L;
        int n5 = this.bitsPerValue;
        for (int i2 = 0; i2 < n4 * this.byteBlockCount; ++i2) {
            long l3 = (long)byArray[n2++] & 0xFFL;
            if (n5 > 8) {
                l2 |= l3 << (n5 -= 8);
                continue;
            }
            int n6 = 8 - n5;
            lArray[n3++] = l2 | l3 >>> n6;
            while (n6 >= this.bitsPerValue) {
                lArray[n3++] = l3 >>> (n6 -= this.bitsPerValue) & this.mask;
            }
            n5 = this.bitsPerValue - n6;
            l2 = (l3 & (1L << n6) - 1L) << n5;
        }
        assert (n5 == this.bitsPerValue);
    }

    @Override
    public void decode(byte[] byArray, int n2, int[] nArray, int n3, int n4) {
        int n5 = 0;
        int n6 = this.bitsPerValue;
        for (int i2 = 0; i2 < n4 * this.byteBlockCount; ++i2) {
            int n7 = byArray[n2++] & 0xFF;
            if (n6 > 8) {
                n5 |= n7 << (n6 -= 8);
                continue;
            }
            int n8 = 8 - n6;
            nArray[n3++] = n5 | n7 >>> n8;
            while (n8 >= this.bitsPerValue) {
                nArray[n3++] = n7 >>> (n8 -= this.bitsPerValue) & this.intMask;
            }
            n6 = this.bitsPerValue - n8;
            n5 = (n7 & (1 << n8) - 1) << n6;
        }
        assert (n6 == this.bitsPerValue);
    }

    @Override
    public void encode(long[] lArray, int n2, long[] lArray2, int n3, int n4) {
        long l2 = 0L;
        int n5 = 64;
        for (int i2 = 0; i2 < this.longValueCount * n4; ++i2) {
            if ((n5 -= this.bitsPerValue) > 0) {
                l2 |= lArray[n2++] << n5;
                continue;
            }
            if (n5 == 0) {
                lArray2[n3++] = l2 |= lArray[n2++];
                l2 = 0L;
                n5 = 64;
                continue;
            }
            lArray2[n3++] = l2 |= lArray[n2] >>> -n5;
            l2 = (lArray[n2++] & (1L << -n5) - 1L) << n5 + 64;
            n5 += 64;
        }
    }

    @Override
    public void encode(long[] lArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 0;
        int n6 = 8;
        for (int i2 = 0; i2 < this.byteValueCount * n4; ++i2) {
            long l2 = lArray[n2++];
            assert (PackedInts.unsignedBitsRequired(l2) <= this.bitsPerValue);
            if (this.bitsPerValue < n6) {
                n5 = (int)((long)n5 | l2 << n6 - this.bitsPerValue);
                n6 -= this.bitsPerValue;
                continue;
            }
            int n7 = this.bitsPerValue - n6;
            byArray[n3++] = (byte)((long)n5 | l2 >>> n7);
            while (n7 >= 8) {
                byArray[n3++] = (byte)(l2 >>> (n7 -= 8));
            }
            n6 = 8 - n7;
            n5 = (int)((l2 & (1L << n7) - 1L) << n6);
        }
        assert (n6 == 8);
    }

    @Override
    public void encode(int[] nArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = 0;
        int n6 = 8;
        for (int i2 = 0; i2 < this.byteValueCount * n4; ++i2) {
            int n7 = nArray[n2++];
            assert (PackedInts.bitsRequired((long)n7 & 0xFFFFFFFFL) <= this.bitsPerValue);
            if (this.bitsPerValue < n6) {
                n5 |= n7 << n6 - this.bitsPerValue;
                n6 -= this.bitsPerValue;
                continue;
            }
            int n8 = this.bitsPerValue - n6;
            byArray[n3++] = (byte)(n5 | n7 >>> n8);
            while (n8 >= 8) {
                byArray[n3++] = (byte)(n7 >>> (n8 -= 8));
            }
            n6 = 8 - n8;
            n5 = (n7 & (1 << n8) - 1) << n6;
        }
        assert (n6 == 8);
    }
}

