/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.PackedInts;

public final class BlockPackedReaderIterator {
    DataInput in;
    final int packedIntsVersion;
    long valueCount;
    final int blockSize;
    final long[] values;
    final LongsRef valuesRef;
    byte[] blocks;
    int off;
    long ord;

    static long readVLong(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        if (by >= 0) {
            return by;
        }
        long l2 = (long)by & 0x7FL;
        by = dataInput.readByte();
        l2 |= ((long)by & 0x7FL) << 7;
        if (by >= 0) {
            return l2;
        }
        by = dataInput.readByte();
        l2 |= ((long)by & 0x7FL) << 14;
        if (by >= 0) {
            return l2;
        }
        by = dataInput.readByte();
        l2 |= ((long)by & 0x7FL) << 21;
        if (by >= 0) {
            return l2;
        }
        by = dataInput.readByte();
        l2 |= ((long)by & 0x7FL) << 28;
        if (by >= 0) {
            return l2;
        }
        by = dataInput.readByte();
        l2 |= ((long)by & 0x7FL) << 35;
        if (by >= 0) {
            return l2;
        }
        by = dataInput.readByte();
        l2 |= ((long)by & 0x7FL) << 42;
        if (by >= 0) {
            return l2;
        }
        by = dataInput.readByte();
        l2 |= ((long)by & 0x7FL) << 49;
        if (by >= 0) {
            return l2;
        }
        by = dataInput.readByte();
        return l2 | ((long)by & 0xFFL) << 56;
    }

    public BlockPackedReaderIterator(DataInput dataInput, int n2, int n3, long l2) {
        PackedInts.checkBlockSize(n3, 64, 0x8000000);
        this.packedIntsVersion = n2;
        this.blockSize = n3;
        this.values = new long[n3];
        this.valuesRef = new LongsRef(this.values, 0, 0);
        this.reset(dataInput, l2);
    }

    public final void reset(DataInput dataInput, long l2) {
        this.in = dataInput;
        assert (l2 >= 0L);
        this.valueCount = l2;
        this.off = this.blockSize;
        this.ord = 0L;
    }

    public final void skip(long l2) throws IOException {
        assert (l2 >= 0L);
        if (this.ord + l2 > this.valueCount || this.ord + l2 < 0L) {
            throw new EOFException();
        }
        int n2 = (int)Math.min(l2, (long)(this.blockSize - this.off));
        this.off += n2;
        this.ord += (long)n2;
        if ((l2 -= (long)n2) == 0L) {
            return;
        }
        assert (this.off == this.blockSize);
        while (l2 >= (long)this.blockSize) {
            n2 = this.in.readByte() & 0xFF;
            int n3 = n2 >>> 1;
            if (n3 > 64) {
                throw new IOException("Corrupted");
            }
            if ((n2 & 1) == 0) {
                BlockPackedReaderIterator.readVLong(this.in);
            }
            long l3 = PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, this.blockSize, n3);
            this.skipBytes(l3);
            this.ord += (long)this.blockSize;
            l2 -= (long)this.blockSize;
        }
        if (l2 == 0L) {
            return;
        }
        assert (l2 < (long)this.blockSize);
        this.refill();
        this.ord += l2;
        this.off = (int)((long)this.off + l2);
    }

    private void skipBytes(long l2) throws IOException {
        int n2;
        if (this.in instanceof IndexInput) {
            IndexInput indexInput = (IndexInput)this.in;
            indexInput.seek(indexInput.getFilePointer() + l2);
            return;
        }
        if (this.blocks == null) {
            this.blocks = new byte[this.blockSize];
        }
        for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
            n2 = (int)Math.min((long)this.blocks.length, l2 - i2);
            this.in.readBytes(this.blocks, 0, n2);
        }
    }

    public final long next() throws IOException {
        if (this.ord == this.valueCount) {
            throw new EOFException();
        }
        if (this.off == this.blockSize) {
            this.refill();
        }
        long l2 = this.values[this.off++];
        ++this.ord;
        return l2;
    }

    public final LongsRef next(int n2) throws IOException {
        assert (n2 > 0);
        if (this.ord == this.valueCount) {
            throw new EOFException();
        }
        if (this.off == this.blockSize) {
            this.refill();
        }
        n2 = (int)Math.min((long)Math.min(n2, this.blockSize - this.off), this.valueCount - this.ord);
        this.valuesRef.offset = this.off;
        this.valuesRef.length = n2;
        this.off += n2;
        this.ord += (long)n2;
        return this.valuesRef;
    }

    private void refill() throws IOException {
        long l2;
        boolean bl;
        int n2 = this.in.readByte() & 0xFF;
        boolean bl2 = bl = (n2 & 1) != 0;
        if ((n2 >>>= 1) > 64) {
            throw new IOException("Corrupted");
        }
        long l3 = l2 = bl ? 0L : BitUtil.zigZagDecode(1L + BlockPackedReaderIterator.readVLong(this.in));
        assert (bl || l2 != 0L);
        if (n2 == 0) {
            Arrays.fill(this.values, l2);
        } else {
            PackedInts.a a2 = PackedInts.getDecoder(PackedInts.Format.PACKED, this.packedIntsVersion, n2);
            int n3 = this.blockSize / a2.byteValueCount();
            int n4 = n3 * a2.byteBlockCount();
            if (this.blocks == null || this.blocks.length < n4) {
                this.blocks = new byte[n4];
            }
            n4 = (int)Math.min(this.valueCount - this.ord, (long)this.blockSize);
            n2 = (int)PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, n4, n2);
            this.in.readBytes(this.blocks, 0, n2);
            a2.decode(this.blocks, 0, this.values, 0, n3);
            if (l2 != 0L) {
                n2 = 0;
                while (n2 < n4) {
                    int n5 = n2++;
                    this.values[n5] = this.values[n5] + l2;
                }
            }
        }
        this.off = 0;
    }

    public final long ord() {
        return this.ord;
    }
}

