/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.mutable;

import org.apache.lucene.util.mutable.MutableValue;

public class MutableValueFloat
extends MutableValue {
    public float value;

    @Override
    public Object toObject() {
        assert (this.exists || 0.0f == this.value);
        if (this.exists) {
            return Float.valueOf(this.value);
        }
        return null;
    }

    @Override
    public void copy(MutableValue mutableValue) {
        mutableValue = (MutableValueFloat)mutableValue;
        this.value = ((MutableValueFloat)mutableValue).value;
        this.exists = ((MutableValueFloat)mutableValue).exists;
    }

    @Override
    public MutableValue duplicate() {
        MutableValueFloat mutableValueFloat = new MutableValueFloat();
        new MutableValueFloat().value = this.value;
        mutableValueFloat.exists = this.exists;
        return mutableValueFloat;
    }

    @Override
    public boolean equalsSameType(Object object) {
        assert (this.exists || 0.0f == this.value);
        object = (MutableValueFloat)object;
        return this.value == ((MutableValueFloat)object).value && this.exists == ((MutableValueFloat)object).exists;
    }

    @Override
    public int compareSameType(Object object) {
        assert (this.exists || 0.0f == this.value);
        object = (MutableValueFloat)object;
        int n2 = Float.compare(this.value, ((MutableValueFloat)object).value);
        if (n2 != 0) {
            return n2;
        }
        if (this.exists == ((MutableValueFloat)object).exists) {
            return 0;
        }
        if (this.exists) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        assert (this.exists || 0.0f == this.value);
        return Float.floatToIntBits(this.value);
    }
}

