/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.b;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.BytesStore;
import org.apache.lucene.util.fst.ForwardBytesReader;
import org.apache.lucene.util.fst.ReverseBytesReader;
import org.apache.lucene.util.packed.GrowableWriter;
import org.apache.lucene.util.packed.PackedInts;

public final class FST<T>
implements org.apache.lucene.util.a {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FST.class);
    private static final long ARC_SHALLOW_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Arc.class);
    public final INPUT_TYPE inputType;
    T emptyOutput;
    final BytesStore bytes;
    final byte[] bytesArray;
    private long startNode = -1L;
    public final org.apache.lucene.util.fst.a<T> outputs;
    private final boolean packed;
    private PackedInts.Reader nodeRefToAddress;
    private Arc<T>[] cachedRootArcs;
    private GrowableWriter nodeAddress;
    private GrowableWriter inCounts;
    private final int version;
    public static final int DEFAULT_MAX_BLOCK_BITS = Constants.JRE_IS_64BIT ? 30 : 28;
    private int cachedArcsBytesUsed;

    private static boolean flag(int n2, int n3) {
        return (n2 & n3) != 0;
    }

    FST(INPUT_TYPE iNPUT_TYPE, org.apache.lucene.util.fst.a<T> a2, boolean bl, float f2, int n2) {
        this.inputType = iNPUT_TYPE;
        this.outputs = a2;
        this.version = 5;
        this.bytesArray = null;
        this.bytes = new BytesStore(n2);
        this.bytes.writeByte((byte)0);
        if (bl) {
            this.nodeAddress = new GrowableWriter(15, 8, f2);
            this.inCounts = new GrowableWriter(1, 8, f2);
        } else {
            this.nodeAddress = null;
            this.inCounts = null;
        }
        this.emptyOutput = null;
        this.packed = false;
        this.nodeRefToAddress = null;
    }

    public FST(DataInput dataInput, org.apache.lucene.util.fst.a<T> a2) throws IOException {
        this(dataInput, a2, DEFAULT_MAX_BLOCK_BITS);
    }

    public FST(DataInput dataInput, org.apache.lucene.util.fst.a<T> a2, int n2) throws IOException {
        long l2;
        this.outputs = a2;
        if (n2 <= 0 || n2 > 30) {
            throw new IllegalArgumentException("maxBlockBits should be 1 .. 30; got " + n2);
        }
        this.version = CodecUtil.checkHeader(dataInput, "FST", 3, 5);
        boolean bl = this.packed = dataInput.readByte() == 1;
        if (dataInput.readByte() == 1) {
            a a3;
            BytesStore bytesStore = new BytesStore(10);
            int n3 = dataInput.readVInt();
            bytesStore.copyBytes(dataInput, n3);
            if (this.packed) {
                a3 = bytesStore.getForwardReader();
            } else {
                a3 = bytesStore.getReverseReader();
                if (n3 > 0) {
                    a3.setPosition(n3 - 1);
                }
            }
            this.emptyOutput = a2.readFinalOutput(a3);
        } else {
            this.emptyOutput = null;
        }
        byte by = dataInput.readByte();
        switch (by) {
            case 0: {
                this.inputType = INPUT_TYPE.BYTE1;
                break;
            }
            case 1: {
                this.inputType = INPUT_TYPE.BYTE2;
                break;
            }
            case 2: {
                this.inputType = INPUT_TYPE.BYTE4;
                break;
            }
            default: {
                throw new IllegalStateException("invalid input type " + by);
            }
        }
        this.nodeRefToAddress = this.packed ? PackedInts.getReader(dataInput) : null;
        this.startNode = dataInput.readVLong();
        if (this.version < 5) {
            dataInput.readVLong();
            dataInput.readVLong();
            dataInput.readVLong();
        }
        if ((l2 = dataInput.readVLong()) > (long)(1 << n2)) {
            this.bytes = new BytesStore(dataInput, l2, 1 << n2);
            this.bytesArray = null;
        } else {
            this.bytes = null;
            this.bytesArray = new byte[(int)l2];
            dataInput.readBytes(this.bytesArray, 0, this.bytesArray.length);
        }
        this.cacheRootArcs();
    }

    private long ramBytesUsed(Arc<T>[] arcArray) {
        long l2 = 0L;
        if (arcArray != null) {
            l2 = 0L + RamUsageEstimator.shallowSizeOf(arcArray);
            for (Arc<T> arc : arcArray) {
                if (arc == null) continue;
                l2 += ARC_SHALLOW_RAM_BYTES_USED;
                if (arc.output != null && arc.output != this.outputs.getNoOutput()) {
                    l2 += this.outputs.ramBytesUsed(arc.output);
                }
                if (arc.nextFinalOutput == null || arc.nextFinalOutput == this.outputs.getNoOutput()) continue;
                l2 += this.outputs.ramBytesUsed(arc.nextFinalOutput);
            }
        }
        return l2;
    }

    @Override
    public final long ramBytesUsed() {
        long l2 = BASE_RAM_BYTES_USED;
        l2 = this.bytesArray != null ? (l2 += (long)this.bytesArray.length) : (l2 += this.bytes.ramBytesUsed());
        if (this.packed) {
            l2 += this.nodeRefToAddress.ramBytesUsed();
        } else if (this.nodeAddress != null) {
            l2 = l2 + this.nodeAddress.ramBytesUsed() + this.inCounts.ramBytesUsed();
        }
        return l2 + (long)this.cachedArcsBytesUsed;
    }

    @Override
    public final Collection<org.apache.lucene.util.a> getChildResources() {
        ArrayList<org.apache.lucene.util.a> arrayList = new ArrayList<org.apache.lucene.util.a>();
        if (this.packed) {
            arrayList.add(b.a("node ref to address", this.nodeRefToAddress));
        } else if (this.nodeAddress != null) {
            arrayList.add(b.a("node addresses", this.nodeAddress));
            arrayList.add(b.a("in counts", this.inCounts));
        }
        return arrayList;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(input=" + (Object)((Object)this.inputType) + ",output=" + this.outputs + ",packed=" + this.packed;
    }

    final void finish(long l2) throws IOException {
        assert (l2 <= this.bytes.getPosition());
        if (this.startNode != -1L) {
            throw new IllegalStateException("already finished");
        }
        if (l2 == -1L && this.emptyOutput != null) {
            l2 = 0L;
        }
        this.startNode = l2;
        this.bytes.finish();
        this.cacheRootArcs();
    }

    private long getNodeAddress(long l2) {
        if (this.nodeAddress != null) {
            return this.nodeAddress.get((int)l2);
        }
        return l2;
    }

    private void cacheRootArcs() throws IOException {
        assert (this.cachedArcsBytesUsed == 0);
        Arc arc = new Arc();
        this.getFirstArc(arc);
        if (FST.targetHasArcs(arc)) {
            a a2 = this.getBytesReader();
            Arc[] arcArray = new Arc[128];
            this.readFirstRealTargetArc(arc.target, arc, a2);
            int n2 = 0;
            while (true) {
                assert (arc.label != -1);
                if (arc.label >= arcArray.length) break;
                arcArray[arc.label] = new Arc().copyFrom(arc);
                if (arc.isLast()) break;
                this.readNextRealArc(arc, a2);
                ++n2;
            }
            int n3 = (int)this.ramBytesUsed(arcArray);
            if (n2 >= 5 && (long)n3 < this.ramBytesUsed() / 5L) {
                this.cachedRootArcs = arcArray;
                this.cachedArcsBytesUsed = n3;
            }
        }
    }

    public final T getEmptyOutput() {
        return this.emptyOutput;
    }

    final void setEmptyOutput(T t2) throws IOException {
        if (this.emptyOutput != null) {
            this.emptyOutput = this.outputs.merge(this.emptyOutput, t2);
            return;
        }
        this.emptyOutput = t2;
    }

    public final void save(DataOutput dataOutput) throws IOException {
        if (this.startNode == -1L) {
            throw new IllegalStateException("call finish first");
        }
        if (this.nodeAddress != null) {
            throw new IllegalStateException("cannot save an FST pre-packed FST; it must first be packed");
        }
        if (this.packed && !(this.nodeRefToAddress instanceof PackedInts.Mutable)) {
            throw new IllegalStateException("cannot save a FST which has been loaded from disk ");
        }
        CodecUtil.writeHeader(dataOutput, "FST", 5);
        if (this.packed) {
            dataOutput.writeByte((byte)1);
        } else {
            dataOutput.writeByte((byte)0);
        }
        if (this.emptyOutput != null) {
            dataOutput.writeByte((byte)1);
            RAMOutputStream rAMOutputStream = new RAMOutputStream();
            this.outputs.writeFinalOutput(this.emptyOutput, rAMOutputStream);
            byte[] byArray = new byte[(int)rAMOutputStream.getFilePointer()];
            rAMOutputStream.writeTo(byArray, 0);
            if (!this.packed) {
                int n2 = byArray.length / 2;
                for (int i2 = 0; i2 < n2; ++i2) {
                    byte by = byArray[i2];
                    byArray[i2] = byArray[byArray.length - i2 - 1];
                    byArray[byArray.length - i2 - 1] = by;
                }
            }
            dataOutput.writeVInt(byArray.length);
            dataOutput.writeBytes(byArray, 0, byArray.length);
        } else {
            dataOutput.writeByte((byte)0);
        }
        int n3 = this.inputType == INPUT_TYPE.BYTE1 ? 0 : (this.inputType == INPUT_TYPE.BYTE2 ? 1 : 2);
        dataOutput.writeByte((byte)n3);
        if (this.packed) {
            ((PackedInts.Mutable)this.nodeRefToAddress).save(dataOutput);
        }
        dataOutput.writeVLong(this.startNode);
        if (this.bytes != null) {
            long l2 = this.bytes.getPosition();
            dataOutput.writeVLong(l2);
            this.bytes.writeTo(dataOutput);
            return;
        }
        assert (this.bytesArray != null);
        dataOutput.writeVLong(this.bytesArray.length);
        dataOutput.writeBytes(this.bytesArray, 0, this.bytesArray.length);
    }

    private void writeLabel(DataOutput dataOutput, int n2) throws IOException {
        assert (n2 >= 0) : "v=" + n2;
        if (this.inputType == INPUT_TYPE.BYTE1) {
            assert (n2 <= 255) : "v=" + n2;
            dataOutput.writeByte((byte)n2);
            return;
        }
        if (this.inputType == INPUT_TYPE.BYTE2) {
            assert (n2 <= 65535) : "v=" + n2;
            dataOutput.writeShort((short)n2);
            return;
        }
        dataOutput.writeVInt(n2);
    }

    public final int readLabel(DataInput dataInput) throws IOException {
        int n2 = this.inputType == INPUT_TYPE.BYTE1 ? dataInput.readByte() & 0xFF : (this.inputType == INPUT_TYPE.BYTE2 ? dataInput.readShort() & 0xFFFF : dataInput.readVInt());
        return n2;
    }

    public static <T> boolean targetHasArcs(Arc<T> arc) {
        return arc.target > 0L;
    }

    final long addNode(Builder<T> builder, Builder.UnCompiledNode<T> unCompiledNode) throws IOException {
        long l2;
        int n2;
        Object object;
        Object object2;
        T t2 = this.outputs.getNoOutput();
        if (unCompiledNode.numArcs == 0) {
            if (unCompiledNode.isFinal) {
                return -1L;
            }
            return 0L;
        }
        long l3 = builder.bytes.getPosition();
        boolean bl = this.shouldExpand(builder, unCompiledNode);
        if (bl && builder.reusedBytesPerArc.length < unCompiledNode.numArcs) {
            builder.reusedBytesPerArc = new int[ArrayUtil.oversize(unCompiledNode.numArcs, 1)];
        }
        builder.arcCount += (long)unCompiledNode.numArcs;
        int n3 = unCompiledNode.numArcs - 1;
        long l4 = builder.bytes.getPosition();
        int n4 = 0;
        for (int i2 = 0; i2 < unCompiledNode.numArcs; ++i2) {
            boolean bl2;
            object2 = unCompiledNode.arcs[i2];
            object = (Builder.CompiledNode)((Builder.Arc)object2).target;
            n2 = 0;
            if (i2 == n3) {
                n2 += 2;
            }
            if (builder.lastFrozenNode == ((Builder.CompiledNode)object).node && !bl) {
                n2 += 4;
            }
            if (((Builder.Arc)object2).isFinal) {
                ++n2;
                if (((Builder.Arc)object2).nextFinalOutput != t2) {
                    n2 += 32;
                }
            } else assert (((Builder.Arc)object2).nextFinalOutput == t2);
            if (!(bl2 = ((Builder.CompiledNode)object).node > 0L)) {
                n2 += 8;
            } else if (this.inCounts != null) {
                this.inCounts.set((int)((Builder.CompiledNode)object).node, this.inCounts.get((int)((Builder.CompiledNode)object).node) + 1L);
            }
            if (((Builder.Arc)object2).output != t2) {
                n2 += 16;
            }
            builder.bytes.writeByte((byte)n2);
            this.writeLabel(builder.bytes, ((Builder.Arc)object2).label);
            if (((Builder.Arc)object2).output != t2) {
                this.outputs.write(((Builder.Arc)object2).output, builder.bytes);
            }
            if (((Builder.Arc)object2).nextFinalOutput != t2) {
                this.outputs.writeFinalOutput(((Builder.Arc)object2).nextFinalOutput, builder.bytes);
            }
            if (bl2 && (n2 & 4) == 0) {
                assert (((Builder.CompiledNode)object).node > 0L);
                builder.bytes.writeVLong(((Builder.CompiledNode)object).node);
            }
            if (!bl) continue;
            builder.reusedBytesPerArc[i2] = (int)(builder.bytes.getPosition() - l4);
            l4 = builder.bytes.getPosition();
            n4 = Math.max(n4, builder.reusedBytesPerArc[i2]);
        }
        if (bl) {
            assert (n4 > 0);
            object2 = new byte[11];
            object = new ByteArrayDataOutput((byte[])object2);
            ((ByteArrayDataOutput)object).writeByte((byte)32);
            ((DataOutput)object).writeVInt(unCompiledNode.numArcs);
            ((DataOutput)object).writeVInt(n4);
            n2 = ((ByteArrayDataOutput)object).getPosition();
            long l5 = l3 + (long)n2;
            long l6 = builder.bytes.getPosition();
            long l7 = l5 + (long)(unCompiledNode.numArcs * n4);
            assert (l7 >= l6);
            if (l7 > l6) {
                builder.bytes.skipBytes((int)(l7 - l6));
                for (int i3 = unCompiledNode.numArcs - 1; i3 >= 0; --i3) {
                    if ((l6 -= (long)builder.reusedBytesPerArc[i3]) == (l7 -= (long)n4)) continue;
                    assert (l7 > l6) : "destPos=" + l7 + " srcPos=" + l6 + " arcIdx=" + i3 + " maxBytesPerArc=" + n4 + " reusedBytesPerArc[arcIdx]=" + builder.reusedBytesPerArc[i3] + " nodeIn.numArcs=" + unCompiledNode.numArcs;
                    builder.bytes.copyBytes(l6, l7, builder.reusedBytesPerArc[i3]);
                }
            }
            builder.bytes.writeBytes(l3, (byte[])object2, 0, n2);
        }
        long l8 = builder.bytes.getPosition() - 1L;
        builder.bytes.reverse(l3, l8);
        if (this.nodeAddress != null && builder.nodeCount == Integer.MAX_VALUE) {
            throw new IllegalStateException("cannot create a packed FST with more than 2.1 billion nodes");
        }
        ++builder.nodeCount;
        if (this.nodeAddress != null) {
            if ((int)builder.nodeCount == this.nodeAddress.size()) {
                this.nodeAddress = this.nodeAddress.resize(ArrayUtil.oversize(this.nodeAddress.size() + 1, this.nodeAddress.getBitsPerValue()));
                this.inCounts = this.inCounts.resize(ArrayUtil.oversize(this.inCounts.size() + 1, this.inCounts.getBitsPerValue()));
            }
            this.nodeAddress.set((int)builder.nodeCount, l8);
            l2 = builder.nodeCount;
        } else {
            l2 = l8;
        }
        return l2;
    }

    public final Arc<T> getFirstArc(Arc<T> arc) {
        T t2 = this.outputs.getNoOutput();
        if (this.emptyOutput != null) {
            arc.flags = (byte)3;
            arc.nextFinalOutput = this.emptyOutput;
            if (this.emptyOutput != t2) {
                arc.flags = (byte)(arc.flags | 0x20);
            }
        } else {
            arc.flags = (byte)2;
            arc.nextFinalOutput = t2;
        }
        arc.output = t2;
        arc.target = this.startNode;
        return arc;
    }

    private long readUnpackedNodeTarget(a a2) throws IOException {
        long l2 = this.version < 4 ? (long)a2.readInt() : a2.readVLong();
        return l2;
    }

    public final Arc<T> readFirstTargetArc(Arc<T> arc, Arc<T> arc2, a a2) throws IOException {
        if (arc.isFinal()) {
            arc2.label = -1;
            arc2.output = arc.nextFinalOutput;
            arc2.flags = 1;
            if (arc.target <= 0L) {
                arc2.flags = (byte)(arc2.flags | 2);
            } else {
                arc2.node = arc.target;
                arc2.nextArc = arc.target;
            }
            arc2.target = -1L;
            return arc2;
        }
        return this.readFirstRealTargetArc(arc.target, arc2, a2);
    }

    public final Arc<T> readFirstRealTargetArc(long l2, Arc<T> arc, a a2) throws IOException {
        long l3 = this.getNodeAddress(l2);
        a2.setPosition(l3);
        arc.node = l2;
        if (a2.readByte() == 32) {
            arc.numArcs = a2.readVInt();
            arc.bytesPerArc = this.packed || this.version >= 4 ? a2.readVInt() : a2.readInt();
            arc.arcIdx = -1;
            arc.nextArc = arc.posArcsStart = a2.getPosition();
        } else {
            arc.nextArc = l3;
            arc.bytesPerArc = 0;
        }
        return this.readNextRealArc(arc, a2);
    }

    public final Arc<T> readNextArc(Arc<T> arc, a a2) throws IOException {
        if (arc.label == -1) {
            if (arc.nextArc <= 0L) {
                throw new IllegalArgumentException("cannot readNextArc when arc.isLast()=true");
            }
            return this.readFirstRealTargetArc(arc.nextArc, arc, a2);
        }
        return this.readNextRealArc(arc, a2);
    }

    public final Arc<T> readNextRealArc(Arc<T> arc, a a2) throws IOException {
        if (arc.bytesPerArc != 0) {
            ++arc.arcIdx;
            assert (arc.arcIdx < arc.numArcs);
            a2.setPosition(arc.posArcsStart);
            a2.skipBytes(arc.arcIdx * arc.bytesPerArc);
        } else {
            a2.setPosition(arc.nextArc);
        }
        arc.flags = a2.readByte();
        arc.label = this.readLabel(a2);
        arc.output = arc.flag(16) ? this.outputs.read(a2) : this.outputs.getNoOutput();
        arc.nextFinalOutput = arc.flag(32) ? this.outputs.readFinalOutput(a2) : this.outputs.getNoOutput();
        if (arc.flag(8)) {
            arc.target = arc.flag(1) ? -1L : 0L;
            arc.nextArc = a2.getPosition();
        } else if (arc.flag(4)) {
            arc.nextArc = a2.getPosition();
            if (this.nodeAddress == null) {
                if (!arc.flag(2)) {
                    if (arc.bytesPerArc == 0) {
                        this.seekToNextNode(a2);
                    } else {
                        a2.setPosition(arc.posArcsStart);
                        a2.skipBytes(arc.bytesPerArc * arc.numArcs);
                    }
                }
                arc.target = a2.getPosition();
            } else {
                arc.target = arc.node - 1L;
                assert (arc.target > 0L);
            }
        } else {
            if (this.packed) {
                long l2 = a2.getPosition();
                long l3 = a2.readVLong();
                arc.target = arc.flag(64) ? l2 + l3 : (l3 < (long)this.nodeRefToAddress.size() ? this.nodeRefToAddress.get((int)l3) : l3);
            } else {
                arc.target = this.readUnpackedNodeTarget(a2);
            }
            arc.nextArc = a2.getPosition();
        }
        return arc;
    }

    private boolean assertRootCachedArc(int n2, Arc<T> arc) throws IOException {
        Arc arc2 = new Arc();
        this.getFirstArc(arc2);
        a a2 = this.getBytesReader();
        Arc arc3 = this.findTargetArc(n2, arc2, arc2, a2, false);
        if (arc3 == null) {
            assert (arc == null);
        } else {
            assert (arc != null);
            assert (arc.arcIdx == arc3.arcIdx);
            assert (arc.bytesPerArc == arc3.bytesPerArc);
            assert (arc.flags == arc3.flags);
            assert (arc.label == arc3.label);
            assert (arc.nextArc == arc3.nextArc);
            assert (arc.nextFinalOutput.equals(arc3.nextFinalOutput));
            assert (arc.node == arc3.node);
            assert (arc.numArcs == arc3.numArcs);
            assert (arc.output.equals(arc3.output));
            assert (arc.posArcsStart == arc3.posArcsStart);
            assert (arc.target == arc3.target);
        }
        return true;
    }

    public final Arc<T> findTargetArc(int n2, Arc<T> arc, Arc<T> arc2, a a2) throws IOException {
        return this.findTargetArc(n2, arc, arc2, a2, true);
    }

    private Arc<T> findTargetArc(int n2, Arc<T> arc, Arc<T> arc2, a a2, boolean n3) throws IOException {
        if (n2 == -1) {
            if (arc.isFinal()) {
                if (arc.target <= 0L) {
                    arc2.flags = (byte)2;
                } else {
                    arc2.flags = 0;
                    arc2.nextArc = arc.target;
                    arc2.node = arc.target;
                }
                arc2.output = arc.nextFinalOutput;
                arc2.label = -1;
                return arc2;
            }
            return null;
        }
        if (n3 && this.cachedRootArcs != null && arc.target == this.startNode && n2 < this.cachedRootArcs.length) {
            arc = this.cachedRootArcs[n2];
            assert (this.assertRootCachedArc(n2, arc));
            if (arc == null) {
                return null;
            }
            arc2.copyFrom(arc);
            return arc2;
        }
        if (!FST.targetHasArcs(arc)) {
            return null;
        }
        a2.setPosition(this.getNodeAddress(arc.target));
        arc2.node = arc.target;
        if (a2.readByte() == 32) {
            arc2.numArcs = a2.readVInt();
            arc2.bytesPerArc = this.packed || this.version >= 4 ? a2.readVInt() : a2.readInt();
            arc2.posArcsStart = a2.getPosition();
            int n4 = 0;
            n3 = arc2.numArcs - 1;
            while (n4 <= n3) {
                int n5 = n4 + n3 >>> 1;
                a2.setPosition(arc2.posArcsStart);
                a2.skipBytes(arc2.bytesPerArc * n5 + 1);
                int n6 = this.readLabel(a2) - n2;
                if (n6 < 0) {
                    n4 = n5 + 1;
                    continue;
                }
                if (n6 > 0) {
                    n3 = n5 - 1;
                    continue;
                }
                arc2.arcIdx = n5 - 1;
                return this.readNextRealArc(arc2, a2);
            }
            return null;
        }
        this.readFirstRealTargetArc(arc.target, arc2, a2);
        while (arc2.label != n2) {
            if (arc2.label > n2) {
                return null;
            }
            if (arc2.isLast()) {
                return null;
            }
            this.readNextRealArc(arc2, a2);
        }
        return arc2;
    }

    private void seekToNextNode(a a2) throws IOException {
        byte by;
        do {
            by = a2.readByte();
            this.readLabel(a2);
            if (FST.flag(by, 16)) {
                this.outputs.skipOutput(a2);
            }
            if (FST.flag(by, 32)) {
                this.outputs.skipFinalOutput(a2);
            }
            if (FST.flag(by, 8) || FST.flag(by, 4)) continue;
            if (this.packed) {
                a2.readVLong();
                continue;
            }
            this.readUnpackedNodeTarget(a2);
        } while (!FST.flag(by, 2));
    }

    private boolean shouldExpand(Builder<T> builder, Builder.UnCompiledNode<T> unCompiledNode) {
        return builder.allowArrayArcs && (unCompiledNode.depth <= 3 && unCompiledNode.numArcs >= 5 || unCompiledNode.numArcs >= 10);
    }

    public final a getBytesReader() {
        if (this.packed) {
            if (this.bytesArray != null) {
                return new ForwardBytesReader(this.bytesArray);
            }
            return this.bytes.getForwardReader();
        }
        if (this.bytesArray != null) {
            return new ReverseBytesReader(this.bytesArray);
        }
        return this.bytes.getReverseReader();
    }

    private FST(INPUT_TYPE iNPUT_TYPE, org.apache.lucene.util.fst.a<T> a2, int n2) {
        this.version = 5;
        this.packed = true;
        this.inputType = iNPUT_TYPE;
        this.bytesArray = null;
        this.bytes = new BytesStore(n2);
        this.outputs = a2;
    }

    final FST<T> pack(Builder<T> builder, int n2, int n3, float f2) throws IOException {
        FST<T> fST;
        boolean bl;
        boolean bl2;
        if (this.nodeAddress == null) {
            throw new IllegalArgumentException("this FST was not built with willPackFST=true");
        }
        T t2 = this.outputs.getNoOutput();
        Arc arc = new Arc();
        a a2 = this.getBytesReader();
        n3 = Math.min(n3, this.inCounts.size());
        Object object = new NodeQueue(n3);
        NodeAndInCount nodeAndInCount = null;
        for (int i2 = 0; i2 < this.inCounts.size(); ++i2) {
            if (this.inCounts.get(i2) < (long)n2) continue;
            if (nodeAndInCount == null) {
                ((PriorityQueue)object).add(new NodeAndInCount(i2, (int)this.inCounts.get(i2)));
                if (((PriorityQueue)object).size() != n3) continue;
                nodeAndInCount = (NodeAndInCount)((PriorityQueue)object).top();
                continue;
            }
            if (this.inCounts.get(i2) <= (long)nodeAndInCount.count) continue;
            ((PriorityQueue)object).insertWithOverflow(new NodeAndInCount(i2, (int)this.inCounts.get(i2)));
        }
        this.inCounts = null;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (n2 = ((PriorityQueue)object).size() - 1; n2 >= 0; --n2) {
            NodeAndInCount nodeAndInCount2 = (NodeAndInCount)((PriorityQueue)object).pop();
            hashMap.put(nodeAndInCount2.node, n2);
        }
        GrowableWriter growableWriter = new GrowableWriter(PackedInts.bitsRequired(builder.bytes.getPosition()), (int)(1L + builder.nodeCount), f2);
        n3 = 1;
        while ((long)n3 <= builder.nodeCount) {
            growableWriter.set(n3, 1L + builder.bytes.getPosition() - this.nodeAddress.get(n3));
            ++n3;
        }
        do {
            bl2 = false;
            bl = false;
            fST = new FST<T>(this.inputType, this.outputs, builder.bytes.getBlockBits());
            object = fST.bytes;
            ((BytesStore)object).writeByte((byte)0);
            long l2 = 0L;
            for (int i3 = (int)builder.nodeCount; i3 > 0; --i3) {
                long l3 = ((BytesStore)object).getPosition();
                if (l3 != growableWriter.get(i3)) {
                    l2 = l3 - growableWriter.get(i3);
                    bl2 = true;
                    growableWriter.set(i3, l3);
                }
                int n4 = 0;
                boolean bl3 = false;
                boolean bl4 = false;
                while (true) {
                    this.readFirstRealTargetArc(i3, arc, a2);
                    boolean bl5 = arc.bytesPerArc != 0;
                    if (bl5) {
                        if (n4 == 0) {
                            n4 = arc.bytesPerArc;
                        }
                        ((BytesStore)object).writeByte((byte)32);
                        ((DataOutput)object).writeVInt(arc.numArcs);
                        ((DataOutput)object).writeVInt(n4);
                    }
                    int n5 = 0;
                    while (true) {
                        long l4;
                        boolean bl6;
                        long l5 = ((BytesStore)object).getPosition();
                        byte by = 0;
                        if (arc.isLast()) {
                            by = 2;
                        }
                        if (!bl5 && i3 != 1 && arc.target == (long)(i3 - 1)) {
                            by = (byte)(by + 4);
                        }
                        if (arc.isFinal()) {
                            by = (byte)(by + 1);
                            if (arc.nextFinalOutput != t2) {
                                by = (byte)(by + 32);
                            }
                        } else assert (arc.nextFinalOutput == t2);
                        if (!FST.targetHasArcs(arc)) {
                            by = (byte)(by + 8);
                        }
                        if (arc.output != t2) {
                            by = (byte)(by + 16);
                        }
                        if (bl6 = FST.targetHasArcs(arc) && (by & 4) == 0) {
                            Integer n6 = (Integer)hashMap.get(arc.target);
                            l4 = n6 != null ? (long)n6.intValue() : (long)hashMap.size() + growableWriter.get((int)arc.target) + l2;
                            long l6 = growableWriter.get((int)arc.target) + l2 - ((BytesStore)object).getPosition() - 2L;
                            if (l6 < 0L) {
                                bl4 = true;
                                l6 = 0L;
                            }
                            if (l6 < l4) {
                                by = (byte)(by | 0x40);
                            }
                        } else {
                            l4 = 0L;
                        }
                        assert (by != 32);
                        ((BytesStore)object).writeByte(by);
                        super.writeLabel((DataOutput)object, arc.label);
                        if (arc.output != t2) {
                            this.outputs.write(arc.output, (DataOutput)object);
                        }
                        if (arc.nextFinalOutput != t2) {
                            this.outputs.writeFinalOutput(arc.nextFinalOutput, (DataOutput)object);
                        }
                        if (bl6) {
                            long l7 = growableWriter.get((int)arc.target) + l2 - ((BytesStore)object).getPosition();
                            if (l7 < 0L) {
                                bl4 = true;
                                l7 = 0L;
                            }
                            if (FST.flag(by, 64)) {
                                ((DataOutput)object).writeVLong(l7);
                                if (!bl3) {
                                    // empty if block
                                }
                            } else {
                                ((DataOutput)object).writeVLong(l4);
                                if (!bl3) {
                                    hashMap.size();
                                }
                            }
                        }
                        if (bl5) {
                            int n7 = (int)(((BytesStore)object).getPosition() - l5);
                            n5 = Math.max(n5, n7);
                            ((BytesStore)object).skipBytes((int)(l5 + (long)n4 - ((BytesStore)object).getPosition()));
                        }
                        if (arc.isLast()) break;
                        this.readNextRealArc(arc, a2);
                    }
                    if (!bl5 || n5 == n4 || bl3 && n5 <= n4) break;
                    n4 = n5;
                    ((BytesStore)object).truncate(l3);
                    bl3 = true;
                    bl4 = false;
                }
                bl |= bl4;
            }
        } while (bl2);
        assert (!bl);
        long l8 = 0L;
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            long l9 = ((Integer)object.next()).intValue();
            l8 = Math.max(l8, growableWriter.get((int)l9));
        }
        object = PackedInts.getMutable(hashMap.size(), PackedInts.bitsRequired(l8), f2);
        for (Map.Entry entry : hashMap.entrySet()) {
            ((PackedInts.Mutable)object).set((Integer)entry.getValue(), growableWriter.get((Integer)entry.getKey()));
        }
        fST.nodeRefToAddress = object;
        fST.startNode = growableWriter.get((int)this.startNode);
        if (this.emptyOutput != null) {
            fST.setEmptyOutput(this.emptyOutput);
        }
        fST.bytes.finish();
        super.cacheRootArcs();
        return fST;
    }

    private static class NodeQueue
    extends PriorityQueue<NodeAndInCount> {
        public NodeQueue(int n2) {
            super(n2, false);
        }

        @Override
        public boolean lessThan(NodeAndInCount nodeAndInCount, NodeAndInCount nodeAndInCount2) {
            int n2 = nodeAndInCount.compareTo(nodeAndInCount2);
            assert (n2 != 0);
            return n2 < 0;
        }
    }

    private static class NodeAndInCount
    implements Comparable<NodeAndInCount> {
        final int node;
        final int count;

        public NodeAndInCount(int n2, int n3) {
            this.node = n2;
            this.count = n3;
        }

        @Override
        public int compareTo(NodeAndInCount nodeAndInCount) {
            if (this.count > nodeAndInCount.count) {
                return 1;
            }
            if (this.count < nodeAndInCount.count) {
                return -1;
            }
            return nodeAndInCount.node - this.node;
        }
    }

    public static abstract class a
    extends DataInput {
        public abstract long getPosition();

        public abstract void setPosition(long var1);
    }

    public static final class Arc<T> {
        public int label;
        public T output;
        long node;
        public long target;
        byte flags;
        public T nextFinalOutput;
        long nextArc;
        public long posArcsStart;
        public int bytesPerArc;
        public int arcIdx;
        public int numArcs;

        public final Arc<T> copyFrom(Arc<T> arc) {
            this.node = arc.node;
            this.label = arc.label;
            this.target = arc.target;
            this.flags = arc.flags;
            this.output = arc.output;
            this.nextFinalOutput = arc.nextFinalOutput;
            this.nextArc = arc.nextArc;
            this.bytesPerArc = arc.bytesPerArc;
            if (this.bytesPerArc != 0) {
                this.posArcsStart = arc.posArcsStart;
                this.arcIdx = arc.arcIdx;
                this.numArcs = arc.numArcs;
            }
            return this;
        }

        final boolean flag(int n2) {
            return FST.flag(this.flags, n2);
        }

        public final boolean isLast() {
            return this.flag(2);
        }

        public final boolean isFinal() {
            return this.flag(1);
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("node=" + this.node);
            stringBuilder.append(" target=" + this.target);
            stringBuilder.append(" label=0x" + Integer.toHexString(this.label));
            if (this.flag(1)) {
                stringBuilder.append(" final");
            }
            if (this.flag(2)) {
                stringBuilder.append(" last");
            }
            if (this.flag(4)) {
                stringBuilder.append(" targetNext");
            }
            if (this.flag(8)) {
                stringBuilder.append(" stop");
            }
            if (this.flag(16)) {
                stringBuilder.append(" output=" + this.output);
            }
            if (this.flag(32)) {
                stringBuilder.append(" nextFinalOutput=" + this.nextFinalOutput);
            }
            if (this.bytesPerArc != 0) {
                stringBuilder.append(" arcArray(idx=" + this.arcIdx + " of " + this.numArcs + ")");
            }
            return stringBuilder.toString();
        }
    }

    public static enum INPUT_TYPE {
        BYTE1,
        BYTE2,
        BYTE4;

    }
}

