/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTEnum;

public final class BytesRefFSTEnum<T>
extends FSTEnum<T> {
    private final BytesRef current = new BytesRef(10);
    private final InputOutput<T> result = new InputOutput();

    public BytesRefFSTEnum(FST<T> fST) {
        super(fST);
        this.result.input = this.current;
        this.current.offset = 1;
    }

    public final InputOutput<T> next() throws IOException {
        this.doNext();
        return this.setResult();
    }

    @Override
    protected final void setCurrentLabel(int n2) {
        this.current.bytes[this.upto] = (byte)n2;
    }

    @Override
    protected final void grow() {
        this.current.bytes = ArrayUtil.grow(this.current.bytes, this.upto + 1);
    }

    private InputOutput<T> setResult() {
        if (this.upto == 0) {
            return null;
        }
        this.current.length = this.upto - 1;
        this.result.output = this.output[this.upto];
        return this.result;
    }

    public static class InputOutput<T> {
        public BytesRef input;
        public T output;
    }
}

