/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesStore;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.NodeHash;

public class Builder<T> {
    private final NodeHash<T> dedupHash;
    final FST<T> fst;
    private final T NO_OUTPUT;
    private final int minSuffixCount1;
    private final int minSuffixCount2;
    private final boolean doShareNonSingletonNodes;
    private final int shareMaxTailLength;
    private final IntsRefBuilder lastInput = new IntsRefBuilder();
    private final boolean doPackFST;
    private final float acceptableOverheadRatio;
    private UnCompiledNode<T>[] frontier;
    long lastFrozenNode;
    int[] reusedBytesPerArc = new int[4];
    long arcCount;
    long nodeCount;
    boolean allowArrayArcs;
    BytesStore bytes;

    public Builder(FST.INPUT_TYPE unCompiledNodeArray, int n2, int n3, boolean bl, boolean bl2, int n4, org.apache.lucene.util.fst.a<T> a2, boolean bl3, float f2, boolean bl4, int n5) {
        this.minSuffixCount1 = n2;
        this.minSuffixCount2 = n3;
        this.doShareNonSingletonNodes = bl2;
        this.shareMaxTailLength = n4;
        this.doPackFST = bl3;
        this.acceptableOverheadRatio = f2;
        this.allowArrayArcs = bl4;
        this.fst = new FST<T>((FST.INPUT_TYPE)unCompiledNodeArray, a2, bl3, f2, n5);
        this.bytes = this.fst.bytes;
        assert (this.bytes != null);
        this.dedupHash = bl ? new NodeHash<T>(this.fst, this.bytes.getReverseReader(false)) : null;
        this.NO_OUTPUT = a2.getNoOutput();
        unCompiledNodeArray = new UnCompiledNode[10];
        this.frontier = unCompiledNodeArray;
        for (int i2 = 0; i2 < this.frontier.length; ++i2) {
            this.frontier[i2] = new UnCompiledNode(this, i2);
        }
    }

    public long getNodeCount() {
        return 1L + this.nodeCount;
    }

    private CompiledNode compileNode(UnCompiledNode<T> a2, int n2) throws IOException {
        long l2;
        long l3 = this.bytes.getPosition();
        if (this.dedupHash != null && (this.doShareNonSingletonNodes || a2.numArcs <= 1) && n2 <= this.shareMaxTailLength) {
            if (a2.numArcs == 0) {
                this.lastFrozenNode = l2 = this.fst.addNode(this, (UnCompiledNode<T>)a2);
            } else {
                l2 = this.dedupHash.add(this, (UnCompiledNode<T>)a2);
            }
        } else {
            l2 = this.fst.addNode(this, (UnCompiledNode<T>)a2);
        }
        assert (l2 != -2L);
        long l4 = this.bytes.getPosition();
        if (l4 != l3) {
            assert (l4 > l3);
            this.lastFrozenNode = l2;
        }
        a2.clear();
        a2 = new CompiledNode();
        new CompiledNode().node = l2;
        return a2;
    }

    private void freezeTail(int n2) throws IOException {
        int n3 = Math.max(1, n2);
        for (int i2 = this.lastInput.length(); i2 >= n3; --i2) {
            boolean bl;
            boolean bl2;
            boolean bl3 = false;
            UnCompiledNode<T> unCompiledNode = this.frontier[i2];
            UnCompiledNode unCompiledNode2 = this.frontier[i2 - 1];
            if (unCompiledNode.inputCount < (long)this.minSuffixCount1) {
                bl3 = true;
                bl2 = true;
            } else if (i2 > n2) {
                bl3 = unCompiledNode2.inputCount < (long)this.minSuffixCount2 || this.minSuffixCount2 == 1 && unCompiledNode2.inputCount == 1L && i2 > 1;
                bl2 = true;
            } else {
                bl2 = bl = this.minSuffixCount2 == 0;
            }
            if (unCompiledNode.inputCount < (long)this.minSuffixCount2 || this.minSuffixCount2 == 1 && unCompiledNode.inputCount == 1L && i2 > 1) {
                for (int i3 = 0; i3 < unCompiledNode.numArcs; ++i3) {
                    ((UnCompiledNode)unCompiledNode.arcs[i3].target).clear();
                }
                unCompiledNode.numArcs = 0;
            }
            if (bl3) {
                unCompiledNode.clear();
                unCompiledNode2.deleteLast(this.lastInput.intAt(i2 - 1), unCompiledNode);
                continue;
            }
            if (this.minSuffixCount2 != 0) {
                this.compileAllTargets(unCompiledNode, this.lastInput.length() - i2);
            }
            Object t2 = unCompiledNode.output;
            boolean bl4 = bl3 = unCompiledNode.isFinal || unCompiledNode.numArcs == 0;
            if (bl) {
                unCompiledNode2.replaceLast(this.lastInput.intAt(i2 - 1), this.compileNode(unCompiledNode, 1 + this.lastInput.length() - i2), t2, bl3);
                continue;
            }
            unCompiledNode2.replaceLast(this.lastInput.intAt(i2 - 1), unCompiledNode, t2, bl3);
            this.frontier[i2] = new UnCompiledNode(this, i2);
        }
    }

    public void add(IntsRef intsRef, T t2) throws IOException {
        if (t2.equals(this.NO_OUTPUT)) {
            t2 = this.NO_OUTPUT;
        }
        assert (this.lastInput.length() == 0 || intsRef.compareTo(this.lastInput.get()) >= 0) : "inputs are added out of order lastInput=" + this.lastInput.get() + " vs input=" + intsRef;
        assert (this.validOutput(t2));
        if (intsRef.length == 0) {
            ++this.frontier[0].inputCount;
            this.frontier[0].isFinal = true;
            this.fst.setEmptyOutput(t2);
            return;
        }
        int n2 = 0;
        int n3 = intsRef.offset;
        int n4 = Math.min(this.lastInput.length(), intsRef.length);
        while (true) {
            ++this.frontier[n2].inputCount;
            if (n2 >= n4 || this.lastInput.intAt(n2) != intsRef.ints[n3]) break;
            ++n2;
            ++n3;
        }
        ++n2;
        if (this.frontier.length < intsRef.length + 1) {
            UnCompiledNode[] unCompiledNodeArray = new UnCompiledNode[ArrayUtil.oversize(intsRef.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.frontier, 0, unCompiledNodeArray, 0, this.frontier.length);
            for (n4 = this.frontier.length; n4 < unCompiledNodeArray.length; ++n4) {
                unCompiledNodeArray[n4] = new UnCompiledNode(this, n4);
            }
            this.frontier = unCompiledNodeArray;
        }
        this.freezeTail(n2);
        for (n3 = n2; n3 <= intsRef.length; ++n3) {
            this.frontier[n3 - 1].addArc(intsRef.ints[intsRef.offset + n3 - 1], this.frontier[n3]);
            ++this.frontier[n3].inputCount;
        }
        UnCompiledNode<T> unCompiledNode = this.frontier[intsRef.length];
        if (this.lastInput.length() != intsRef.length || n2 != intsRef.length + 1) {
            unCompiledNode.isFinal = true;
            unCompiledNode.output = this.NO_OUTPUT;
        }
        for (n4 = 1; n4 < n2; ++n4) {
            T t3;
            UnCompiledNode<T> unCompiledNode2 = this.frontier[n4];
            UnCompiledNode<T> unCompiledNode3 = this.frontier[n4 - 1];
            T t4 = unCompiledNode3.getLastOutput(intsRef.ints[intsRef.offset + n4 - 1]);
            assert (this.validOutput(t4));
            if (t4 != this.NO_OUTPUT) {
                t3 = this.fst.outputs.common(t2, t4);
                assert (this.validOutput(t3));
                t4 = this.fst.outputs.subtract(t4, t3);
                assert (this.validOutput(t4));
                unCompiledNode3.setLastOutput(intsRef.ints[intsRef.offset + n4 - 1], t3);
                unCompiledNode2.prependOutput(t4);
            } else {
                t3 = this.NO_OUTPUT;
            }
            t2 = this.fst.outputs.subtract(t2, t3);
            assert (this.validOutput(t2));
        }
        if (this.lastInput.length() == intsRef.length && n2 == 1 + intsRef.length) {
            unCompiledNode.output = this.fst.outputs.merge(unCompiledNode.output, t2);
        } else {
            this.frontier[n2 - 1].setLastOutput(intsRef.ints[intsRef.offset + n2 - 1], t2);
        }
        this.lastInput.copyInts(intsRef);
    }

    private boolean validOutput(T t2) {
        return t2 == this.NO_OUTPUT || !t2.equals(this.NO_OUTPUT);
    }

    public FST<T> finish() throws IOException {
        UnCompiledNode<T> unCompiledNode = this.frontier[0];
        this.freezeTail(0);
        if (unCompiledNode.inputCount < (long)this.minSuffixCount1 || unCompiledNode.inputCount < (long)this.minSuffixCount2 || unCompiledNode.numArcs == 0) {
            if (this.fst.emptyOutput == null) {
                return null;
            }
            if (this.minSuffixCount1 > 0 || this.minSuffixCount2 > 0) {
                return null;
            }
        } else if (this.minSuffixCount2 != 0) {
            this.compileAllTargets(unCompiledNode, this.lastInput.length());
        }
        this.fst.finish(this.compileNode(unCompiledNode, (int)this.lastInput.length()).node);
        if (this.doPackFST) {
            return this.fst.pack(this, 3, Math.max(10, (int)(this.getNodeCount() / 4L)), this.acceptableOverheadRatio);
        }
        return this.fst;
    }

    private void compileAllTargets(UnCompiledNode<T> unCompiledNode, int n2) throws IOException {
        for (int i2 = 0; i2 < unCompiledNode.numArcs; ++i2) {
            Arc arc = unCompiledNode.arcs[i2];
            if (arc.target.isCompiled()) continue;
            UnCompiledNode unCompiledNode2 = (UnCompiledNode)arc.target;
            if (unCompiledNode2.numArcs == 0) {
                unCompiledNode2.isFinal = true;
                arc.isFinal = true;
            }
            arc.target = this.compileNode(unCompiledNode2, n2 - 1);
        }
    }

    public static final class UnCompiledNode<T>
    implements a {
        @Weak
        final Builder<T> owner;
        public int numArcs;
        public Arc<T>[] arcs;
        public T output;
        public boolean isFinal;
        public long inputCount;
        public final int depth;

        public UnCompiledNode(Builder<T> builder, int n2) {
            this.owner = builder;
            this.arcs = new Arc[1];
            this.arcs[0] = new Arc();
            this.output = ((Builder)builder).NO_OUTPUT;
            this.depth = n2;
        }

        @Override
        public final boolean isCompiled() {
            return false;
        }

        public final void clear() {
            this.numArcs = 0;
            this.isFinal = false;
            this.output = ((Builder)this.owner).NO_OUTPUT;
            this.inputCount = 0L;
        }

        public final T getLastOutput(int n2) {
            assert (this.numArcs > 0);
            assert (this.arcs[this.numArcs - 1].label == n2);
            return this.arcs[this.numArcs - 1].output;
        }

        public final void addArc(int n2, a a2) {
            Object object;
            assert (n2 >= 0);
            assert (this.numArcs == 0 || n2 > this.arcs[this.numArcs - 1].label) : "arc[-1].label=" + this.arcs[this.numArcs - 1].label + " new label=" + n2 + " numArcs=" + this.numArcs;
            if (this.numArcs == this.arcs.length) {
                object = new Arc[ArrayUtil.oversize(this.numArcs + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.arcs, 0, object, 0, this.arcs.length);
                for (int i2 = this.numArcs; i2 < ((Arc[])object).length; ++i2) {
                    object[i2] = new Arc();
                }
                this.arcs = object;
            }
            object = this.arcs[this.numArcs++];
            this.arcs[this.numArcs++].label = n2;
            object.target = a2;
            object.nextFinalOutput = ((Builder)this.owner).NO_OUTPUT;
            object.output = object.nextFinalOutput;
            object.isFinal = false;
        }

        public final void replaceLast(int n2, a a2, T t2, boolean bl) {
            assert (this.numArcs > 0);
            Arc<T> arc = this.arcs[this.numArcs - 1];
            assert (arc.label == n2) : "arc.label=" + arc.label + " vs " + n2;
            arc.target = a2;
            arc.nextFinalOutput = t2;
            arc.isFinal = bl;
        }

        public final void deleteLast(int n2, a a2) {
            assert (this.numArcs > 0);
            assert (n2 == this.arcs[this.numArcs - 1].label);
            assert (a2 == this.arcs[this.numArcs - 1].target);
            --this.numArcs;
        }

        public final void setLastOutput(int n2, T t2) {
            assert (((Builder)this.owner).validOutput(t2));
            assert (this.numArcs > 0);
            Arc<T> arc = this.arcs[this.numArcs - 1];
            assert (arc.label == n2);
            arc.output = t2;
        }

        public final void prependOutput(T t2) {
            assert (((Builder)this.owner).validOutput(t2));
            for (int i2 = 0; i2 < this.numArcs; ++i2) {
                this.arcs[i2].output = this.owner.fst.outputs.add(t2, this.arcs[i2].output);
                assert (((Builder)this.owner).validOutput(this.arcs[i2].output));
            }
            if (this.isFinal) {
                this.output = this.owner.fst.outputs.add(t2, this.output);
                assert (((Builder)this.owner).validOutput(this.output));
            }
        }
    }

    static final class CompiledNode
    implements a {
        long node;

        CompiledNode() {
        }

        @Override
        public final boolean isCompiled() {
            return true;
        }
    }

    static interface a {
        public boolean isCompiled();
    }

    public static class Arc<T> {
        public int label;
        @Weak
        public a target;
        public boolean isFinal;
        public T output;
        public T nextFinalOutput;
    }
}

