/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Transition;

public final class UTF32ToUTF8 {
    private static final int[] startCodes = new int[]{0, 128, 2048, 65536};
    private static final int[] endCodes = new int[]{127, 2047, 65535, 0x10FFFF};
    static int[] MASKS = new int[32];
    private final UTF8Sequence startUTF8 = new UTF8Sequence();
    private final UTF8Sequence endUTF8 = new UTF8Sequence();
    private final UTF8Sequence tmpUTF8a = new UTF8Sequence();
    private final UTF8Sequence tmpUTF8b = new UTF8Sequence();
    Automaton.Builder utf8;

    final void convertOneEdge(int n2, int n3, int n4, int n5) {
        this.startUTF8.set(n4);
        this.endUTF8.set(n5);
        this.build(n2, n3, this.startUTF8, this.endUTF8, 0);
    }

    private void build(int n2, int n3, UTF8Sequence uTF8Sequence, UTF8Sequence uTF8Sequence2, int n4) {
        int n5;
        while (uTF8Sequence.byteAt(n4) == uTF8Sequence2.byteAt(n4)) {
            if (n4 == uTF8Sequence.len - 1 && n4 == uTF8Sequence2.len - 1) {
                this.utf8.addTransition(n2, n3, uTF8Sequence.byteAt(n4), uTF8Sequence2.byteAt(n4));
                return;
            }
            assert (uTF8Sequence.len > n4 + 1);
            assert (uTF8Sequence2.len > n4 + 1);
            n5 = this.utf8.createState();
            this.utf8.addTransition(n2, n5, uTF8Sequence.byteAt(n4));
            ++n4;
            n2 = n5;
        }
        if (uTF8Sequence.len == uTF8Sequence2.len) {
            if (n4 == uTF8Sequence.len - 1) {
                this.utf8.addTransition(n2, n3, uTF8Sequence.byteAt(n4), uTF8Sequence2.byteAt(n4));
                return;
            }
            this.start(n2, n3, uTF8Sequence, n4, false);
            if (uTF8Sequence2.byteAt(n4) - uTF8Sequence.byteAt(n4) > 1) {
                this.all(n2, n3, uTF8Sequence.byteAt(n4) + 1, uTF8Sequence2.byteAt(n4) - 1, uTF8Sequence.len - n4 - 1);
            }
            this.end(n2, n3, uTF8Sequence2, n4, false);
            return;
        }
        this.start(n2, n3, uTF8Sequence, n4, true);
        int n6 = uTF8Sequence2.len - n4;
        for (n5 = 1 + uTF8Sequence.len - n4; n5 < n6; ++n5) {
            this.tmpUTF8a.set(UTF32ToUTF8.startCodes[n5 - 1]);
            this.tmpUTF8b.set(UTF32ToUTF8.endCodes[n5 - 1]);
            this.all(n2, n3, this.tmpUTF8a.byteAt(0), this.tmpUTF8b.byteAt(0), this.tmpUTF8a.len - 1);
        }
        this.end(n2, n3, uTF8Sequence2, n4, true);
    }

    private void start(int n2, int n3, UTF8Sequence uTF8Sequence, int n4, boolean bl) {
        if (n4 == uTF8Sequence.len - 1) {
            this.utf8.addTransition(n2, n3, uTF8Sequence.byteAt(n4), uTF8Sequence.byteAt(n4) | MASKS[uTF8Sequence.numBits(n4) - 1]);
            return;
        }
        int n5 = this.utf8.createState();
        this.utf8.addTransition(n2, n5, uTF8Sequence.byteAt(n4));
        this.start(n5, n3, uTF8Sequence, n4 + 1, true);
        n5 = uTF8Sequence.byteAt(n4) | MASKS[uTF8Sequence.numBits(n4) - 1];
        if (bl && uTF8Sequence.byteAt(n4) != n5) {
            this.all(n2, n3, uTF8Sequence.byteAt(n4) + 1, n5, uTF8Sequence.len - n4 - 1);
        }
    }

    private void end(int n2, int n3, UTF8Sequence uTF8Sequence, int n4, boolean bl) {
        while (true) {
            int n5;
            if (n4 == uTF8Sequence.len - 1) {
                this.utf8.addTransition(n2, n3, uTF8Sequence.byteAt(n4) & ~MASKS[uTF8Sequence.numBits(n4) - 1], uTF8Sequence.byteAt(n4));
                return;
            }
            int n6 = uTF8Sequence.numBits(n4) == 5 ? 194 : uTF8Sequence.byteAt(n4) & ~MASKS[uTF8Sequence.numBits(n4) - 1];
            if (n5 != 0 && uTF8Sequence.byteAt(n4) != n6) {
                this.all(n2, n3, n6, uTF8Sequence.byteAt(n4) - 1, uTF8Sequence.len - n4 - 1);
            }
            n5 = this.utf8.createState();
            this.utf8.addTransition(n2, n5, uTF8Sequence.byteAt(n4));
            int n7 = n5;
            n5 = 1;
            ++n4;
            n2 = n7;
        }
    }

    private void all(int n2, int n3, int n4, int n5, int n6) {
        if (n6 == 0) {
            this.utf8.addTransition(n2, n3, n4, n5);
            return;
        }
        int n7 = this.utf8.createState();
        this.utf8.addTransition(n2, n7, n4, n5);
        while (n6 > 1) {
            n2 = this.utf8.createState();
            this.utf8.addTransition(n7, n2, 128, 191);
            --n6;
            n7 = n2;
        }
        this.utf8.addTransition(n7, n3, 128, 191);
    }

    public final Automaton convert(Automaton automaton) {
        if (automaton.getNumStates() == 0) {
            return automaton;
        }
        int[] nArray = new int[automaton.getNumStates()];
        Arrays.fill(nArray, -1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        this.utf8 = new Automaton.Builder();
        int n2 = this.utf8.createState();
        this.utf8.setAccept(n2, automaton.isAccept(0));
        nArray[0] = n2;
        Transition transition = new Transition();
        while (arrayList.size() != 0) {
            int n3 = (Integer)arrayList.remove(arrayList.size() - 1);
            n2 = nArray[n3];
            assert (n2 != -1);
            int n4 = automaton.getNumTransitions(n3);
            automaton.initTransition(n3, transition);
            for (n3 = 0; n3 < n4; ++n3) {
                automaton.getNextTransition(transition);
                int n5 = transition.dest;
                int n6 = nArray[n5];
                if (n6 == -1) {
                    n6 = this.utf8.createState();
                    this.utf8.setAccept(n6, automaton.isAccept(n5));
                    nArray[n5] = n6;
                    arrayList.add(n5);
                }
                this.convertOneEdge(n2, n6, transition.min, transition.max);
            }
        }
        return this.utf8.finish();
    }

    static {
        int n2 = 2;
        for (int i2 = 0; i2 < 32; ++i2) {
            UTF32ToUTF8.MASKS[i2] = n2 - 1;
            n2 <<= 1;
        }
    }

    private static class UTF8Sequence {
        private final UTF8Byte[] bytes = new UTF8Byte[4];
        private int len;

        public UTF8Sequence() {
            for (int i2 = 0; i2 < 4; ++i2) {
                this.bytes[i2] = new UTF8Byte();
            }
        }

        public int byteAt(int n2) {
            return this.bytes[n2].value;
        }

        public int numBits(int n2) {
            return this.bytes[n2].bits;
        }

        private void set(int n2) {
            if (n2 < 128) {
                this.bytes[0].value = n2;
                this.bytes[0].bits = (byte)7;
                this.len = 1;
                return;
            }
            if (n2 < 2048) {
                this.bytes[0].value = 0xC0 | n2 >> 6;
                this.bytes[0].bits = (byte)5;
                this.setRest(n2, 1);
                this.len = 2;
                return;
            }
            if (n2 < 65536) {
                this.bytes[0].value = 0xE0 | n2 >> 12;
                this.bytes[0].bits = (byte)4;
                this.setRest(n2, 2);
                this.len = 3;
                return;
            }
            this.bytes[0].value = 0xF0 | n2 >> 18;
            this.bytes[0].bits = (byte)3;
            this.setRest(n2, 3);
            this.len = 4;
        }

        private void setRest(int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.bytes[n3 - i2].value = 0x80 | n2 & MASKS[5];
                this.bytes[n3 - i2].bits = (byte)6;
                n2 >>= 6;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < this.len; ++i2) {
                if (i2 > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(Integer.toBinaryString(this.bytes[i2].value));
            }
            return stringBuilder.toString();
        }
    }

    private static class UTF8Byte {
        int value;
        byte bits;

        private UTF8Byte() {
        }
    }
}

