/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Arrays;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;

public abstract class RunAutomaton {
    final Automaton automaton;
    final int maxInterval;
    final int size;
    final boolean[] accept;
    final int initial;
    final int[] transitions;
    final int[] points;
    final int[] classmap;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("initial state: ").append(this.initial).append("\n");
        for (int i2 = 0; i2 < this.size; ++i2) {
            stringBuilder.append("state " + i2);
            if (this.accept[i2]) {
                stringBuilder.append(" [accept]:\n");
            } else {
                stringBuilder.append(" [reject]:\n");
            }
            for (int i3 = 0; i3 < this.points.length; ++i3) {
                int n2 = this.transitions[i2 * this.points.length + i3];
                if (n2 == -1) continue;
                int n3 = this.points[i3];
                int n4 = i3 + 1 < this.points.length ? this.points[i3 + 1] - 1 : this.maxInterval;
                stringBuilder.append(" ");
                Automaton.appendCharString(n3, stringBuilder);
                if (n3 != n4) {
                    stringBuilder.append("-");
                    Automaton.appendCharString(n4, stringBuilder);
                }
                stringBuilder.append(" -> ").append(n2).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isAccept(int n2) {
        return this.accept[n2];
    }

    public final int getInitialState() {
        return this.initial;
    }

    final int getCharClass(int n2) {
        return Operations.findIndex(n2, this.points);
    }

    public RunAutomaton(Automaton automaton, int n2, boolean bl, int n3) {
        int n4;
        this.maxInterval = n2;
        this.automaton = automaton = Operations.determinize(automaton, n3);
        this.points = automaton.getStartPoints();
        this.initial = 0;
        this.size = Math.max(1, automaton.getNumStates());
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        Arrays.fill(this.transitions, -1);
        for (n3 = 0; n3 < this.size; ++n3) {
            this.accept[n3] = automaton.isAccept(n3);
            for (n4 = 0; n4 < this.points.length; ++n4) {
                int n5 = automaton.step(n3, this.points[n4]);
                assert (n5 == -1 || n5 < this.size);
                this.transitions[n3 * this.points.length + n4] = n5;
            }
        }
        if (bl) {
            this.classmap = new int[n2 + 1];
            n3 = 0;
            for (n4 = 0; n4 <= n2; ++n4) {
                if (n3 + 1 >= this.points.length || n4 == this.points[n3 + 1]) {
                    // empty if block
                }
                this.classmap[n4] = ++n3;
            }
            return;
        }
        this.classmap = null;
    }

    public final int step(int n2, int n3) {
        if (this.classmap == null) {
            return this.transitions[n2 * this.points.length + this.getCharClass(n3)];
        }
        return this.transitions[n2 * this.points.length + this.classmap[n3]];
    }

    public int hashCode() {
        return (((31 + this.initial) * 31 + this.maxInterval) * 31 + this.points.length) * 31 + this.size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (RunAutomaton)object;
        if (this.initial != ((RunAutomaton)object).initial) {
            return false;
        }
        if (this.maxInterval != ((RunAutomaton)object).maxInterval) {
            return false;
        }
        if (this.size != ((RunAutomaton)object).size) {
            return false;
        }
        if (!Arrays.equals(this.points, ((RunAutomaton)object).points)) {
            return false;
        }
        if (!Arrays.equals(this.accept, ((RunAutomaton)object).accept)) {
            return false;
        }
        return Arrays.equals(this.transitions, ((RunAutomaton)object).transitions);
    }
}

