/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

public class RegExp {
    Kind kind;
    RegExp exp1;
    RegExp exp2;
    String s;
    int c;
    int min;
    int max;
    int digits;
    int from;
    int to;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toStringBuilder(stringBuilder);
        return stringBuilder.toString();
    }

    void toStringBuilder(StringBuilder stringBuilder) {
        switch (this.kind) {
            case REGEXP_UNION: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("|");
                this.exp2.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                return;
            }
            case REGEXP_CONCATENATION: {
                this.exp1.toStringBuilder(stringBuilder);
                this.exp2.toStringBuilder(stringBuilder);
                return;
            }
            case REGEXP_INTERSECTION: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("&");
                this.exp2.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                return;
            }
            case REGEXP_OPTIONAL: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")?");
                return;
            }
            case REGEXP_REPEAT: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")*");
                return;
            }
            case REGEXP_REPEAT_MIN: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("){").append(this.min).append(",}");
                return;
            }
            case REGEXP_REPEAT_MINMAX: {
                stringBuilder.append("(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append("){").append(this.min).append(",").append(this.max).append("}");
                return;
            }
            case REGEXP_COMPLEMENT: {
                stringBuilder.append("~(");
                this.exp1.toStringBuilder(stringBuilder);
                stringBuilder.append(")");
                return;
            }
            case REGEXP_CHAR: {
                stringBuilder.append("\\").appendCodePoint(this.c);
                return;
            }
            case REGEXP_CHAR_RANGE: {
                stringBuilder.append("[\\").appendCodePoint(this.from).append("-\\").appendCodePoint(this.to).append("]");
                return;
            }
            case REGEXP_ANYCHAR: {
                stringBuilder.append(".");
                return;
            }
            case REGEXP_EMPTY: {
                stringBuilder.append("#");
                return;
            }
            case REGEXP_STRING: {
                stringBuilder.append("\"").append(this.s).append("\"");
                return;
            }
            case REGEXP_ANYSTRING: {
                stringBuilder.append("@");
                return;
            }
            case REGEXP_AUTOMATON: {
                stringBuilder.append("<").append(this.s).append(">");
                return;
            }
            case REGEXP_INTERVAL: {
                int n2;
                String string = Integer.toString(this.min);
                String string2 = Integer.toString(this.max);
                stringBuilder.append("<");
                if (this.digits > 0) {
                    for (n2 = string.length(); n2 < this.digits; ++n2) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string).append("-");
                if (this.digits > 0) {
                    for (n2 = string2.length(); n2 < this.digits; ++n2) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string2).append(">");
            }
        }
    }

    static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL;

    }
}

