/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.io.IOException;
import org.apache.lucene.index.SingleTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.automaton.UTF32ToUTF8;
import org.apache.lucene.util.automaton.a;

public class CompiledAutomaton {
    public final AUTOMATON_TYPE type;
    public final BytesRef term;
    public final a runAutomaton;
    public final Automaton automaton;
    public final BytesRef commonSuffixRef;
    public final Boolean finite;
    public final int sinkState;
    private Transition transition = new Transition();

    private static int findSinkState(Automaton automaton) {
        int n2 = automaton.getNumStates();
        Transition transition = new Transition();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!automaton.isAccept(i2)) continue;
            int n4 = automaton.initTransition(i2, transition);
            boolean bl = false;
            for (int i3 = 0; i3 < n4; ++i3) {
                automaton.getNextTransition(transition);
                if (transition.dest != i2 || transition.min != 0 || transition.max != 255) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    public CompiledAutomaton(Automaton automaton, Boolean bl, boolean bl2, int n2, boolean bl3) {
        Comparable<IntsRef> comparable;
        if (automaton.getNumStates() == 0) {
            automaton = new Automaton();
            automaton.createState();
        }
        if (bl2) {
            if (Operations.isEmpty(automaton)) {
                this.type = AUTOMATON_TYPE.NONE;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.sinkState = -1;
                return;
            }
            bl2 = bl3 ? Operations.isTotal(automaton, 0, 255) : Operations.isTotal(automaton);
            if (bl2) {
                this.type = AUTOMATON_TYPE.ALL;
                this.term = null;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.sinkState = -1;
                return;
            }
            comparable = Operations.getSingleton(automaton = Operations.determinize(automaton, n2));
            if (comparable != null) {
                this.type = AUTOMATON_TYPE.SINGLE;
                this.commonSuffixRef = null;
                this.runAutomaton = null;
                this.automaton = null;
                this.finite = null;
                this.term = bl3 ? StringHelper.intsRefToBytesRef(comparable) : new BytesRef(UnicodeUtil.newString(comparable.ints, comparable.offset, comparable.length));
                this.sinkState = -1;
                return;
            }
        }
        this.type = AUTOMATON_TYPE.NORMAL;
        this.term = null;
        this.finite = bl == null ? Boolean.valueOf(Operations.isFinite(automaton)) : bl;
        Automaton automaton2 = bl3 ? automaton : new UTF32ToUTF8().convert(automaton);
        if (this.finite.booleanValue()) {
            this.commonSuffixRef = null;
        } else {
            comparable = Operations.getCommonSuffixBytesRef(automaton2, n2);
            this.commonSuffixRef = ((BytesRef)comparable).length == 0 ? null : comparable;
        }
        this.runAutomaton = new a(automaton2, n2);
        this.automaton = this.runAutomaton.automaton;
        this.sinkState = CompiledAutomaton.findSinkState(this.automaton);
    }

    public TermsEnum getTermsEnum(Terms terms) throws IOException {
        switch (this.type) {
            case NONE: {
                return TermsEnum.EMPTY;
            }
            case ALL: {
                return terms.iterator();
            }
            case SINGLE: {
                return new SingleTermsEnum(terms.iterator(), this.term);
            }
            case NORMAL: {
                return terms.intersect(this, null);
            }
        }
        throw new RuntimeException("unhandled case");
    }

    public int hashCode() {
        return ((31 + (this.runAutomaton == null ? 0 : this.runAutomaton.hashCode())) * 31 + (this.term == null ? 0 : this.term.hashCode())) * 31 + (this.type == null ? 0 : this.type.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (CompiledAutomaton)object;
        if (this.type != ((CompiledAutomaton)object).type) {
            return false;
        }
        return !(this.type == AUTOMATON_TYPE.SINGLE ? !this.term.equals(((CompiledAutomaton)object).term) : this.type == AUTOMATON_TYPE.NORMAL && !this.runAutomaton.equals(((CompiledAutomaton)object).runAutomaton));
    }

    public static enum AUTOMATON_TYPE {
        NONE,
        ALL,
        SINGLE,
        NORMAL;

    }
}

