/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public final class WeakIdentityMap<K, V> {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final Map<IdentityWeakReference, V> backingStore;
    private final boolean reapOnRead;
    static final Object NULL = new Object();

    public static <K, V> WeakIdentityMap<K, V> newConcurrentHashMap() {
        return WeakIdentityMap.newConcurrentHashMap(true);
    }

    public static <K, V> WeakIdentityMap<K, V> newConcurrentHashMap(boolean bl) {
        return new WeakIdentityMap(new ConcurrentHashMap(), bl);
    }

    private WeakIdentityMap(Map<IdentityWeakReference, V> map, boolean bl) {
        this.backingStore = map;
        this.reapOnRead = bl;
    }

    public final void clear() {
        this.backingStore.clear();
        this.reap();
    }

    public final V put(K k2, V v2) {
        this.reap();
        return this.backingStore.put(new IdentityWeakReference(k2, this.queue), v2);
    }

    public final V remove(Object object) {
        this.reap();
        return this.backingStore.remove(new IdentityWeakReference(object, null));
    }

    public final Iterator<K> keyIterator() {
        this.reap();
        final Iterator<IdentityWeakReference> iterator = this.backingStore.keySet().iterator();
        return new Iterator<K>(){
            private Object next = null;
            private boolean nextIsSet = false;

            @Override
            public boolean hasNext() {
                return this.nextIsSet || this.setNext();
            }

            @Override
            public K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                assert (this.nextIsSet);
                try {
                    Object object = this.next;
                    return object;
                }
                finally {
                    this.nextIsSet = false;
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean setNext() {
                assert (!this.nextIsSet);
                while (iterator.hasNext()) {
                    this.next = ((IdentityWeakReference)iterator.next()).get();
                    if (this.next == null) {
                        iterator.remove();
                        continue;
                    }
                    if (this.next == NULL) {
                        this.next = null;
                    }
                    this.nextIsSet = true;
                    return true;
                }
                return false;
            }
        };
    }

    public final void reap() {
        Reference<Object> reference;
        while ((reference = this.queue.poll()) != null) {
            this.backingStore.remove(reference);
        }
    }

    private static final class IdentityWeakReference
    extends WeakReference<Object> {
        private final int hash;

        IdentityWeakReference(Object object, ReferenceQueue<Object> referenceQueue) {
            super(object == null ? NULL : object, referenceQueue);
            this.hash = System.identityHashCode(object);
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof IdentityWeakReference) {
                object = (IdentityWeakReference)object;
                if (this.get() == ((Reference)object).get()) {
                    return true;
                }
            }
            return false;
        }
    }
}

