/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.BytesRef;

public final class UnicodeUtil {
    public static final BytesRef BIG_TERM = new BytesRef(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    static final int[] utf8CodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4};

    private UnicodeUtil() {
    }

    public static int UTF16toUTF8(char[] cArray, int n2, int n3, byte[] byArray) {
        int n4 = 0;
        int n5 = n2;
        n2 += n3;
        while (n5 < n2) {
            int n6;
            if ((n3 = cArray[n5++]) < 128) {
                byArray[n4++] = (byte)n3;
                continue;
            }
            if (n3 < 2048) {
                byArray[n4++] = (byte)(0xC0 | n3 >> 6);
                byArray[n4++] = (byte)(0x80 | n3 & 0x3F);
                continue;
            }
            if (n3 < 55296 || n3 > 57343) {
                byArray[n4++] = (byte)(0xE0 | n3 >> 12);
                byArray[n4++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n3 & 0x3F);
                continue;
            }
            if (n3 < 56320 && n5 < n2 && (n6 = cArray[n5]) >= 56320 && n6 <= 57343) {
                n6 = (n3 << 10) + n6 + -56613888;
                ++n5;
                byArray[n4++] = (byte)(0xF0 | n6 >> 18);
                byArray[n4++] = (byte)(0x80 | n6 >> 12 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n6 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            byArray[n4++] = -17;
            byArray[n4++] = -65;
            byArray[n4++] = -67;
        }
        return n4;
    }

    public static int UTF16toUTF8(CharSequence charSequence, int n2, int n3, byte[] byArray) {
        n3 = n2 + n3;
        int n4 = 0;
        while (n2 < n3) {
            int n5;
            char c2 = charSequence.charAt(n2);
            if (c2 < '\u0080') {
                byArray[n4++] = (byte)c2;
            } else if (c2 < '\u0800') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
            } else if (c2 < '\ud800' || c2 > '\udfff') {
                byArray[n4++] = (byte)(0xE0 | c2 >> 12);
                byArray[n4++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
            } else if (c2 < '\udc00' && n2 < n3 - 1 && (n5 = charSequence.charAt(n2 + 1)) >= 56320 && n5 <= 57343) {
                n5 = (c2 << 10) + n5 + -56613888;
                ++n2;
                byArray[n4++] = (byte)(0xF0 | n5 >> 18);
                byArray[n4++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | n5 & 0x3F);
            } else {
                byArray[n4++] = -17;
                byArray[n4++] = -65;
                byArray[n4++] = -67;
            }
            ++n2;
        }
        return n4;
    }

    public static String newString(int[] nArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n3];
        int n4 = 0;
        n3 = n2 + n3;
        block2: for (int i2 = n2; i2 < n3; ++i2) {
            int n5 = nArray[i2];
            if (n5 < 0 || n5 > 0x10FFFF) {
                throw new IllegalArgumentException();
            }
            while (true) {
                try {
                    if (n5 < 65536) {
                        cArray[n4] = (char)n5;
                        ++n4;
                        continue block2;
                    }
                    cArray[n4] = (char)(55232 + (n5 >> 10));
                    cArray[n4 + 1] = (char)(56320 + (n5 & 0x3FF));
                    n4 += 2;
                    continue block2;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    char[] cArray2 = new char[(int)Math.ceil((double)nArray.length * (double)(n4 + 2) / (double)(i2 - n2 + 1))];
                    System.arraycopy(cArray, 0, cArray2, 0, n4);
                    cArray = cArray2;
                    continue;
                }
                break;
            }
        }
        return new String(cArray, 0, n4);
    }

    public static int UTF8toUTF16(byte[] byArray, int n2, int n3, char[] cArray) {
        int n4 = 0;
        n3 = n2 + n3;
        while (n2 < n3) {
            int n5;
            if ((n5 = byArray[n2++] & 0xFF) < 192) {
                assert (n5 < 128);
                cArray[n4++] = (char)n5;
                continue;
            }
            if (n5 < 224) {
                cArray[n4++] = (char)(((n5 & 0x1F) << 6) + (byArray[n2++] & 0x3F));
                continue;
            }
            if (n5 < 240) {
                cArray[n4++] = (char)(((n5 & 0xF) << 12) + ((byArray[n2] & 0x3F) << 6) + (byArray[n2 + 1] & 0x3F));
                n2 += 2;
                continue;
            }
            assert (n5 < 248) : "b = 0x" + Integer.toHexString(n5);
            n5 = ((n5 & 7) << 18) + ((byArray[n2] & 0x3F) << 12) + ((byArray[n2 + 1] & 0x3F) << 6) + (byArray[n2 + 2] & 0x3F);
            n2 += 3;
            if ((long)n5 < 65535L) {
                cArray[n4++] = (char)n5;
                continue;
            }
            cArray[n4++] = (char)(((n5 -= 65536) >> 10) + 55296);
            cArray[n4++] = (char)(((long)n5 & 0x3FFL) + 56320L);
        }
        return n4;
    }
}

