/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.Sorter;

public abstract class TimSorter
extends Sorter {
    final int maxTempSlots;
    int minRun;
    int to;
    int stackSize;
    int[] runEnds = new int[50];

    protected TimSorter(int n2) {
        this.maxTempSlots = n2;
    }

    static int minRun(int n2) {
        assert (n2 >= 32);
        int n3 = 0;
        while (n2 >= 64) {
            n3 |= n2 & 1;
            n2 >>>= 1;
        }
        assert ((n2 += n3) >= 32 && n2 <= 64);
        return n2;
    }

    int runLen(int n2) {
        n2 = this.stackSize - n2;
        return this.runEnds[n2] - this.runEnds[n2 - 1];
    }

    int runBase(int n2) {
        return this.runEnds[this.stackSize - n2 - 1];
    }

    int runEnd(int n2) {
        return this.runEnds[this.stackSize - n2];
    }

    void setRunEnd(int n2, int n3) {
        this.runEnds[this.stackSize - n2] = n3;
    }

    void pushRunLen(int n2) {
        this.runEnds[this.stackSize + 1] = this.runEnds[this.stackSize] + n2;
        ++this.stackSize;
    }

    int nextRun() {
        int n2;
        int n3 = this.runEnd(0);
        assert (n3 < this.to);
        if (n3 == this.to - 1) {
            return 1;
        }
        if (this.compare(n3, n3 + 1) > 0) {
            for (n2 = n3 + 2; n2 < this.to && this.compare(n2 - 1, n2) > 0; ++n2) {
            }
            this.reverse(n3, n2);
        } else {
            while (n2 < this.to && this.compare(n2 - 1, n2) <= 0) {
                ++n2;
            }
        }
        int n4 = Math.max(n2, Math.min(this.to, n3 + this.minRun));
        this.binarySort(n3, n4, n2);
        return n4 - n3;
    }

    void ensureInvariants() {
        while (this.stackSize > 1) {
            int n2;
            int n3 = this.runLen(0);
            int n4 = this.runLen(1);
            if (this.stackSize > 2 && (n2 = this.runLen(2)) <= n4 + n3) {
                if (n2 < n3) {
                    this.mergeAt(1);
                    continue;
                }
                this.mergeAt(0);
                continue;
            }
            if (n4 > n3) break;
            this.mergeAt(0);
        }
    }

    void exhaustStack() {
        while (this.stackSize > 1) {
            this.mergeAt(0);
        }
    }

    void reset(int n2, int n3) {
        this.stackSize = 0;
        Arrays.fill(this.runEnds, 0);
        this.runEnds[0] = n2;
        this.to = n3;
        n2 = n3 - n2;
        this.minRun = n2 <= 64 ? n2 : TimSorter.minRun(n2);
    }

    void mergeAt(int n2) {
        assert (this.stackSize >= 2);
        this.merge(this.runBase(n2 + 1), this.runBase(n2), this.runEnd(n2));
        ++n2;
        while (n2 > 0) {
            this.setRunEnd(n2, this.runEnd(n2 - 1));
            --n2;
        }
        --this.stackSize;
    }

    void merge(int n2, int n3, int n4) {
        if (this.compare(n3 - 1, n3) <= 0) {
            return;
        }
        n2 = this.upper2(n2, n3, n3);
        if ((n4 = this.lower2(n3, n4, n3 - 1)) - n3 <= n3 - n2 && n4 - n3 <= this.maxTempSlots) {
            this.mergeHi(n2, n3, n4);
            return;
        }
        if (n3 - n2 <= this.maxTempSlots) {
            this.mergeLo(n2, n3, n4);
            return;
        }
        this.mergeInPlace(n2, n3, n4);
    }

    @Override
    public void sort(int n2, int n3) {
        this.checkRange(n2, n3);
        if (n3 - n2 <= 1) {
            return;
        }
        this.reset(n2, n3);
        do {
            this.ensureInvariants();
            this.pushRunLen(this.nextRun());
        } while (this.runEnd(0) < n3);
        this.exhaustStack();
        assert (this.runEnd(0) == n3);
    }

    @Override
    void doRotate(int n2, int n3, int n4) {
        int n5 = n3 - n2;
        int n6 = n4 - n3;
        if (n5 == n6) {
            while (n3 < n4) {
                this.swap(n2++, n3++);
            }
        } else {
            if (n6 < n5 && n6 <= this.maxTempSlots) {
                this.save(n3, n6);
                n3 = n2 + n5 - 1;
                n5 = n4 - 1;
                while (n3 >= n2) {
                    this.copy(n3, n5);
                    --n3;
                    --n5;
                }
                n3 = 0;
                n5 = n2;
                while (n3 < n6) {
                    this.restore(n3, n5);
                    ++n3;
                    ++n5;
                }
                return;
            }
            if (n5 <= this.maxTempSlots) {
                this.save(n2, n5);
                n5 = n2;
                while (n3 < n4) {
                    this.copy(n3, n5);
                    ++n3;
                    ++n5;
                }
                n3 = 0;
                for (n5 = n2 + n6; n5 < n4; ++n5) {
                    this.restore(n3, n5);
                    ++n3;
                }
                return;
            }
            this.reverse(n2, n3);
            this.reverse(n3, n4);
            this.reverse(n2, n4);
        }
    }

    void mergeLo(int n2, int n3, int n4) {
        assert (this.compare(n2, n3) > 0);
        int n5 = n3 - n2;
        this.save(n2, n5);
        this.copy(n3, n2);
        int n6 = 0;
        ++n3;
        ++n2;
        block0: while (true) {
            int n7;
            for (n7 = 0; n7 < 7; ++n7) {
                if (n6 >= n5 || n3 >= n4) break block0;
                if (this.compareSaved(n6, n3) <= 0) {
                    this.restore(n6++, n2++);
                    continue;
                }
                this.copy(n3++, n2++);
            }
            n7 = this.lowerSaved3(n3, n4, n6);
            while (n3 < n7) {
                this.copy(n3++, n2);
                ++n2;
            }
            this.restore(n6++, n2++);
        }
        while (n6 < n5) {
            this.restore(n6++, n2);
            ++n2;
        }
        assert (n3 == n2);
    }

    void mergeHi(int n2, int n3, int n4) {
        assert (this.compare(n3 - 1, n4 - 1) > 0);
        int n5 = n4 - n3;
        this.save(n3, n5);
        this.copy(n3 - 1, n4 - 1);
        n3 -= 2;
        --n5;
        n4 -= 2;
        block0: while (true) {
            int n6;
            for (n6 = 0; n6 < 7; ++n6) {
                if (n3 < n2 || n5 < 0) break block0;
                if (this.compareSaved(n5, n3) >= 0) {
                    this.restore(n5--, n4--);
                    continue;
                }
                this.copy(n3--, n4--);
            }
            n6 = this.upperSaved3(n2, n3 + 1, n5);
            while (n3 >= n6) {
                this.copy(n3--, n4--);
            }
            this.restore(n5--, n4--);
        }
        while (n5 >= 0) {
            this.restore(n5--, n4);
            --n4;
        }
        assert (n3 == n4);
    }

    int lowerSaved(int n2, int n3, int n4) {
        n3 -= n2;
        while (n3 > 0) {
            int n5 = n3 >>> 1;
            int n6 = n2 + n5;
            if (this.compareSaved(n4, n6) > 0) {
                n2 = n6 + 1;
                n3 = n3 - n5 - 1;
                continue;
            }
            n3 = n5;
        }
        return n2;
    }

    int upperSaved(int n2, int n3, int n4) {
        n3 -= n2;
        while (n3 > 0) {
            int n5 = n3 >>> 1;
            int n6 = n2 + n5;
            if (this.compareSaved(n4, n6) < 0) {
                n3 = n5;
                continue;
            }
            n2 = n6 + 1;
            n3 = n3 - n5 - 1;
        }
        return n2;
    }

    int lowerSaved3(int n2, int n3, int n4) {
        int n5 = n2++;
        while (n2 < n3) {
            if (this.compareSaved(n4, n2) <= 0) {
                return this.lowerSaved(n5, n2, n4);
            }
            int n6 = n2 - n5;
            n5 = n2;
            n2 += n6 << 1;
        }
        return this.lowerSaved(n5, n3, n4);
    }

    int upperSaved3(int n2, int n3, int n4) {
        int n5;
        for (int i2 = n3 - 1; i2 > n2; i2 -= n5 << 1) {
            if (this.compareSaved(n4, i2) >= 0) {
                return this.upperSaved(i2, n3, n4);
            }
            n5 = n3 - i2;
            n3 = i2;
        }
        return this.upperSaved(n2, n3, n4);
    }

    protected abstract void copy(int var1, int var2);

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    protected abstract int compareSaved(int var1, int var2);
}

