/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Properties;
import org.apache.lucene.portmobile.file.Files;
import org.apache.lucene.portmobile.file.Paths;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;

public abstract class StringHelper {
    public static final int GOOD_FAST_HASH_SEED;
    private static BigInteger nextId;
    private static final BigInteger mask128;
    private static final Object idLock;

    public static int bytesDifference(BytesRef bytesRef, BytesRef bytesRef2) {
        int n2 = bytesRef.length < bytesRef2.length ? bytesRef.length : bytesRef2.length;
        byte[] byArray = bytesRef.bytes;
        int n3 = bytesRef.offset;
        byte[] byArray2 = bytesRef2.bytes;
        int n4 = bytesRef2.offset;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2 + n3] == byArray2[i2 + n4]) continue;
            return i2;
        }
        return n2;
    }

    public static int sortKeyLength(BytesRef bytesRef, BytesRef bytesRef2) {
        int n2 = bytesRef2.offset;
        int n3 = bytesRef.offset;
        int n4 = Math.min(bytesRef.length, bytesRef2.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if (bytesRef.bytes[n3 + i2] == bytesRef2.bytes[n2 + i2]) continue;
            return i2 + 1;
        }
        return Math.min(1 + bytesRef.length, bytesRef2.length);
    }

    private StringHelper() {
    }

    public static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static boolean startsWith(byte[] byArray, BytesRef bytesRef) {
        if (byArray.length < bytesRef.length) {
            return false;
        }
        for (int i2 = 0; i2 < bytesRef.length; ++i2) {
            if (byArray[i2] == bytesRef.bytes[bytesRef.offset + i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(BytesRef bytesRef, BytesRef bytesRef2) {
        return StringHelper.sliceEquals(bytesRef, bytesRef2, 0);
    }

    public static boolean endsWith(BytesRef bytesRef, BytesRef bytesRef2) {
        return StringHelper.sliceEquals(bytesRef, bytesRef2, bytesRef.length - bytesRef2.length);
    }

    private static boolean sliceEquals(BytesRef bytesRef, BytesRef bytesRef2, int n2) {
        if (n2 < 0 || bytesRef.length - n2 < bytesRef2.length) {
            return false;
        }
        n2 = bytesRef.offset + n2;
        int n3 = bytesRef2.offset;
        int n4 = bytesRef2.offset + bytesRef2.length;
        while (n3 < n4) {
            if (bytesRef.bytes[n2++] == bytesRef2.bytes[n3++]) continue;
            return false;
        }
        return true;
    }

    public static int murmurhash3_x86_32(byte[] byArray, int n2, int n3, int n4) {
        int n5 = n2 + (n3 & 0xFFFFFFFC);
        while (n2 < n5) {
            int n6 = Integer.rotateLeft((byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | byArray[n2 + 3] << 24) * -862048943, 15) * 461845907;
            n4 = Integer.rotateLeft(n4 ^ n6, 13) * 5 + -430675100;
            n2 += 4;
        }
        n2 = 0;
        switch (n3 & 3) {
            case 3: {
                n2 = (byArray[n5 + 2] & 0xFF) << 16;
            }
            case 2: {
                n2 |= (byArray[n5 + 1] & 0xFF) << 8;
            }
            case 1: {
                n2 = Integer.rotateLeft((n2 | byArray[n5] & 0xFF) * -862048943, 15) * 461845907;
                n4 ^= n2;
            }
        }
        int n7 = n4 ^ n3;
        int n8 = (n7 ^ n7 >>> 16) * -2048144789;
        int n9 = (n8 ^ n8 >>> 13) * -1028477387;
        return n9 ^ n9 >>> 16;
    }

    public static int murmurhash3_x86_32(BytesRef bytesRef, int n2) {
        return StringHelper.murmurhash3_x86_32(bytesRef.bytes, bytesRef.offset, bytesRef.length, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] randomId() {
        byte[] byArray;
        Object object = idLock;
        synchronized (object) {
            byArray = nextId.toByteArray();
            nextId = nextId.add(BigInteger.ONE).and(mask128);
        }
        if (byArray.length > 16) {
            assert (byArray.length == 17);
            assert (byArray[0] == 0);
            return Arrays.copyOfRange(byArray, 1, byArray.length);
        }
        object = new byte[16];
        System.arraycopy(byArray, 0, object, 16 - byArray.length, byArray.length);
        return object;
    }

    public static String idToString(byte[] byArray) {
        if (byArray == null) {
            return "(null)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(new BigInteger(1, byArray).toString(36));
        if (byArray.length != 16) {
            stringBuilder.append(" (INVALID FORMAT)");
        }
        return stringBuilder.toString();
    }

    public static BytesRef intsRefToBytesRef(IntsRef intsRef) {
        byte[] byArray = new byte[intsRef.length];
        for (int i2 = 0; i2 < intsRef.length; ++i2) {
            int n2 = intsRef.ints[intsRef.offset + i2];
            if (n2 < 0 || n2 > 255) {
                throw new IllegalArgumentException("int at pos=" + i2 + " with value=" + n2 + " is out-of-bounds for byte");
            }
            byArray[i2] = (byte)n2;
        }
        return new BytesRef(byArray);
    }

    static {
        Serializable serializable;
        long l2;
        long l3;
        Object object = System.getProperty("tests.seed");
        GOOD_FAST_HASH_SEED = object != null ? ((String)object).hashCode() : (int)System.currentTimeMillis();
        idLock = new Object();
        byte[] byArray = new byte[16];
        object = byArray;
        Arrays.fill(byArray, (byte)-1);
        mask128 = new BigInteger(1, (byte[])object);
        object = System.getProperty("tests.seed");
        if (object != null) {
            if (((String)object).length() > 8) {
                object = ((String)object).substring(((String)object).length() - 8);
            }
            l2 = l3 = Long.parseLong((String)object, 16);
        } else {
            Serializable serializable2;
            try {
                object = new DataInputStream(Files.newInputStream(Paths.get("/dev/urandom")));
                serializable2 = null;
                try {
                    l3 = ((DataInputStream)object).readLong();
                    l2 = ((DataInputStream)object).readLong();
                }
                catch (Throwable throwable) {
                    try {
                        Throwable throwable2 = throwable;
                        serializable2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (serializable2 != null) {
                            try {
                                ((FilterInputStream)object).close();
                            }
                            catch (Throwable throwable4) {
                                ((Throwable)serializable2).addSuppressed(throwable4);
                            }
                        } else {
                            ((FilterInputStream)object).close();
                        }
                        throw throwable3;
                    }
                }
                ((FilterInputStream)object).close();
            }
            catch (Exception exception) {
                l3 = System.nanoTime();
                l2 = StringHelper.class.hashCode() << 32;
                serializable2 = new StringBuilder();
                try {
                    serializable = System.getProperties();
                    for (String string : ((Properties)serializable).stringPropertyNames()) {
                        ((StringBuilder)serializable2).append(string);
                        ((StringBuilder)serializable2).append(((Properties)serializable).getProperty(string));
                    }
                    l2 |= (long)((StringBuilder)serializable2).toString().hashCode();
                }
                catch (SecurityException securityException) {
                    l2 |= (long)StringBuffer.class.hashCode();
                }
            }
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            long l4;
            long l5 = l3;
            l3 = l4 = l2;
            l5 ^= l5 << 23;
            l2 = l5 ^ l4 ^ l5 >>> 17 ^ l4 >>> 26;
        }
        byte[] byArray2 = new byte[8];
        Arrays.fill(byArray2, (byte)-1);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        serializable = BigInteger.valueOf(l3).and(bigInteger);
        BigInteger bigInteger2 = BigInteger.valueOf(l2).and(bigInteger);
        nextId = ((BigInteger)serializable).shiftLeft(64).or(bigInteger2);
    }
}

