/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public abstract class Sorter {
    protected Sorter() {
    }

    protected abstract int compare(int var1, int var2);

    protected abstract void swap(int var1, int var2);

    public abstract void sort(int var1, int var2);

    void checkRange(int n2, int n3) {
        if (n3 < n2) {
            throw new IllegalArgumentException("'to' must be >= 'from', got from=" + n2 + " and to=" + n3);
        }
    }

    void mergeInPlace(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (n2 == n3 || n3 == n4 || this.compare(n3 - 1, n3) <= 0) {
            return;
        }
        if (n4 - n2 == 2) {
            this.swap(n3 - 1, n3);
            return;
        }
        while (this.compare(n2, n3) <= 0) {
            ++n2;
        }
        while (this.compare(n3 - 1, n4 - 1) <= 0) {
            --n4;
        }
        if (n3 - n2 > n4 - n3) {
            n7 = n3 - n2 >>> 1;
            n7 = n2 + n7;
            n6 = this.lower(n3, n4, n7);
            n5 = n6 - n3;
        } else {
            n5 = n4 - n3 >>> 1;
            n6 = n3 + n5;
            n7 = this.upper(n2, n3, n6);
        }
        this.rotate(n7, n3, n6);
        n3 = n7 + n5;
        this.mergeInPlace(n2, n7, n3);
        this.mergeInPlace(n3, n6, n4);
    }

    int lower(int n2, int n3, int n4) {
        n3 -= n2;
        while (n3 > 0) {
            int n5 = n3 >>> 1;
            int n6 = n2 + n5;
            if (this.compare(n6, n4) < 0) {
                n2 = n6 + 1;
                n3 = n3 - n5 - 1;
                continue;
            }
            n3 = n5;
        }
        return n2;
    }

    int upper(int n2, int n3, int n4) {
        n3 -= n2;
        while (n3 > 0) {
            int n5 = n3 >>> 1;
            int n6 = n2 + n5;
            if (this.compare(n4, n6) < 0) {
                n3 = n5;
                continue;
            }
            n2 = n6 + 1;
            n3 = n3 - n5 - 1;
        }
        return n2;
    }

    int lower2(int n2, int n3, int n4) {
        int n5;
        for (int i2 = n3 - 1; i2 > n2; i2 -= n5 << 1) {
            if (this.compare(i2, n4) < 0) {
                return this.lower(i2, n3, n4);
            }
            n5 = n3 - i2;
            n3 = i2;
        }
        return this.lower(n2, n3, n4);
    }

    int upper2(int n2, int n3, int n4) {
        int n5 = n2++;
        while (n2 < n3) {
            if (this.compare(n2, n4) > 0) {
                return this.upper(n5, n2, n4);
            }
            int n6 = n2 - n5;
            n5 = n2;
            n2 += n6 << 1;
        }
        return this.upper(n5, n3, n4);
    }

    final void reverse(int n2, int n3) {
        --n3;
        while (n2 < n3) {
            this.swap(n2, n3);
            ++n2;
            --n3;
        }
    }

    final void rotate(int n2, int n3, int n4) {
        assert (n2 <= n3 && n3 <= n4);
        if (n2 == n3 || n3 == n4) {
            return;
        }
        this.doRotate(n2, n3, n4);
    }

    void doRotate(int n2, int n3, int n4) {
        if (n3 - n2 == n4 - n3) {
            while (n3 < n4) {
                this.swap(n2++, n3++);
            }
        } else {
            this.reverse(n2, n3);
            this.reverse(n3, n4);
            this.reverse(n2, n4);
        }
    }

    void insertionSort(int n2, int n3) {
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            for (int i3 = i2; i3 > n2 && this.compare(i3 - 1, i3) > 0; --i3) {
                this.swap(i3 - 1, i3);
            }
        }
    }

    void binarySort(int n2, int n3, int n4) {
        while (n4 < n3) {
            int n5;
            int n6 = n2;
            int n7 = n4 - 1;
            while (n6 <= n7) {
                n5 = n6 + n7 >>> 1;
                if (this.compare(n4, n5) < 0) {
                    n7 = n5 - 1;
                    continue;
                }
                n6 = n5 + 1;
            }
            switch (n4 - n6) {
                case 2: {
                    this.swap(n6 + 1, n6 + 2);
                    this.swap(n6, n6 + 1);
                    break;
                }
                case 1: {
                    this.swap(n6, n6 + 1);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    for (n5 = n4; n5 > n6; --n5) {
                        this.swap(n5 - 1, n5);
                    }
                }
            }
            ++n4;
        }
    }

    void heapSort(int n2, int n3) {
        if (n3 - n2 <= 1) {
            return;
        }
        this.heapify(n2, n3);
        --n3;
        while (n3 > n2) {
            this.swap(n2, n3);
            this.siftDown(n2, n2, n3);
            --n3;
        }
    }

    void heapify(int n2, int n3) {
        for (int i2 = Sorter.heapParent(n2, n3 - 1); i2 >= n2; --i2) {
            this.siftDown(i2, n2, n3);
        }
    }

    void siftDown(int n2, int n3, int n4) {
        int n5 = Sorter.heapChild(n3, n2);
        while (n5 < n4) {
            int n6 = n5 + 1;
            if (this.compare(n2, n5) < 0) {
                if (n6 < n4 && this.compare(n5, n6) < 0) {
                    this.swap(n2, n6);
                    n2 = n6;
                } else {
                    this.swap(n2, n5);
                    n2 = n5;
                }
            } else {
                if (n6 >= n4 || this.compare(n2, n6) >= 0) break;
                this.swap(n2, n6);
                n2 = n6;
            }
            n5 = Sorter.heapChild(n3, n2);
        }
    }

    static int heapParent(int n2, int n3) {
        return (n3 - 1 - n2 >>> 1) + n2;
    }

    static int heapChild(int n2, int n3) {
        return (n3 - n2 << 1) + 1 + n2;
    }
}

