/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.BitUtil;

public class SentinelIntSet {
    public int[] keys;
    public int count;
    public final int emptyVal;
    public int rehashCount;

    public SentinelIntSet(int n2, int n3) {
        this.emptyVal = n3;
        int n4 = Math.max(BitUtil.nextHighestPowerOfTwo(n2), 1);
        this.rehashCount = n4 - (n4 >> 2);
        if (n2 >= this.rehashCount) {
            this.rehashCount = (n4 <<= 1) - (n4 >> 2);
        }
        this.keys = new int[n4];
        if (n3 != 0) {
            this.clear();
        }
    }

    public void clear() {
        Arrays.fill(this.keys, this.emptyVal);
        this.count = 0;
    }

    public int hash(int n2) {
        return n2;
    }

    public int getSlot(int n2) {
        assert (n2 != this.emptyVal);
        int n3 = this.hash(n2);
        int n4 = n3 & this.keys.length - 1;
        if (this.keys[n4] == n2 || this.keys[n4] == this.emptyVal) {
            return n4;
        }
        n3 = n3 >> 7 | 1;
        while (this.keys[n4 = n4 + n3 & this.keys.length - 1] != n2 && this.keys[n4] != this.emptyVal) {
        }
        return n4;
    }

    public int find(int n2) {
        assert (n2 != this.emptyVal);
        int n3 = this.hash(n2);
        int n4 = n3 & this.keys.length - 1;
        if (this.keys[n4] == n2) {
            return n4;
        }
        if (this.keys[n4] == this.emptyVal) {
            return -n4 - 1;
        }
        n3 = n3 >> 7 | 1;
        do {
            if (this.keys[n4 = n4 + n3 & this.keys.length - 1] != n2) continue;
            return n4;
        } while (this.keys[n4] != this.emptyVal);
        return -n4 - 1;
    }

    public boolean exists(int n2) {
        return this.find(n2) >= 0;
    }

    public int put(int n2) {
        int n3 = this.find(n2);
        if (n3 < 0) {
            ++this.count;
            if (this.count >= this.rehashCount) {
                this.rehash();
                n3 = this.getSlot(n2);
            } else {
                n3 = -n3 - 1;
            }
            this.keys[n3] = n2;
        }
        return n3;
    }

    public void rehash() {
        int n2 = this.keys.length << 1;
        int[] nArray = this.keys;
        this.keys = new int[n2];
        if (this.emptyVal != 0) {
            Arrays.fill(this.keys, this.emptyVal);
        }
        for (int n3 : nArray) {
            if (n3 == this.emptyVal) continue;
            int n4 = this.getSlot(n3);
            this.keys[n4] = n3;
        }
        this.rehashCount = n2 - (n2 >> 2);
    }
}

