/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;

public final class SPIClassIterator<S>
implements Iterator<Class<? extends S>> {
    private static final Map<String, List<String>> hardCodedServices = new HashMap<String, List<String>>();
    private final Class<S> clazz;
    private final ClassLoader loader;
    private boolean loaded;
    private Iterator<String> linesIterator;

    public static <S> SPIClassIterator<S> get(Class<S> clazz, ClassLoader classLoader) {
        return new SPIClassIterator<S>(clazz, classLoader);
    }

    public static boolean isParentClassLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        while (classLoader2 != null) {
            if (classLoader2 == classLoader) {
                return true;
            }
            classLoader2 = classLoader2.getParent();
        }
        return false;
    }

    private SPIClassIterator(Class<S> clazz, ClassLoader classLoader) {
        this.clazz = clazz;
        List<String> list = hardCodedServices.get(clazz.getName());
        if (list == null || list.isEmpty()) {
            throw new ServiceConfigurationError("Error loading SPI profiles for type " + clazz.getName() + " from hard-coded services");
        }
        this.loader = classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader;
        this.linesIterator = Collections.emptySet().iterator();
        this.loaded = false;
    }

    private boolean loadNextProfile() {
        if (this.loaded) {
            return false;
        }
        this.loaded = true;
        this.linesIterator = hardCodedServices.get(this.clazz.getName()).iterator();
        return true;
    }

    @Override
    public final boolean hasNext() {
        return this.linesIterator.hasNext() || this.loadNextProfile();
    }

    @Override
    public final Class<? extends S> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        assert (this.linesIterator.hasNext());
        String string = this.linesIterator.next();
        try {
            return Class.forName(string, false, this.loader).asSubclass(this.clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ServiceConfigurationError(String.format(Locale.ROOT, "An SPI class of type %s with classname %s does not exist.", this.clazz.getName(), string));
        }
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        hardCodedServices.put("org.apache.lucene.codecs.Codec", arrayList);
        arrayList.add("org.apache.lucene.codecs.lucene53.Lucene53Codec");
        arrayList = new ArrayList();
        hardCodedServices.put("org.apache.lucene.codecs.DocValuesFormat", arrayList);
        arrayList.add("org.apache.lucene.codecs.lucene50.Lucene50DocValuesFormat");
        arrayList = new ArrayList();
        hardCodedServices.put("org.apache.lucene.codecs.PostingsFormat", arrayList);
        arrayList.add("org.apache.lucene.codecs.lucene50.Lucene50PostingsFormat");
    }
}

