/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.a;

public final class RamUsageEstimator {
    public static final boolean COMPRESSED_REFS_ENABLED;
    public static final int NUM_BYTES_OBJECT_REF;
    public static final int NUM_BYTES_OBJECT_HEADER;
    public static final int NUM_BYTES_ARRAY_HEADER;
    public static final int NUM_BYTES_OBJECT_ALIGNMENT;
    private static final Map<Class<?>, Integer> primitiveSizes;
    static final long LONG_CACHE_MIN_VALUE;
    static final long LONG_CACHE_MAX_VALUE;
    static final int LONG_SIZE;
    static final boolean JVM_IS_HOTSPOT_64BIT;

    public static long alignObjectSize(long l2) {
        long l3 = l2 + ((long)NUM_BYTES_OBJECT_ALIGNMENT - 1L);
        return l3 - l3 % (long)NUM_BYTES_OBJECT_ALIGNMENT;
    }

    public static long sizeOf(byte[] byArray) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)byArray.length);
    }

    public static long sizeOf(short[] sArray) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 2L * (long)sArray.length);
    }

    public static long sizeOf(int[] nArray) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 4L * (long)nArray.length);
    }

    public static long sizeOf(float[] fArray) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 4L * (long)fArray.length);
    }

    public static long sizeOf(long[] lArray) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + 8L * (long)lArray.length);
    }

    public static long shallowSizeOf(Object[] objectArray) {
        return RamUsageEstimator.alignObjectSize((long)NUM_BYTES_ARRAY_HEADER + (long)NUM_BYTES_OBJECT_REF * (long)objectArray.length);
    }

    public static long shallowSizeOf(Object object) {
        if (object == null) {
            return 0L;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return RamUsageEstimator.shallowSizeOfArray(object);
        }
        return RamUsageEstimator.shallowSizeOfInstance(clazz);
    }

    public static long shallowSizeOfInstance(Class<?> clazz) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("This method does not work with array classes.");
        }
        if (clazz.isPrimitive()) {
            return primitiveSizes.get(clazz).intValue();
        }
        long l2 = NUM_BYTES_OBJECT_HEADER;
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                l2 = RamUsageEstimator.adjustForField(l2, field);
            }
            clazz = clazz.getSuperclass();
        }
        return RamUsageEstimator.alignObjectSize(l2);
    }

    private static long shallowSizeOfArray(Object clazz) {
        long l2 = NUM_BYTES_ARRAY_HEADER;
        int n2 = Array.getLength(clazz);
        if (n2 > 0) {
            l2 = (clazz = clazz.getClass().getComponentType()).isPrimitive() ? (l2 += (long)n2 * (long)primitiveSizes.get(clazz).intValue()) : (l2 += (long)NUM_BYTES_OBJECT_REF * (long)n2);
        }
        return RamUsageEstimator.alignObjectSize(l2);
    }

    static long adjustForField(long l2, Field annotatedElement) {
        int n2 = ((Class)(annotatedElement = annotatedElement.getType())).isPrimitive() ? primitiveSizes.get(annotatedElement) : NUM_BYTES_OBJECT_REF;
        return l2 + (long)n2;
    }

    public static long sizeOf(a[] aArray) {
        long l2 = RamUsageEstimator.shallowSizeOf(aArray);
        for (a a2 : aArray) {
            if (a2 == null) continue;
            l2 += a2.ramBytesUsed();
        }
        return l2;
    }

    static {
        long l2;
        long l3;
        primitiveSizes = new IdentityHashMap();
        primitiveSizes.put(Boolean.TYPE, 1);
        primitiveSizes.put(Byte.TYPE, 1);
        primitiveSizes.put(Character.TYPE, 2);
        primitiveSizes.put(Short.TYPE, 2);
        primitiveSizes.put(Integer.TYPE, 4);
        primitiveSizes.put(Float.TYPE, 4);
        primitiveSizes.put(Double.TYPE, 8);
        primitiveSizes.put(Long.TYPE, 8);
        if (Constants.JRE_IS_64BIT) {
            boolean bl;
            int n2;
            boolean bl2;
            block10: {
                bl2 = false;
                n2 = 8;
                bl = false;
                try {
                    Object object;
                    GenericDeclaration genericDeclaration = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                    Object object2 = Class.forName("java.lang.management.ManagementFactory").getMethod("getPlatformMXBean", Class.class).invoke(null, genericDeclaration);
                    if (object2 == null) break block10;
                    bl = true;
                    genericDeclaration = ((Class)genericDeclaration).getMethod("getVMOption", String.class);
                    try {
                        object = ((Method)genericDeclaration).invoke(object2, "UseCompressedOops");
                        bl2 = Boolean.parseBoolean(object.getClass().getMethod("getValue", new Class[0]).invoke(object, new Object[0]).toString());
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    try {
                        object = ((Method)genericDeclaration).invoke(object2, "ObjectAlignmentInBytes");
                        n2 = Integer.parseInt(object.getClass().getMethod("getValue", new Class[0]).invoke(object, new Object[0]).toString());
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            JVM_IS_HOTSPOT_64BIT = bl;
            COMPRESSED_REFS_ENABLED = bl2;
            NUM_BYTES_OBJECT_ALIGNMENT = n2;
            NUM_BYTES_OBJECT_REF = COMPRESSED_REFS_ENABLED ? 4 : 8;
            NUM_BYTES_OBJECT_HEADER = 8 + NUM_BYTES_OBJECT_REF;
            NUM_BYTES_ARRAY_HEADER = (int)RamUsageEstimator.alignObjectSize(NUM_BYTES_OBJECT_HEADER + 4);
        } else {
            JVM_IS_HOTSPOT_64BIT = false;
            COMPRESSED_REFS_ENABLED = false;
            NUM_BYTES_OBJECT_ALIGNMENT = 8;
            NUM_BYTES_OBJECT_REF = 4;
            NUM_BYTES_OBJECT_HEADER = 8;
            NUM_BYTES_ARRAY_HEADER = 12;
        }
        for (l3 = 0L; l3 > Long.MIN_VALUE && Long.valueOf(l3 - 1L) == Long.valueOf(l3 - 1L); --l3) {
        }
        for (l2 = -1L; l2 < Long.MAX_VALUE && Long.valueOf(l2 + 1L) == Long.valueOf(l2 + 1L); ++l2) {
        }
        LONG_CACHE_MIN_VALUE = l3;
        LONG_CACHE_MAX_VALUE = l2;
        LONG_SIZE = (int)RamUsageEstimator.shallowSizeOfInstance(Long.class);
    }
}

