/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;

public final class PagedBytes
implements a {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(PagedBytes.class);
    private byte[][] blocks = new byte[16][];
    private int numBlocks;
    private final int blockSize;
    private final int blockBits;
    private final int blockMask;
    private boolean didSkipBytes;
    private boolean frozen;
    private int upto;
    private byte[] currentBlock;
    private final long bytesUsedPerBlock;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public PagedBytes(int n2) {
        assert (n2 > 0 && n2 <= 31) : n2;
        this.blockSize = 1 << n2;
        this.blockBits = n2;
        this.blockMask = this.blockSize - 1;
        this.upto = this.blockSize;
        this.bytesUsedPerBlock = RamUsageEstimator.alignObjectSize(this.blockSize + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER);
        this.numBlocks = 0;
    }

    private void addBlock(byte[] byArray) {
        if (this.blocks.length == this.numBlocks) {
            this.blocks = (byte[][])Arrays.copyOf(this.blocks, ArrayUtil.oversize(this.numBlocks, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        this.blocks[this.numBlocks++] = byArray;
    }

    public final void copy(IndexInput indexInput, long l2) throws IOException {
        while (l2 > 0L) {
            int n2 = this.blockSize - this.upto;
            if (n2 == 0) {
                if (this.currentBlock != null) {
                    this.addBlock(this.currentBlock);
                }
                this.currentBlock = new byte[this.blockSize];
                this.upto = 0;
                n2 = this.blockSize;
            }
            if ((long)n2 < l2) {
                indexInput.readBytes(this.currentBlock, this.upto, n2, false);
                this.upto = this.blockSize;
                l2 -= (long)n2;
                continue;
            }
            indexInput.readBytes(this.currentBlock, this.upto, (int)l2, false);
            this.upto = (int)((long)this.upto + l2);
            return;
        }
    }

    public final Reader freeze(boolean bl) {
        if (this.frozen) {
            throw new IllegalStateException("already frozen");
        }
        if (this.didSkipBytes) {
            throw new IllegalStateException("cannot freeze when copy(BytesRef, BytesRef) was used");
        }
        if (bl && this.upto < this.blockSize) {
            byte[] byArray = new byte[this.upto];
            System.arraycopy(this.currentBlock, 0, byArray, 0, this.upto);
            this.currentBlock = byArray;
        }
        if (this.currentBlock == null) {
            this.currentBlock = EMPTY_BYTES;
        }
        this.addBlock(this.currentBlock);
        this.frozen = true;
        this.currentBlock = null;
        return new Reader(this);
    }

    public final long getPointer() {
        if (this.currentBlock == null) {
            return 0L;
        }
        return (long)this.numBlocks * (long)this.blockSize + (long)this.upto;
    }

    @Override
    public final long ramBytesUsed() {
        long l2 = BASE_RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf((Object[])this.blocks);
        if (this.numBlocks > 0) {
            l2 = l2 + (long)(this.numBlocks - 1) * this.bytesUsedPerBlock + RamUsageEstimator.sizeOf(this.blocks[this.numBlocks - 1]);
        }
        if (this.currentBlock != null) {
            l2 += RamUsageEstimator.sizeOf(this.currentBlock);
        }
        return l2;
    }

    @Override
    public final Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    public final long copyUsingLengthPrefix(BytesRef bytesRef) {
        if (bytesRef.length >= 32768) {
            throw new IllegalArgumentException("max length is 32767 (got " + bytesRef.length + ")");
        }
        if (this.upto + bytesRef.length + 2 > this.blockSize) {
            if (bytesRef.length + 2 > this.blockSize) {
                throw new IllegalArgumentException("block size " + this.blockSize + " is too small to store length " + bytesRef.length + " bytes");
            }
            if (this.currentBlock != null) {
                this.addBlock(this.currentBlock);
            }
            this.currentBlock = new byte[this.blockSize];
            this.upto = 0;
        }
        long l2 = this.getPointer();
        if (bytesRef.length < 128) {
            this.currentBlock[this.upto++] = (byte)bytesRef.length;
        } else {
            this.currentBlock[this.upto++] = (byte)(0x80 | bytesRef.length >> 8);
            this.currentBlock[this.upto++] = (byte)bytesRef.length;
        }
        System.arraycopy(bytesRef.bytes, bytesRef.offset, this.currentBlock, this.upto, bytesRef.length);
        this.upto += bytesRef.length;
        return l2;
    }

    public final PagedBytesDataInput getDataInput() {
        if (!this.frozen) {
            throw new IllegalStateException("must call freeze() before getDataInput");
        }
        return new PagedBytesDataInput();
    }

    public final PagedBytesDataOutput getDataOutput() {
        if (this.frozen) {
            throw new IllegalStateException("cannot get DataOutput after freeze()");
        }
        return new PagedBytesDataOutput();
    }

    static /* synthetic */ byte[] access$802(PagedBytes pagedBytes, byte[] byArray) {
        pagedBytes.currentBlock = byArray;
        return byArray;
    }

    public final class PagedBytesDataOutput
    extends DataOutput {
        @Override
        public final void writeByte(byte by) {
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    PagedBytes.this.addBlock(PagedBytes.this.currentBlock);
                }
                PagedBytes.access$802(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
            }
            ((PagedBytes)PagedBytes.this).currentBlock[((PagedBytes)PagedBytes.this).upto++] = by;
        }

        @Override
        public final void writeBytes(byte[] byArray, int n2, int n3) {
            int n4;
            assert (byArray.length >= n2 + n3);
            if (n3 == 0) {
                return;
            }
            if (PagedBytes.this.upto == PagedBytes.this.blockSize) {
                if (PagedBytes.this.currentBlock != null) {
                    PagedBytes.this.addBlock(PagedBytes.this.currentBlock);
                }
                PagedBytes.access$802(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
            }
            n3 = n2 + n3;
            while (true) {
                n4 = n3 - n2;
                int n5 = PagedBytes.this.blockSize - PagedBytes.this.upto;
                if (n5 >= n4) break;
                System.arraycopy(byArray, n2, PagedBytes.this.currentBlock, PagedBytes.this.upto, n5);
                PagedBytes.this.addBlock(PagedBytes.this.currentBlock);
                PagedBytes.access$802(PagedBytes.this, new byte[PagedBytes.this.blockSize]);
                PagedBytes.this.upto = 0;
                n2 += n5;
            }
            System.arraycopy(byArray, n2, PagedBytes.this.currentBlock, PagedBytes.this.upto, n4);
            PagedBytes.this.upto = PagedBytes.this.upto + n4;
        }
    }

    public final class PagedBytesDataInput
    extends DataInput {
        private int currentBlockIndex;
        private int currentBlockUpto;
        private byte[] currentBlock;

        PagedBytesDataInput() {
            this.currentBlock = PagedBytes.this.blocks[0];
        }

        @Override
        public final PagedBytesDataInput clone() {
            PagedBytesDataInput pagedBytesDataInput = PagedBytes.this.getDataInput();
            pagedBytesDataInput.setPosition(this.getPosition());
            return pagedBytesDataInput;
        }

        public final long getPosition() {
            return (long)this.currentBlockIndex * (long)PagedBytes.this.blockSize + (long)this.currentBlockUpto;
        }

        public final void setPosition(long l2) {
            this.currentBlockIndex = (int)(l2 >> PagedBytes.this.blockBits);
            this.currentBlock = PagedBytes.this.blocks[this.currentBlockIndex];
            this.currentBlockUpto = (int)(l2 & (long)PagedBytes.this.blockMask);
        }

        @Override
        public final byte readByte() {
            if (this.currentBlockUpto == PagedBytes.this.blockSize) {
                this.nextBlock();
            }
            return this.currentBlock[this.currentBlockUpto++];
        }

        @Override
        public final void readBytes(byte[] byArray, int n2, int n3) {
            int n4;
            int n5;
            assert (byArray.length >= n2 + n3);
            n3 = n2 + n3;
            while ((n5 = PagedBytes.this.blockSize - this.currentBlockUpto) < (n4 = n3 - n2)) {
                System.arraycopy(this.currentBlock, this.currentBlockUpto, byArray, n2, n5);
                this.nextBlock();
                n2 += n5;
            }
            System.arraycopy(this.currentBlock, this.currentBlockUpto, byArray, n2, n4);
            this.currentBlockUpto += n4;
        }

        private void nextBlock() {
            ++this.currentBlockIndex;
            this.currentBlockUpto = 0;
            this.currentBlock = PagedBytes.this.blocks[this.currentBlockIndex];
        }
    }

    public static final class Reader
    implements a {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Reader.class);
        private final byte[][] blocks;
        private final int blockBits;
        private final int blockMask;
        private final int blockSize;
        private final long bytesUsedPerBlock;

        private Reader(PagedBytes pagedBytes) {
            this.blocks = (byte[][])Arrays.copyOf(pagedBytes.blocks, pagedBytes.numBlocks);
            this.blockBits = pagedBytes.blockBits;
            this.blockMask = pagedBytes.blockMask;
            this.blockSize = pagedBytes.blockSize;
            this.bytesUsedPerBlock = pagedBytes.bytesUsedPerBlock;
        }

        public final void fill(BytesRef bytesRef, long l2) {
            int n2 = (int)(l2 >> this.blockBits);
            int n3 = (int)(l2 & (long)this.blockMask);
            bytesRef.bytes = this.blocks[n2];
            byte[] byArray = bytesRef.bytes;
            if ((bytesRef.bytes[n3] & 0x80) == 0) {
                bytesRef.length = byArray[n3];
                bytesRef.offset = n3 + 1;
                return;
            }
            bytesRef.length = (byArray[n3] & 0x7F) << 8 | byArray[n3 + 1] & 0xFF;
            bytesRef.offset = n3 + 2;
            assert (bytesRef.length > 0);
        }

        @Override
        public final long ramBytesUsed() {
            long l2 = BASE_RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf((Object[])this.blocks);
            if (this.blocks.length > 0) {
                l2 = l2 + (long)(this.blocks.length - 1) * this.bytesUsedPerBlock + RamUsageEstimator.sizeOf(this.blocks[this.blocks.length - 1]);
            }
            return l2;
        }

        @Override
        public final Collection<a> getChildResources() {
            return Collections.emptyList();
        }

        public final String toString() {
            return "PagedBytes(blocksize=" + this.blockSize + ")";
        }
    }
}

