/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.apache.lucene.util.SPIClassIterator;

public final class NamedSPILoader<S extends a>
implements Iterable<S> {
    private volatile Map<String, S> services = Collections.emptyMap();
    private final Class<S> clazz;

    public NamedSPILoader(Class<S> clazz) {
        this(clazz, Thread.currentThread().getContextClassLoader());
    }

    public NamedSPILoader(Class<S> object, ClassLoader classLoader) {
        this.clazz = object;
        object = ((Class)object).getClassLoader();
        if (object != null && !SPIClassIterator.isParentClassLoader((ClassLoader)object, classLoader)) {
            this.reload((ClassLoader)object);
        }
        this.reload(classLoader);
    }

    public final void reload(ClassLoader object) {
        LinkedHashMap<String, S> linkedHashMap = new LinkedHashMap<String, S>(this.services);
        object = SPIClassIterator.get(this.clazz, (ClassLoader)object);
        while (((SPIClassIterator)object).hasNext()) {
            Object object2 = ((SPIClassIterator)object).next();
            try {
                a a2 = (a)((Class)object2).newInstance();
                String string = a2.getName();
                if (linkedHashMap.containsKey(string)) continue;
                NamedSPILoader.checkServiceName(string);
                linkedHashMap.put(string, a2);
            }
            catch (Exception exception) {
                throw new ServiceConfigurationError("Cannot instantiate SPI class: " + ((Class)object2).getName(), exception);
            }
        }
        this.services = Collections.unmodifiableMap(linkedHashMap);
    }

    public static void checkServiceName(String string) {
        if (string.length() >= 128) {
            throw new IllegalArgumentException("Illegal service name: '" + string + "' is too long (must be < 128 chars).");
        }
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (NamedSPILoader.isLetterOrDigit(string.charAt(i2))) continue;
            throw new IllegalArgumentException("Illegal service name: '" + string + "' must be simple ascii alphanumeric.");
        }
    }

    private static boolean isLetterOrDigit(char c2) {
        return 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9';
    }

    public final S lookup(String string) {
        a a2 = (a)this.services.get(string);
        if (a2 != null) {
            return (S)a2;
        }
        throw new IllegalArgumentException("An SPI class of type " + this.clazz.getName() + " with name '" + string + "' does not exist.  You need to add the corresponding JAR file supporting this SPI to your classpath.  The current classpath supports the following names: " + this.availableServices());
    }

    public final Set<String> availableServices() {
        return this.services.keySet();
    }

    @Override
    public final Iterator<S> iterator() {
        return this.services.values().iterator();
    }

    public static interface a {
        public String getName();
    }
}

