/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.util.PriorityQueue;

public final class MergedIterator<T extends Comparable<T>>
implements Iterator<T> {
    private T current;
    private final a<T> queue;
    private final SubIterator<T>[] top;
    private final boolean removeDuplicates;
    private int numTop;

    public MergedIterator(Iterator<T> ... iteratorArray) {
        this(true, iteratorArray);
    }

    public MergedIterator(boolean bl, Iterator<T> ... iteratorArray) {
        this.removeDuplicates = bl;
        this.queue = new a(iteratorArray.length);
        this.top = new SubIterator[iteratorArray.length];
        bl = false;
        for (Iterator<T> iterator : iteratorArray) {
            if (!iterator.hasNext()) continue;
            SubIterator subIterator = new SubIterator();
            new SubIterator().current = (Comparable)iterator.next();
            subIterator.iterator = iterator;
            subIterator.index = bl++ ? 1 : 0;
            this.queue.add(subIterator);
        }
    }

    @Override
    public final boolean hasNext() {
        if (this.queue.size() > 0) {
            return true;
        }
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            if (!this.top[i2].iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.current;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private void pullTop() {
        assert (this.numTop == 0);
        this.top[this.numTop++] = (SubIterator)this.queue.pop();
        if (this.removeDuplicates) {
            while (this.queue.size() != 0 && ((SubIterator)this.queue.top()).current.equals(this.top[0].current)) {
                this.top[this.numTop++] = (SubIterator)this.queue.pop();
            }
        }
        this.current = this.top[0].current;
    }

    private void pushTop() {
        for (int i2 = 0; i2 < this.numTop; ++i2) {
            if (this.top[i2].iterator.hasNext()) {
                this.top[i2].current = (Comparable)this.top[i2].iterator.next();
                this.queue.add(this.top[i2]);
                continue;
            }
            this.top[i2].current = null;
        }
        this.numTop = 0;
    }

    private static final class a<C extends Comparable<C>>
    extends PriorityQueue<SubIterator<C>> {
        a(int n2) {
            super(n2);
        }

        @Override
        protected final /* synthetic */ boolean lessThan(Object object, Object object2) {
            object2 = (SubIterator)object2;
            object = (SubIterator)object;
            int n2 = ((SubIterator)object).current.compareTo(((SubIterator)object2).current);
            if (n2 != 0) {
                return n2 < 0;
            }
            return ((SubIterator)object).index < ((SubIterator)object2).index;
        }
    }

    private static class SubIterator<I extends Comparable<I>> {
        Iterator<I> iterator;
        I current;
        int index;

        private SubIterator() {
        }
    }
}

