/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class LongsRef
implements Cloneable,
Comparable<LongsRef> {
    public static final long[] EMPTY_LONGS = new long[0];
    public long[] longs;
    public int offset;
    public int length;

    public LongsRef() {
        this.longs = EMPTY_LONGS;
    }

    public LongsRef(int n2) {
        this.longs = new long[n2];
    }

    public LongsRef(long[] lArray, int n2, int n3) {
        this.longs = lArray;
        this.offset = n2;
        this.length = n3;
        assert (this.isValid());
    }

    public final LongsRef clone() {
        return new LongsRef(this.longs, this.offset, this.length);
    }

    public final int hashCode() {
        int n2 = 0;
        long l2 = this.offset + this.length;
        int n3 = this.offset;
        while ((long)n3 < l2) {
            n2 = n2 * 31 + (int)(this.longs[n3] ^ this.longs[n3] >>> 32);
            ++n3;
        }
        return n2;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof LongsRef) {
            return this.longsEquals((LongsRef)object);
        }
        return false;
    }

    public final boolean longsEquals(LongsRef object) {
        if (this.length == ((LongsRef)object).length) {
            int n2 = ((LongsRef)object).offset;
            object = ((LongsRef)object).longs;
            long l2 = this.offset + this.length;
            int n3 = this.offset;
            while ((long)n3 < l2) {
                if (this.longs[n3] != object[n2]) {
                    return false;
                }
                ++n3;
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public final int compareTo(LongsRef longsRef) {
        if (this == longsRef) {
            return 0;
        }
        long[] lArray = this.longs;
        int n2 = this.offset;
        long[] lArray2 = longsRef.longs;
        int n3 = longsRef.offset;
        long l2 = n2 + Math.min(this.length, longsRef.length);
        while ((long)n2 < l2) {
            long l3;
            long l4;
            if ((l4 = lArray[n2++]) > (l3 = lArray2[n3++])) {
                return 1;
            }
            if (l4 >= l3) continue;
            return -1;
        }
        return this.length - longsRef.length;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        long l2 = this.offset + this.length;
        int n2 = this.offset;
        while ((long)n2 < l2) {
            if (n2 > this.offset) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Long.toHexString(this.longs[n2]));
            ++n2;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final boolean isValid() {
        if (this.longs == null) {
            throw new IllegalStateException("longs is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.longs.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",longs.length=" + this.longs.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.longs.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",longs.length=" + this.longs.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.longs.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",longs.length=" + this.longs.length);
        }
        return true;
    }
}

