/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.BitUtil;

public final class LongBitSet {
    private final long[] bits;
    private final long numBits;
    private final int numWords;

    public static int bits2words(long l2) {
        return (int)(l2 - 1L >> 6) + 1;
    }

    public LongBitSet(long l2) {
        this.numBits = l2;
        this.bits = new long[LongBitSet.bits2words(l2)];
        this.numWords = this.bits.length;
    }

    public LongBitSet(long[] lArray, long l2) {
        this.numWords = LongBitSet.bits2words(l2);
        if (this.numWords > lArray.length) {
            throw new IllegalArgumentException("The given long array is too small  to hold " + l2 + " bits");
        }
        this.numBits = l2;
        this.bits = lArray;
        assert (this.verifyGhostBitsClear());
    }

    private boolean verifyGhostBitsClear() {
        for (int i2 = this.numWords; i2 < this.bits.length; ++i2) {
            if (this.bits[i2] == 0L) continue;
            return false;
        }
        if ((this.numBits & 0x3FL) == 0L) {
            return true;
        }
        long l2 = -1L << (int)this.numBits;
        return (this.bits[this.numWords - 1] & l2) == 0L;
    }

    public final long cardinality() {
        return BitUtil.pop_array(this.bits, 0, this.numWords);
    }

    public final boolean get(long l2) {
        assert (l2 >= 0L && l2 < this.numBits) : "index=" + l2 + ", numBits=" + this.numBits;
        int n2 = (int)(l2 >> 6);
        long l3 = 1L << (int)l2;
        return (this.bits[n2] & l3) != 0L;
    }

    public final void set(long l2) {
        assert (l2 >= 0L && l2 < this.numBits) : "index=" + l2 + " numBits=" + this.numBits;
        int n2 = (int)(l2 >> 6);
        long l3 = 1L << (int)l2;
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | l3;
    }

    public final LongBitSet clone() {
        long[] lArray = new long[this.bits.length];
        System.arraycopy(this.bits, 0, lArray, 0, this.numWords);
        return new LongBitSet(lArray, this.numBits);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongBitSet)) {
            return false;
        }
        object = (LongBitSet)object;
        if (this.numBits != ((LongBitSet)object).numBits) {
            return false;
        }
        return Arrays.equals(this.bits, ((LongBitSet)object).bits);
    }

    public final int hashCode() {
        long l2 = 0L;
        int n2 = this.numWords;
        while (--n2 >= 0) {
            l2 ^= this.bits[n2];
            l2 = l2 << 1 | l2 >>> 63;
        }
        return (int)(l2 >> 32 ^ l2) + -1737092556;
    }
}

