/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;

final class LSBRadixSorter {
    private final int[] histogram = new int[256];
    private int[] buffer = new int[0];

    LSBRadixSorter() {
    }

    private static void buildHistogram(int[] nArray, int n2, int n3, int[] nArray2, int n4) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5;
            int n6 = n5 = nArray[n2 + i2] >>> n4 & 0xFF;
            nArray2[n6] = nArray2[n6] + 1;
        }
    }

    private static void sumHistogram(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            int n3 = nArray[i2];
            nArray[i2] = n2;
            n2 += n3;
        }
    }

    private static void reorder(int[] nArray, int n2, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6;
            int n7 = nArray[n2 + i2];
            int n8 = n6 = n7 >>> n4 & 0xFF;
            int n9 = nArray2[n8];
            nArray2[n8] = n9 + 1;
            nArray3[n5 + n9] = n7;
        }
    }

    private static boolean sort(int[] nArray, int n2, int n3, int[] nArray2, int n4, int[] nArray3, int n5) {
        Arrays.fill(nArray2, 0);
        LSBRadixSorter.buildHistogram(nArray, n2, n3, nArray2, n4);
        if (nArray2[0] == n3) {
            return false;
        }
        LSBRadixSorter.sumHistogram(nArray2);
        LSBRadixSorter.reorder(nArray, n2, n3, nArray2, n4, nArray3, n5);
        return true;
    }

    private static void insertionSort(int[] nArray, int n2, int n3) {
        n3 = n2 + n3;
        for (int i2 = n2 + 1; i2 < n3; ++i2) {
            for (int i3 = i2; i3 > n2 && nArray[i3 - 1] > nArray[i3]; --i3) {
                int n4 = nArray[i3 - 1];
                nArray[i3 - 1] = nArray[i3];
                nArray[i3] = n4;
            }
        }
    }

    public final void sort(int[] nArray, int n2, int n3) {
        if (n3 < 30) {
            LSBRadixSorter.insertionSort(nArray, n2, n3);
            return;
        }
        this.buffer = ArrayUtil.grow(this.buffer, n3);
        int[] nArray2 = nArray;
        int n4 = n2;
        int[] nArray3 = this.buffer;
        int n5 = 0;
        for (int i2 = 0; i2 <= 24; i2 += 8) {
            if (!LSBRadixSorter.sort(nArray2, n4, n3, this.histogram, i2, nArray3, n5)) continue;
            int[] nArray4 = nArray2;
            int n6 = n4;
            nArray2 = nArray3;
            n4 = n5;
            nArray3 = nArray4;
            n5 = n6;
        }
        if (nArray == nArray3) {
            System.arraycopy(nArray2, n4, nArray, n2, n3);
        }
    }
}

