/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class IntsRef
implements Cloneable,
Comparable<IntsRef> {
    public static final int[] EMPTY_INTS = new int[0];
    public int[] ints;
    public int offset;
    public int length;

    public IntsRef() {
        this.ints = EMPTY_INTS;
    }

    public IntsRef(int[] nArray, int n2, int n3) {
        this.ints = nArray;
        this.offset = n2;
        this.length = n3;
        assert (this.isValid());
    }

    public final IntsRef clone() {
        return new IntsRef(this.ints, this.offset, this.length);
    }

    public final int hashCode() {
        int n2 = 0;
        int n3 = this.offset + this.length;
        for (int i2 = this.offset; i2 < n3; ++i2) {
            n2 = n2 * 31 + this.ints[i2];
        }
        return n2;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IntsRef) {
            return this.intsEquals((IntsRef)object);
        }
        return false;
    }

    public final boolean intsEquals(IntsRef object) {
        if (this.length == ((IntsRef)object).length) {
            int n2 = ((IntsRef)object).offset;
            object = ((IntsRef)object).ints;
            int n3 = this.offset + this.length;
            int n4 = this.offset;
            while (n4 < n3) {
                if (this.ints[n4] != object[n2]) {
                    return false;
                }
                ++n4;
                ++n2;
            }
            return true;
        }
        return false;
    }

    @Override
    public final int compareTo(IntsRef intsRef) {
        if (this == intsRef) {
            return 0;
        }
        int[] nArray = this.ints;
        int n2 = this.offset;
        int[] nArray2 = intsRef.ints;
        int n3 = intsRef.offset;
        int n4 = n2 + Math.min(this.length, intsRef.length);
        while (n2 < n4) {
            int n5;
            int n6;
            if ((n6 = nArray[n2++]) > (n5 = nArray2[n3++])) {
                return 1;
            }
            if (n6 >= n5) continue;
            return -1;
        }
        return this.length - intsRef.length;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = this.offset + this.length;
        for (int i2 = this.offset; i2 < n2; ++i2) {
            if (i2 > this.offset) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Integer.toHexString(this.ints[i2]));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final boolean isValid() {
        if (this.ints == null) {
            throw new IllegalStateException("ints is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.ints.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",ints.length=" + this.ints.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.ints.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",ints.length=" + this.ints.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.ints.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",ints.length=" + this.ints.length);
        }
        return true;
    }
}

