/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.i;

public final class FixedBitSet
extends BitSet
implements a,
i {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
    private final long[] bits;
    private final int numBits;
    private final int numWords;

    public static FixedBitSet ensureCapacity(FixedBitSet object, int n2) {
        if (n2 < ((FixedBitSet)object).numBits) {
            return object;
        }
        if ((n2 = FixedBitSet.bits2words(n2)) >= ((Object)(object = (Object)((FixedBitSet)object).getBits())).length) {
            object = ArrayUtil.grow((long[])object, n2 + 1);
        }
        return new FixedBitSet((long[])object, ((Object)object).length << 6);
    }

    public static int bits2words(int n2) {
        return (n2 - 1 >> 6) + 1;
    }

    public FixedBitSet(int n2) {
        this.numBits = n2;
        this.bits = new long[FixedBitSet.bits2words(n2)];
        this.numWords = this.bits.length;
    }

    public FixedBitSet(long[] lArray, int n2) {
        this.numWords = FixedBitSet.bits2words(n2);
        if (this.numWords > lArray.length) {
            throw new IllegalArgumentException("The given long array is too small  to hold " + n2 + " bits");
        }
        this.numBits = n2;
        this.bits = lArray;
        assert (this.verifyGhostBitsClear());
    }

    private boolean verifyGhostBitsClear() {
        for (int i2 = this.numWords; i2 < this.bits.length; ++i2) {
            if (this.bits[i2] == 0L) continue;
            return false;
        }
        if ((this.numBits & 0x3F) == 0) {
            return true;
        }
        long l2 = -1L << this.numBits;
        return (this.bits[this.numWords - 1] & l2) == 0L;
    }

    @Override
    public final int length() {
        return this.numBits;
    }

    @Override
    public final long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.bits);
    }

    public final long[] getBits() {
        return this.bits;
    }

    @Override
    public final int cardinality() {
        return (int)BitUtil.pop_array(this.bits, 0, this.numWords);
    }

    @Override
    public final boolean get(int n2) {
        assert (n2 >= 0 && n2 < this.numBits) : "index=" + n2 + ", numBits=" + this.numBits;
        int n3 = n2 >> 6;
        long l2 = 1L << n2;
        return (this.bits[n3] & l2) != 0L;
    }

    @Override
    public final void set(int n2) {
        assert (n2 >= 0 && n2 < this.numBits) : "index=" + n2 + ", numBits=" + this.numBits;
        int n3 = n2 >> 6;
        long l2 = 1L << n2;
        int n4 = n3;
        this.bits[n4] = this.bits[n4] | l2;
    }

    @Override
    public final void clear(int n2) {
        assert (n2 >= 0 && n2 < this.numBits) : "index=" + n2 + ", numBits=" + this.numBits;
        int n3 = n2 >> 6;
        long l2 = 1L << n2;
        int n4 = n3;
        this.bits[n4] = this.bits[n4] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public final int nextSetBit(int n2) {
        assert (n2 >= 0 && n2 < this.numBits) : "index=" + n2 + ", numBits=" + this.numBits;
        int n3 = n2 >> 6;
        long l2 = this.bits[n3] >> n2;
        if (l2 != 0L) {
            return n2 + Long.numberOfTrailingZeros(l2);
        }
        while (++n3 < this.numWords) {
            l2 = this.bits[n3];
            if (l2 == 0L) continue;
            return (n3 << 6) + Long.numberOfTrailingZeros(l2);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public final void or(DocIdSetIterator object) throws IOException {
        if (BitSetIterator.getFixedBitSetOrNull((DocIdSetIterator)object) != null) {
            this.assertUnpositioned((DocIdSetIterator)object);
            object = BitSetIterator.getFixedBitSetOrNull((DocIdSetIterator)object);
            this.or((FixedBitSet)object);
            return;
        }
        super.or((DocIdSetIterator)object);
    }

    public final void or(FixedBitSet fixedBitSet) {
        this.or(fixedBitSet.bits, fixedBitSet.numWords);
    }

    private void or(long[] lArray, int n2) {
        assert (n2 <= this.numWords) : "numWords=" + this.numWords + ", otherNumWords=" + n2;
        long[] lArray2 = this.bits;
        n2 = Math.min(this.numWords, n2);
        while (--n2 >= 0) {
            int n3 = n2;
            lArray2[n3] = lArray2[n3] | lArray[n2];
        }
    }

    public final boolean intersects(FixedBitSet fixedBitSet) {
        int n2 = Math.min(this.numWords, fixedBitSet.numWords);
        while (--n2 >= 0) {
            if ((this.bits[n2] & fixedBitSet.bits[n2]) == 0L) continue;
            return true;
        }
        return false;
    }

    public final void set(int n2, int n3) {
        assert (n2 >= 0 && n2 < this.numBits) : "startIndex=" + n2 + ", numBits=" + this.numBits;
        assert (n3 >= 0 && n3 <= this.numBits) : "endIndex=" + n3 + ", numBits=" + this.numBits;
        if (n3 <= n2) {
            return;
        }
        int n4 = n2 >> 6;
        int n5 = n3 - 1 >> 6;
        long l2 = -1L << n2;
        long l3 = -1L >>> -n3;
        if (n4 == n5) {
            int n6 = n4;
            this.bits[n6] = this.bits[n6] | l2 & l3;
            return;
        }
        int n7 = n4;
        this.bits[n7] = this.bits[n7] | l2;
        Arrays.fill(this.bits, n4 + 1, n5, -1L);
        int n8 = n5;
        this.bits[n8] = this.bits[n8] | l3;
    }

    public final void clear(int n2, int n3) {
        assert (n2 >= 0 && n2 < this.numBits) : "startIndex=" + n2 + ", numBits=" + this.numBits;
        assert (n3 >= 0 && n3 <= this.numBits) : "endIndex=" + n3 + ", numBits=" + this.numBits;
        if (n3 <= n2) {
            return;
        }
        int n4 = n2 >> 6;
        int n5 = n3 - 1 >> 6;
        long l2 = -1L << n2;
        long l3 = -1L >>> -n3;
        l2 ^= 0xFFFFFFFFFFFFFFFFL;
        l3 ^= 0xFFFFFFFFFFFFFFFFL;
        if (n4 == n5) {
            int n6 = n4;
            this.bits[n6] = this.bits[n6] & (l2 | l3);
            return;
        }
        int n7 = n4;
        this.bits[n7] = this.bits[n7] & l2;
        Arrays.fill(this.bits, n4 + 1, n5, 0L);
        int n8 = n5;
        this.bits[n8] = this.bits[n8] & l3;
    }

    public final FixedBitSet clone() {
        long[] lArray = new long[this.bits.length];
        System.arraycopy(this.bits, 0, lArray, 0, this.numWords);
        return new FixedBitSet(lArray, this.numBits);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FixedBitSet)) {
            return false;
        }
        object = (FixedBitSet)object;
        if (this.numBits != ((FixedBitSet)object).numBits) {
            return false;
        }
        return Arrays.equals(this.bits, ((FixedBitSet)object).bits);
    }

    public final int hashCode() {
        long l2 = 0L;
        int n2 = this.numWords;
        while (--n2 >= 0) {
            l2 ^= this.bits[n2];
            l2 = l2 << 1 | l2 >>> 63;
        }
        return (int)(l2 >> 32 ^ l2) + -1737092556;
    }
}

