/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntArrayDocIdSet;
import org.apache.lucene.util.LSBRadixSorter;

public final class DocIdSetBuilder {
    private final int maxDoc;
    private final int threshold;
    private int[] buffer;
    private int bufferSize;
    private BitSet bitSet;

    public DocIdSetBuilder(int n2) {
        this.maxDoc = n2;
        this.threshold = n2 >>> 7;
        this.buffer = new int[0];
        this.bufferSize = 0;
        this.bitSet = null;
    }

    private void upgradeToBitSet() {
        assert (this.bitSet == null);
        this.bitSet = new FixedBitSet(this.maxDoc);
        for (int i2 = 0; i2 < this.bufferSize; ++i2) {
            this.bitSet.set(this.buffer[i2]);
        }
        this.buffer = null;
        this.bufferSize = 0;
    }

    private void growBuffer(int n2) {
        assert (n2 < this.threshold);
        if (this.buffer.length < n2) {
            int[] nArray = new int[Math.min(this.threshold, ArrayUtil.oversize(n2, 4))];
            System.arraycopy(this.buffer, 0, nArray, 0, this.buffer.length);
            this.buffer = nArray;
        }
    }

    public final void add(DocIdSetIterator docIdSetIterator) throws IOException {
        int n2;
        this.grow((int)Math.min(Integer.MAX_VALUE, docIdSetIterator.cost()));
        if (this.bitSet != null) {
            this.bitSet.or(docIdSetIterator);
            return;
        }
        while (true) {
            assert (this.buffer.length <= this.threshold);
            n2 = this.buffer.length;
            for (int i2 = this.bufferSize; i2 < n2; ++i2) {
                int n3 = docIdSetIterator.nextDoc();
                if (n3 == Integer.MAX_VALUE) {
                    this.bufferSize = i2;
                    return;
                }
                this.buffer[this.bufferSize++] = n3;
            }
            this.bufferSize = n2;
            if (this.bufferSize + 1 >= this.threshold) break;
            this.growBuffer(this.bufferSize + 1);
        }
        this.upgradeToBitSet();
        n2 = docIdSetIterator.nextDoc();
        while (n2 != Integer.MAX_VALUE) {
            this.bitSet.set(n2);
            n2 = docIdSetIterator.nextDoc();
        }
    }

    public final void grow(int n2) {
        if (this.bitSet == null) {
            long l2 = this.bufferSize + n2;
            if (l2 < (long)this.threshold) {
                this.growBuffer((int)l2);
                return;
            }
            this.upgradeToBitSet();
        }
    }

    private static int dedup(int[] nArray, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 1;
        int n4 = nArray[0];
        for (int i2 = 1; i2 < n2; ++i2) {
            int n5 = nArray[i2];
            assert (n5 >= n4);
            if (n5 == n4) continue;
            nArray[n3++] = n5;
            n4 = n5;
        }
        return n3;
    }

    public final DocIdSet build() {
        return this.build(-1L);
    }

    public final DocIdSet build(long l2) {
        try {
            if (this.bitSet != null) {
                if (l2 == -1L) {
                    BitDocIdSet bitDocIdSet = new BitDocIdSet(this.bitSet);
                    return bitDocIdSet;
                }
                BitDocIdSet bitDocIdSet = new BitDocIdSet(this.bitSet, l2);
                return bitDocIdSet;
            }
            new LSBRadixSorter().sort(this.buffer, 0, this.bufferSize);
            int n2 = DocIdSetBuilder.dedup(this.buffer, this.bufferSize);
            assert (n2 <= this.bufferSize);
            this.buffer = ArrayUtil.grow(this.buffer, n2 + 1);
            this.buffer[n2] = Integer.MAX_VALUE;
            IntArrayDocIdSet intArrayDocIdSet = new IntArrayDocIdSet(this.buffer, n2);
            return intArrayDocIdSet;
        }
        finally {
            this.buffer = null;
            this.bufferSize = 0;
            this.bitSet = null;
        }
    }
}

