/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.concurrent.atomic.AtomicLong;

public abstract class Counter {
    public abstract long addAndGet(long var1);

    public abstract long get();

    public static Counter newCounter() {
        return Counter.newCounter(false);
    }

    public static Counter newCounter(boolean bl) {
        if (bl) {
            return new AtomicCounter();
        }
        return new SerialCounter();
    }

    private static final class AtomicCounter
    extends Counter {
        private final AtomicLong count = new AtomicLong();

        private AtomicCounter() {
        }

        @Override
        public final long addAndGet(long l2) {
            return this.count.addAndGet(l2);
        }

        @Override
        public final long get() {
            return this.count.get();
        }
    }

    private static final class SerialCounter
    extends Counter {
        private long count = 0L;

        private SerialCounter() {
        }

        @Override
        public final long addAndGet(long l2) {
            return this.count += l2;
        }

        @Override
        public final long get() {
            return this.count;
        }
    }
}

