/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.TimSorter;
import org.apache.lucene.util.g;

public final class CollectionUtil {
    public static <T> void a(List<T> list, Comparator<? super T> comparator) {
        int n2 = list.size();
        if (n2 <= 1) {
            return;
        }
        new ListIntroSorter<T>(list, comparator).sort(0, n2);
    }

    public static <T> void b(List<T> list, Comparator<? super T> comparator) {
        int n2 = list.size();
        if (n2 <= 1) {
            return;
        }
        new ListTimSorter<T>(list, comparator, list.size() / 64).sort(0, n2);
    }

    public static <T extends Comparable<? super T>> void a(List<T> list) {
        if (list.size() <= 1) {
            return;
        }
        CollectionUtil.b(list, ArrayUtil.naturalComparator());
    }

    private static final class ListTimSorter<T>
    extends TimSorter {
        final List<T> list;
        final Comparator<? super T> comp;
        final T[] tmp;

        ListTimSorter(List<T> list, Comparator<? super T> comparator, int n2) {
            super(n2);
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
            }
            this.list = list;
            this.comp = comparator;
            if (n2 > 0) {
                this.tmp = new Object[n2];
                return;
            }
            this.tmp = null;
        }

        @Override
        protected final void swap(int n2, int n3) {
            Collections.swap(this.list, n2, n3);
        }

        @Override
        protected final void copy(int n2, int n3) {
            this.list.set(n3, this.list.get(n2));
        }

        @Override
        protected final void save(int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.tmp[i2] = this.list.get(n2 + i2);
            }
        }

        @Override
        protected final void restore(int n2, int n3) {
            this.list.set(n3, this.tmp[n2]);
        }

        @Override
        protected final int compare(int n2, int n3) {
            return this.comp.compare(this.list.get(n2), this.list.get(n3));
        }

        @Override
        protected final int compareSaved(int n2, int n3) {
            return this.comp.compare(this.tmp[n2], this.list.get(n3));
        }
    }

    private static final class ListIntroSorter<T>
    extends g {
        T pivot;
        final List<T> list;
        final Comparator<? super T> comp;

        ListIntroSorter(List<T> list, Comparator<? super T> comparator) {
            if (!(list instanceof RandomAccess)) {
                throw new IllegalArgumentException("CollectionUtil can only sort random access lists in-place.");
            }
            this.list = list;
            this.comp = comparator;
        }

        @Override
        protected final void setPivot(int n2) {
            this.pivot = this.list.get(n2);
        }

        @Override
        protected final void swap(int n2, int n3) {
            Collections.swap(this.list, n2, n3);
        }

        @Override
        protected final int compare(int n2, int n3) {
            return this.comp.compare(this.list.get(n2), this.list.get(n3));
        }

        @Override
        protected final int comparePivot(int n2) {
            return this.comp.compare(this.pivot, this.list.get(n2));
        }
    }
}

