/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;

public final class ByteBlockPool {
    public byte[][] buffers = new byte[10][];
    private int bufferUpto = -1;
    public int byteUpto = 32768;
    public byte[] buffer;
    public int byteOffset = Short.MIN_VALUE;
    private final Allocator allocator;
    public static final int[] NEXT_LEVEL_ARRAY = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
    public static final int[] LEVEL_SIZE_ARRAY = new int[]{5, 14, 20, 30, 40, 40, 80, 80, 120, 200};
    public static final int FIRST_LEVEL_SIZE = LEVEL_SIZE_ARRAY[0];

    public ByteBlockPool(Allocator allocator) {
        this.allocator = allocator;
    }

    public final void reset(boolean n2, boolean bl) {
        if (this.bufferUpto != -1) {
            if (n2 != 0) {
                for (n2 = 0; n2 < this.bufferUpto; ++n2) {
                    Arrays.fill(this.buffers[n2], (byte)0);
                }
                Arrays.fill(this.buffers[this.bufferUpto], 0, this.byteUpto, (byte)0);
            }
            if (this.bufferUpto > 0 || !bl) {
                n2 = bl ? 1 : 0;
                this.allocator.recycleByteBlocks(this.buffers, n2, 1 + this.bufferUpto);
                Arrays.fill((Object[])this.buffers, n2, 1 + this.bufferUpto, null);
            }
            if (bl) {
                this.bufferUpto = 0;
                this.byteUpto = 0;
                this.byteOffset = 0;
                this.buffer = this.buffers[0];
                return;
            }
            this.bufferUpto = -1;
            this.byteUpto = 32768;
            this.byteOffset = Short.MIN_VALUE;
            this.buffer = null;
        }
    }

    public final void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            byte[][] byArrayArray = new byte[ArrayUtil.oversize(this.buffers.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(this.buffers, 0, byArrayArray, 0, this.buffers.length);
            this.buffers = byArrayArray;
        }
        byte[] byArray = this.allocator.getByteBlock();
        this.buffers[1 + this.bufferUpto] = byArray;
        this.buffer = byArray;
        ++this.bufferUpto;
        this.byteUpto = 0;
        this.byteOffset += 32768;
    }

    public final int newSlice(int n2) {
        if (this.byteUpto > 32768 - n2) {
            this.nextBuffer();
        }
        int n3 = this.byteUpto;
        this.byteUpto += n2;
        this.buffer[this.byteUpto - 1] = 16;
        return n3;
    }

    public final int allocSlice(byte[] byArray, int n2) {
        int n3 = byArray[n2] & 0xF;
        int n4 = LEVEL_SIZE_ARRAY[n3 = NEXT_LEVEL_ARRAY[n3]];
        if (this.byteUpto > 32768 - n4) {
            this.nextBuffer();
        }
        int n5 = this.byteUpto;
        int n6 = n5 + this.byteOffset;
        this.byteUpto += n4;
        this.buffer[n5] = byArray[n2 - 3];
        this.buffer[n5 + 1] = byArray[n2 - 2];
        this.buffer[n5 + 2] = byArray[n2 - 1];
        byArray[n2 - 3] = n6 >> 24;
        byArray[n2 - 2] = (byte)(n6 >>> 16);
        byArray[n2 - 1] = (byte)(n6 >>> 8);
        byArray[n2] = (byte)n6;
        this.buffer[this.byteUpto - 1] = (byte)(0x10 | n3);
        return n5 + 3;
    }

    public final void setBytesRef(BytesRef bytesRef, int n2) {
        bytesRef.bytes = this.buffers[n2 >> 15];
        byte[] byArray = bytesRef.bytes;
        if ((byArray[n2 &= Short.MAX_VALUE] & 0x80) == 0) {
            bytesRef.length = byArray[n2];
            bytesRef.offset = n2 + 1;
        } else {
            bytesRef.length = (byArray[n2] & 0x7F) + ((byArray[n2 + 1] & 0xFF) << 7);
            bytesRef.offset = n2 + 2;
        }
        assert (bytesRef.length >= 0);
    }

    public static class DirectTrackingAllocator
    extends Allocator {
        private final Counter bytesUsed;

        public DirectTrackingAllocator(Counter counter) {
            this(32768, counter);
        }

        public DirectTrackingAllocator(int n2, Counter counter) {
            super(n2);
            this.bytesUsed = counter;
        }

        @Override
        public byte[] getByteBlock() {
            this.bytesUsed.addAndGet(this.blockSize);
            return new byte[this.blockSize];
        }

        @Override
        public void recycleByteBlocks(byte[][] byArray, int n2, int n3) {
            this.bytesUsed.addAndGet(-((n3 - n2) * this.blockSize));
            while (n2 < n3) {
                byArray[n2] = null;
                ++n2;
            }
        }
    }

    public static final class a
    extends Allocator {
        public a() {
            this(0);
        }

        private a(byte by) {
            super(32768);
        }

        @Override
        public final void recycleByteBlocks(byte[][] byArray, int n2, int n3) {
        }
    }

    public static abstract class Allocator {
        protected final int blockSize;

        public Allocator(int n2) {
            this.blockSize = n2;
        }

        public abstract void recycleByteBlocks(byte[][] var1, int var2, int var3);

        public byte[] getByteBlock() {
            return new byte[this.blockSize];
        }
    }
}

