/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.portmobile.invoke.MethodHandle;
import org.apache.lucene.portmobile.invoke.MethodHandles;
import org.apache.lucene.portmobile.invoke.MethodType;
import org.apache.lucene.portmobile.lang.ClassValue;
import org.apache.lucene.util.c;
import org.apache.lucene.util.d;

public abstract class AttributeFactory {
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private static final MethodType NO_ARG_CTOR = MethodType.methodType(Void.TYPE);
    private static final MethodType NO_ARG_RETURNING_ATTRIBUTEIMPL = MethodType.methodType(d.class);
    public static final AttributeFactory DEFAULT_ATTRIBUTE_FACTORY = new DefaultAttributeFactory();

    public abstract d createAttributeInstance(Class<? extends c> var1);

    static final MethodHandle findAttributeImplCtor(Class<? extends d> clazz) {
        try {
            return lookup.findConstructor(clazz, NO_ARG_CTOR).asType(NO_ARG_RETURNING_ATTRIBUTEIMPL);
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new IllegalArgumentException("Cannot lookup accessible no-arg constructor for: " + clazz.getName(), reflectiveOperationException);
        }
    }

    public static <A extends d> AttributeFactory getStaticImplementation(AttributeFactory attributeFactory, Class<A> clazz) {
        final MethodHandle methodHandle = AttributeFactory.findAttributeImplCtor(clazz);
        return new StaticImplementationAttributeFactory<A>(attributeFactory, clazz){

            @Override
            protected final A createInstance() {
                try {
                    return (d)methodHandle.invokeExact();
                }
                catch (Throwable throwable) {
                    1.rethrow(throwable);
                    throw new AssertionError();
                }
            }
        };
    }

    static void rethrow(Throwable throwable) {
        AttributeFactory.rethrow0(throwable);
    }

    private static <T extends Throwable> void rethrow0(Throwable throwable) throws T {
        throw throwable;
    }

    public static abstract class StaticImplementationAttributeFactory<A extends d>
    extends AttributeFactory {
        private final AttributeFactory delegate;
        private final Class<A> clazz;

        public StaticImplementationAttributeFactory(AttributeFactory attributeFactory, Class<A> clazz) {
            this.delegate = attributeFactory;
            this.clazz = clazz;
        }

        @Override
        public final d createAttributeInstance(Class<? extends c> clazz) {
            if (clazz.isAssignableFrom(this.clazz)) {
                return this.createInstance();
            }
            return this.delegate.createAttributeInstance(clazz);
        }

        protected abstract A createInstance();

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            object = (StaticImplementationAttributeFactory)object;
            return this.delegate.equals(((StaticImplementationAttributeFactory)object).delegate) && this.clazz == ((StaticImplementationAttributeFactory)object).clazz;
        }

        public int hashCode() {
            return 31 * this.delegate.hashCode() + this.clazz.hashCode();
        }
    }

    private static final class DefaultAttributeFactory
    extends AttributeFactory {
        private final ClassValue<MethodHandle> constructors = new ClassValue<MethodHandle>(){

            @Override
            protected MethodHandle computeValue(Class<?> clazz) {
                return AttributeFactory.findAttributeImplCtor(DefaultAttributeFactory.this.findImplClass(clazz.asSubclass(c.class)));
            }
        };

        DefaultAttributeFactory() {
        }

        @Override
        public final d createAttributeInstance(Class<? extends c> clazz) {
            try {
                return (d)this.constructors.get(clazz).invokeExact();
            }
            catch (Throwable throwable) {
                DefaultAttributeFactory.rethrow(throwable);
                throw new AssertionError();
            }
        }

        private Class<? extends d> findImplClass(Class<? extends c> clazz) {
            try {
                return Class.forName(clazz.getName() + "Impl", true, clazz.getClassLoader()).asSubclass(d.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Cannot find implementing class for: " + clazz.getName());
            }
        }
    }
}

