/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Comparator;
import org.apache.lucene.util.ArrayIntroSorter;
import org.apache.lucene.util.ArrayTimSorter;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;

public final class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = Integer.MAX_VALUE - RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    private static final Comparator<?> NATURAL_COMPARATOR = new a();

    private ArrayUtil() {
    }

    public static int oversize(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid array size " + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        if (n2 > MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("requested array size " + n2 + " exceeds maximum array in java (" + MAX_ARRAY_LENGTH + ")");
        }
        int n4 = n2 >> 3;
        if (n4 < 3) {
            n4 = 3;
        }
        if ((n2 += n4) + 7 < 0 || n2 + 7 > MAX_ARRAY_LENGTH) {
            return MAX_ARRAY_LENGTH;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (n3) {
                case 4: {
                    return n2 + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return n2 + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return n2 + 7 & 0x7FFFFFF8;
                }
            }
            return n2;
        }
        switch (n3) {
            case 2: {
                return n2 + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return n2 + 3 & 0x7FFFFFFC;
            }
        }
        return n2;
    }

    public static float[] grow(float[] fArray, int n2) {
        assert (n2 >= 0) : "size must be positive (got " + n2 + "): likely integer overflow?";
        if (fArray.length < n2) {
            float[] fArray2 = new float[ArrayUtil.oversize(n2, 4)];
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            return fArray2;
        }
        return fArray;
    }

    public static float[] grow(float[] fArray) {
        return ArrayUtil.grow(fArray, 1 + fArray.length);
    }

    public static int[] grow(int[] nArray, int n2) {
        assert (n2 >= 0) : "size must be positive (got " + n2 + "): likely integer overflow?";
        if (nArray.length < n2) {
            int[] nArray2 = new int[ArrayUtil.oversize(n2, 4)];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    public static int[] grow(int[] nArray) {
        return ArrayUtil.grow(nArray, 1 + nArray.length);
    }

    public static long[] grow(long[] lArray, int n2) {
        assert (n2 >= 0) : "size must be positive (got " + n2 + "): likely integer overflow?";
        if (lArray.length < n2) {
            long[] lArray2 = new long[ArrayUtil.oversize(n2, 8)];
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
            return lArray2;
        }
        return lArray;
    }

    public static byte[] grow(byte[] byArray, int n2) {
        assert (n2 >= 0) : "size must be positive (got " + n2 + "): likely integer overflow?";
        if (byArray.length < n2) {
            byte[] byArray2 = new byte[ArrayUtil.oversize(n2, 1)];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        return byArray;
    }

    public static byte[] grow(byte[] byArray) {
        return ArrayUtil.grow(byArray, 1 + byArray.length);
    }

    public static int hashCode(char[] cArray, int n2, int n3) {
        int n4 = 0;
        --n3;
        while (n3 >= n2) {
            n4 = n4 * 31 + cArray[n3];
            --n3;
        }
        return n4;
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalComparator() {
        return NATURAL_COMPARATOR;
    }

    public static <T> void swap(T[] TArray, int n2, int n3) {
        T t2 = TArray[n2];
        TArray[n2] = TArray[n3];
        TArray[n3] = t2;
    }

    public static <T> void introSort(T[] TArray, int n2, int n3, Comparator<? super T> comparator) {
        if (n3 - n2 <= 1) {
            return;
        }
        new ArrayIntroSorter<T>(TArray, comparator).sort(n2, n3);
    }

    public static <T extends Comparable<? super T>> void introSort(T[] TArray, int n2, int n3) {
        if (n3 - n2 <= 1) {
            return;
        }
        ArrayUtil.introSort(TArray, n2, n3, ArrayUtil.naturalComparator());
    }

    public static <T> void timSort(T[] TArray, int n2, int n3, Comparator<? super T> comparator) {
        if (n3 - n2 <= 1) {
            return;
        }
        new ArrayTimSorter<T>(TArray, comparator, TArray.length / 64).sort(n2, n3);
    }

    public static <T extends Comparable<? super T>> void timSort(T[] TArray, int n2, int n3) {
        if (n3 - n2 <= 1) {
            return;
        }
        ArrayUtil.timSort(TArray, n2, n3, ArrayUtil.naturalComparator());
    }

    public static <T extends Comparable<? super T>> void timSort(T[] TArray) {
        ArrayUtil.timSort(TArray, (int)0, (int)TArray.length);
    }

    private static final class a<T extends Comparable<? super T>>
    implements Comparator<T> {
        a() {
        }

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo((Comparable)object2);
        }
    }
}

